/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public enum CompareEnum {
    YESTERDAY("11"),
    TODAY("13"),
    THISMONTH("63"),
    LAST_MONTH("92"),
    LAST_QUARTER("78"),
    CURRENT_QUARTER("77"),
    LAST_YEAR("68"),
    CURRENT_YEAR("66"),
    LAST_THREE_MONTH("24"),
    THISWEEK("10");

    String id;

    public String getId() {
        return this.id;
    }

    private CompareEnum(String id) {
        this.id = id;
    }

    public static CompareEnum getCompareEnumByID(String id) {
        for (CompareEnum item : CompareEnum.values()) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public String getStartDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date();
        if (this == THISWEEK) {
            time = this.getThisWeekStart();
        } else if (this == THISMONTH) {
            time = this.getThisMonthStart();
        } else if (this == YESTERDAY) {
            time = this.getLastDay();
        } else if (this == TODAY) {
            time = this.getCurrentDay();
        } else if (this == LAST_MONTH) {
            time = this.getLastMonthStart();
        } else if (this == LAST_QUARTER) {
            time = CompareEnum.getLastQuarterStart();
        } else if (this == CURRENT_QUARTER) {
            time = CompareEnum.getCurrentQuarterStart();
        } else if (this == LAST_YEAR) {
            time = CompareEnum.getLastYearStart();
        } else if (this == CURRENT_YEAR) {
            time = CompareEnum.getCurrentYearStart();
        } else if (this == LAST_THREE_MONTH) {
            time = CompareEnum.getLastThreeMonthStart();
        }
        String timeFormat = sdf.format(time);
        return timeFormat;
    }

    public String getEndDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date();
        if (this == THISWEEK) {
            time = this.getThisWeekEnd();
        } else if (this == THISMONTH) {
            time = this.getThisMonthEnd();
        } else if (this == TODAY) {
            time = this.getNextDay();
        } else if (this == YESTERDAY) {
            time = this.getCurrentDay();
        } else if (this == LAST_MONTH) {
            time = this.getLastMonthEnd();
        } else if (this == LAST_QUARTER) {
            time = CompareEnum.getLastQuarterEnd();
        } else if (this == CURRENT_QUARTER) {
            time = CompareEnum.getCurrentQuarterEnd();
        } else if (this == LAST_YEAR) {
            time = CompareEnum.getLastYearEnd();
        } else if (this == CURRENT_YEAR) {
            time = CompareEnum.getCurrentYearEnd();
        } else if (this == LAST_THREE_MONTH) {
            time = CompareEnum.getLastThreeMonthEnd();
        }
        String timeFormat = sdf.format(time);
        return timeFormat;
    }

    private Date getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getNextDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getThisWeekStart() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(7, 2);
        return cal.getTime();
    }

    private Date getThisWeekEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getThisWeekStart());
        cal.add(7, 7);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return cal.getTime();
    }

    private Date getThisMonthStart() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, Calendar.getInstance().getActualMinimum(5));
        return cal.getTime();
    }

    private Date getThisMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, Calendar.getInstance().getActualMaximum(5));
        cal.set(11, 23);
        return cal.getTime();
    }

    private Date getLastMonthStart() {
        return CompareEnum.getMonthStartByNum(-1);
    }

    private Date getLastMonthEnd() {
        return CompareEnum.getMonthEndByNum(0);
    }

    public static Date getLastQuarterStart() {
        return CompareEnum.getMonthStartByNum(-4);
    }

    public static Date getLastQuarterEnd() {
        return CompareEnum.getMonthEndByNum(-1);
    }

    public static Date getCurrentQuarterStart() {
        return CompareEnum.getMonthStartByNum(-1);
    }

    public static Date getCurrentQuarterEnd() {
        return CompareEnum.getMonthEndByNum(2);
    }

    public static Date getMonthStartByNum(int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, month);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getLastThreeMonthStart() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -3);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getLastThreeMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getMonthEndByNum(int month) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, month);
        cal.set(5, 1);
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getLastYearStart() {
        return CompareEnum.getYearStartByNum(-1);
    }

    public static Date getLastYearEnd() {
        return CompareEnum.getYearEndByNum(0);
    }

    public static Date getCurrentYearStart() {
        return CompareEnum.getYearStartByNum(0);
    }

    public static Date getCurrentYearEnd() {
        return CompareEnum.getYearEndByNum(1);
    }

    public static Date getYearStartByNum(int yearNum) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, yearNum);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getYearEndByNum(int yearNum) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, yearNum);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.add(5, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }
}

