/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.service.CommonService;

public class EbgBankVersionFilterContainerPlugin
extends AbstractListPlugin {
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);
    public static final String INIT_CACHE_KEY = "initCacheKey";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("bank_version.id".equals(fieldName)) {
            List<String> bankVersionIDList = this.commonService.getImplBankVersionIdList();
            args.getQfilters().add(new QFilter("number", "in", bankVersionIDList));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = Objects.equals(this.getView().getPageCache().get(INIT_CACHE_KEY), "YES");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.equals("bank_version.name")) continue;
            List<ComboItem> bankVersionItems = this.initBankVersionItemsList();
            List currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(bankVersionItems);
        }
    }

    protected List<ComboItem> initBankVersionItemsList() {
        List<String> bankVersionIDList = this.commonService.getImplBankVersionIdList();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String selectProperties = "id, number, name";
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"aqap_bank", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "in", bankVersionIDList), QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"})}, (String)"sort_num asc");
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                DynamicObject cashAcct = objects[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                items.add(item);
            }
        }
        return items;
    }
}

