/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.CompareEnum;
import kd.ebg.receipt.formplugin.pojo.bizinfo.BankVersionInfo;
import kd.ebg.receipt.formplugin.service.CommonService;
import kd.ebg.receipt.formplugin.service.info.InfoService;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class EbgCommonFilterContainerPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String ENTITY_KEY_BANK_ACNT = "aqap_bank_acnt";
    private static final String ENTITY_KEY_BANK_LOGIN = "aqap_bank_login";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    public SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private FilterContainerInitArgs initArgs;
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);
    public static final String INIT_CACHE_KEY = "initCacheKey";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        ListView view = (ListView)this.getView();
        ControlFilters controlFilters = view.getControlFilters();
        List bankVersionIds = controlFilters.getFilter("bank_version.id");
        List bankLoginIds = controlFilters.getFilter("bank_login.id");
        if ("bank_version.id".equals(fieldName)) {
            List<String> bankVersionIDList = this.commonService.getImplBankVersionIdList();
            if (this.isReconciliation()) {
                bankVersionIDList = this.commonService.getReconciliationBankVersionIdList();
            }
            args.getQfilters().add(new QFilter("number", "in", bankVersionIDList));
        } else if ("bank_login.id".equals(fieldName)) {
            String bankVersionId;
            args.getQfilters().clear();
            if (bankVersionIds.size() > 0 && !"".equals(bankVersionIds.get(0)) && !StringUtil.isNullOrEmpty(bankVersionId = (String)bankVersionIds.get(0))) {
                args.getQfilters().add(new QFilter("group.id", "=", (Object)Long.parseLong(bankVersionId)));
            }
            args.getQfilters().add(new QFilter("enable", "=", (Object)"1"));
            args.getQfilters().add(new QFilter("custom_id", "=", (Object)RequestContext.get().getTenantId()));
            args.getQfilters().add(new QFilter("config_type", "=", (Object)"0"));
        } else if ("acc_no.id".equals(fieldName)) {
            String bankLoginId;
            String bankVersionId;
            args.getQfilters().clear();
            args.getQfilters().add(new QFilter("has_receipt", "=", (Object)"1"));
            args.getQfilters().add(new QFilter("enable", "=", (Object)"1"));
            if (bankVersionIds.size() > 0 && !"".equals(bankVersionIds.get(0)) && !StringUtil.isNullOrEmpty(bankVersionId = (String)bankVersionIds.get(0))) {
                args.getQfilters().add(new QFilter("group.id", "=", (Object)Long.parseLong(bankVersionId)));
            }
            if (bankLoginIds.size() > 0 && !"".equals(bankLoginIds.get(0)) && !StringUtil.isNullOrEmpty(bankLoginId = (String)bankLoginIds.get(0))) {
                args.getQfilters().add(new QFilter("bank_login.id", "=", (Object)Long.parseLong(bankLoginId)));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)ENTITY_KEY_BANK_ACNT)) {
            IDataModel model = this.getModel();
            String bankVersion = (String)model.getDataEntity().get("bank_version.number");
            String bankLogin = (String)model.getDataEntity().get("bank_login.number");
            if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
                model.getDataEntityType().getName();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                QFilter qFilter = new QFilter("group.number", "=", (Object)bankVersion);
                qFilters.add(qFilter);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.setShowApproved(false);
                if (StringUtils.isNotBlank((CharSequence)bankLogin)) {
                    QFilter qFilter2 = new QFilter("bank_login.number", "=", (Object)bankLogin);
                    qFilters.add(qFilter2);
                }
                QFilter qFilter3 = new QFilter("has_receipt", "=", (Object)"1");
                qFilters.add(qFilter3);
                QFilter qFilter4 = new QFilter("enable", "=", (Object)"1");
                qFilters.add(qFilter4);
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object object;
        super.filterContainerSearchClick(args);
        FilterParameter filters = args.getFilterParameter();
        List qList = filters.getQFilters();
        String bankVersionId = "";
        String bankLoginId = "";
        String acntId = "";
        String startDateTime = "";
        String endDateTime = "";
        bankVersionId = String.valueOf(args.getFilterValue("bank_version.id"));
        if ("null".equalsIgnoreCase(bankVersionId)) {
            bankVersionId = "";
        }
        if ("null".equalsIgnoreCase(acntId = String.valueOf(args.getFilterValue("acc_no.id")))) {
            acntId = "";
        }
        if ("null".equalsIgnoreCase(bankLoginId = String.valueOf(args.getFilterValue("bank_login.id")))) {
            bankLoginId = "";
        }
        if ((object = args.getFilterValue("trans_date")) instanceof List) {
            List list = (List)object;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (list.size() == 2) {
                    startDateTime = this.timeTranslate(sdf.parse((String)list.get(0) + " 00:00:00"));
                    endDateTime = this.timeTranslate(sdf.parse((String)list.get(1) + " 00:00:00"));
                } else if (list.size() == 1) {
                    startDateTime = this.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getStartDate()));
                    endDateTime = this.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getEndDate()));
                }
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"EbgCommonFilterContainerPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        boolean isBankVersionChanaged = !bankVersionId.equals(this.getPageCache().get("selectedBankId")) && (!"".equals(bankVersionId) || this.getPageCache().get("selectedBankId") != null);
        boolean isBankLoginChanaged = !bankLoginId.equals(this.getPageCache().get("selectedBankLoginId")) && (!"".equals(bankLoginId) || this.getPageCache().get("selectedBankLoginId") != null);
        this.getPageCache().put("selectedBankId", bankVersionId);
        this.getPageCache().put("selectedBankLoginId", bankLoginId);
        this.getPageCache().put("isBankVersionChanaged", isBankVersionChanaged + "");
        this.getPageCache().put("selectedAcntId", acntId);
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
        this.filterContainerInit(this.initArgs);
        this.cacheCommonFilter(args.getSearchClickEvent(), isBankVersionChanaged, isBankLoginChanaged);
    }

    private void cacheCommonFilter(SearchClickEvent searchClickEvent, boolean isBankVersionChanaged, boolean isBankLoginChanaged) {
        List customfilter;
        if (searchClickEvent.getFilterValues() != null && (customfilter = (List)searchClickEvent.getFilterValues().get("customfilter")) != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                if (isBankVersionChanaged) {
                    if (!fieldName.startsWith("acc_no") && !fieldName.startsWith("bank_login")) continue;
                    this.commonFilterChange(filteritem);
                    this.getPageCache().put("selectedBankLoginId", null);
                    this.getPageCache().put("selectedAcntId", null);
                    continue;
                }
                if (!isBankLoginChanaged || !fieldName.startsWith("acc_no")) continue;
                this.commonFilterChange(filteritem);
                this.getPageCache().put("selectedAcntId", null);
            }
        }
    }

    protected void commonFilterChange(Map<String, List<Object>> commonFilter) {
        if (commonFilter != null) {
            ArrayList<String> commonList = new ArrayList<String>(16);
            commonList.add("");
            commonFilter.put("Value", commonList);
        }
    }

    public String timeTranslate(Object dateStr) {
        Date time = (Date)dateStr;
        String timeFormat = this.sdf.format(time);
        return timeFormat;
    }

    private String timeTranslateBeforeDay(Object dateStr) {
        Date time = (Date)dateStr;
        time = DateUtil.preDay((Date)time);
        String timeFormat = this.sdf.format(time);
        return timeFormat;
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (qFilters.size() > 0) {
            e.getQFilters().clear();
            e.getQFilters().addAll(qFilters);
        }
    }

    public boolean isReconciliation() {
        String pluginName = this.getPluginName();
        return !StringUtil.isNullOrEmpty(pluginName) && pluginName.contains("Reconciliation");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isInit = Objects.equals(this.getView().getPageCache().get(INIT_CACHE_KEY), "YES");
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        if (qFilters.size() > 0) {
            HashMap qFilterMap = Maps.newHashMapWithExpectedSize((int)16);
            for (QFilter qFilter : qFilters) {
                String value = qFilter.getValue().toString();
                if (qFilter.getValue() instanceof List) {
                    value = ((List)qFilter.getValue()).get(0).toString();
                }
                qFilterMap.put(qFilter.getProperty(), value);
            }
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List currencyItems;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.equals("acc_no.number")) {
                List<ComboItem> acctItems = this.initAcctItemsList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(acctItems);
                continue;
            }
            if (fieldName.equals("bank_login.number")) {
                List<ComboItem> bankLoginItems = this.initBankLoginItemsList();
                currencyItems = commonFilterColumn.getComboItems();
                currencyItems.clear();
                commonFilterColumn.setComboItems(bankLoginItems);
                continue;
            }
            if (!fieldName.equals("bank_version.name")) continue;
            List<ComboItem> bankVersionItems = this.initBankVersionItemsList();
            currencyItems = commonFilterColumn.getComboItems();
            currencyItems.clear();
            commonFilterColumn.setComboItems(bankVersionItems);
            if (bankVersionItems.size() <= 0 || !isInit) continue;
            this.getView().getPageCache().put(INIT_CACHE_KEY, "YES");
            commonFilterColumn.setDefaultValue(bankVersionItems.get(0).getValue());
            this.getPageCache().put("selectedBankId", bankVersionItems.get(0).getValue());
        }
    }

    protected List<ComboItem> initAcctItemsList() {
        QFilter[] qfilters;
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        String selectProperties = "id, number, name";
        if (StringUtil.isNotNil(this.getPageCache().get("selectedBankLoginId")) && "false".equals(this.getPageCache().get("isBankVersionChanaged"))) {
            long selectedBankLoginId = Long.parseLong(this.getPageCache().get("selectedBankLoginId"));
            if (StringUtil.isNotNil(this.getPageCache().get("selectedBankId"))) {
                long groupId = Long.parseLong(this.getPageCache().get("selectedBankId"));
                qfilters = new QFilter[]{QFilter.of((String)"group.id=? and bank_login.id=? and has_receipt=? and enable=? and custom_id=?", (Object[])new Object[]{groupId, selectedBankLoginId, "1", "1", RequestContext.get().getTenantId()})};
            } else {
                qfilters = new QFilter[]{QFilter.of((String)"bank_login.id=? and has_receipt=? and enable=? and custom_id=?", (Object[])new Object[]{selectedBankLoginId, "1", "1", RequestContext.get().getTenantId()})};
            }
        } else if (StringUtil.isNotNil(this.getPageCache().get("selectedBankId"))) {
            long groupId = Long.parseLong(this.getPageCache().get("selectedBankId"));
            qfilters = new QFilter[]{QFilter.of((String)"group.id=? and has_receipt=? and enable=? and custom_id=?", (Object[])new Object[]{groupId, "1", "1", RequestContext.get().getTenantId()})};
        } else {
            qfilters = new QFilter[]{QFilter.of((String)"has_receipt=? and enable=? and custom_id=?", (Object[])new Object[]{"1", "1", RequestContext.get().getTenantId()})};
        }
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_ACNT, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    protected List<ComboItem> initBankLoginItemsList() {
        ArrayList<ComboItem> bankLoginItems = new ArrayList<ComboItem>(16);
        QFilter[] qfilters = new QFilter[4];
        String selectProperties = "id, number, name";
        if (!StringUtil.isNotNil(this.getPageCache().get("selectedBankId"))) {
            return bankLoginItems;
        }
        long groupId = Long.parseLong(this.getPageCache().get("selectedBankId"));
        qfilters[0] = new QFilter("group.id", "=", (Object)groupId);
        qfilters[1] = new QFilter("enable", "=", (Object)"1");
        qfilters[2] = new QFilter("config_type", "=", (Object)"0");
        qfilters[3] = new QFilter("custom_id", "=", (Object)RequestContext.get().getTenantId());
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)ENTITY_KEY_BANK_LOGIN, (String)selectProperties, (QFilter[])qfilters);
        if (accountBanks != null && accountBanks.length > 0) {
            for (int i = 0; i < accountBanks.length; ++i) {
                DynamicObject cashAcct = accountBanks[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("number")));
                item.setValue(cashAcct.getString("id"));
                bankLoginItems.add(item);
            }
        }
        return bankLoginItems;
    }

    protected List<ComboItem> initBankVersionItemsList() {
        if (this.infoService == null) {
            this.infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
        }
        List<String> bankVersionIDList = new ArrayList(16);
        String cache = "enable-bank-list";
        String recon_cache = "enable-bank-recon-list";
        if (this.infoService != null) {
            List<BankVersionInfo> bankVersionList = this.infoService.getBankVersionInfoList();
            for (BankVersionInfo bankVersionInfo : bankVersionList) {
                if (this.isReconciliation()) {
                    if (!bankVersionInfo.isSupportReconciliation()) continue;
                    bankVersionIDList.add(bankVersionInfo.getBankVersionID());
                    continue;
                }
                bankVersionIDList.add(bankVersionInfo.getBankVersionID());
            }
            if (this.isReconciliation()) {
                cache = recon_cache;
            }
            if (!bankVersionIDList.isEmpty()) {
                CosmicCache.delete((String)cache);
                CosmicCache.putWithExpire((String)cache, (String)JSONObject.toJSONString(bankVersionIDList), (int)12, (TimeUnit)TimeUnit.HOURS);
            }
        } else {
            String json;
            if (this.isReconciliation()) {
                cache = recon_cache;
            }
            if (!StringUtil.isNullOrEmpty(json = CosmicCache.get((String)cache))) {
                bankVersionIDList = (List)JSONObject.parseObject((String)json, List.class);
            }
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        String selectProperties = "id, number, name";
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"aqap_bank", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "in", bankVersionIDList), QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"})}, (String)"sort_num asc");
        if (objects != null && objects.length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                DynamicObject cashAcct = objects[i];
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(cashAcct.getString("name")));
                item.setValue(cashAcct.getString("id"));
                items.add(item);
            }
        }
        return items;
    }
}

