/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.defect;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.repository.receipt.ReceiptDownloadTaskRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReceiptDefectListPlugin
extends EbgCommonFilterContainerPlugin {
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
    private ReceiptDownloadTaskRepository receiptDownloadTaskRepository = (ReceiptDownloadTaskRepository)SpringContextUtil.getBean(ReceiptDownloadTaskRepository.class);
    private BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String fromId = (String)listShowParameter.getCustomParam("fromId");
        QFilter filter1 = QFilter.of((String)"status in ('6','11') ", (Object[])new Object[0]);
        QFilter filter2 = QFilter.of((String)"defect_type!=' '", (Object[])new Object[0]);
        e.getQFilters().add(filter1);
        e.getQFilters().add(filter2);
        if (Objects.equals(fromId, "receipt_defect_sta_by_mon")) {
            String startTimeStr = (String)listShowParameter.getCustomParam("startTimeStr");
            String endTimeStr = (String)listShowParameter.getCustomParam("endTimeStr");
            Long accNoId = (Long)listShowParameter.getCustomParam("accNoId");
            String isInitFilter = this.getPageCache().get("isInitFilter");
            if (StringUtils.isEmpty((String)isInitFilter)) {
                if (accNoId != null) {
                    e.getQFilters().add(new QFilter("acc_no.id", "=", (Object)accNoId));
                }
                if (StringUtils.isNotEmpty((String)startTimeStr)) {
                    e.getQFilters().add(new QFilter("trans_date", ">=", (Object)DateUtil.string2Date((String)startTimeStr, (String)"yyyy-MM-dd")));
                }
                if (StringUtils.isNotEmpty((String)endTimeStr)) {
                    e.getQFilters().add(new QFilter("trans_date", "<=", (Object)DateUtil.string2Date((String)endTimeStr, (String)"yyyy-MM-dd")));
                }
                this.getPageCache().put("isInitFilter", "true");
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = StringUtil.isNullOrEmpty(this.getView().getPageCache().get("isInitFilter"));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap) && isInit) {
            DynamicObject dynamicObject;
            Long accNoId = (Long)paramMap.get("accNoId");
            String bankVersionName = "";
            String bankLoginName = "";
            FilterColumn textFilter = args.getFilterColumn("acc_no.number");
            if (accNoId != null && (dynamicObject = this.bankAcntRepository.findById(accNoId)) != null) {
                textFilter.setDefaultValue(dynamicObject.getString("number"));
                bankVersionName = dynamicObject.getString("group.id");
                bankLoginName = dynamicObject.getString("bank_login.id");
                this.getView().getPageCache().put("selectedBankId", bankVersionName);
                this.getView().getPageCache().put("selectedBankLoginId", bankLoginName);
                this.getView().getPageCache().put("selectedAcntId", accNoId.toString());
            }
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                String startTimeStr = (String)paramMap.get("startTimeStr");
                String endTimeStr = (String)paramMap.get("endTimeStr");
                if (fieldName.equals("trans_date") && paramMap.get("startTimeStr") != null) {
                    ArrayList<String> l = new ArrayList<String>(16);
                    l.add(startTimeStr);
                    l.add(endTimeStr);
                    commonFilterColumn.setDefaultValues(l);
                }
                if (fieldName.equals("bank_version.name") && StringUtils.isNotEmpty((String)bankVersionName)) {
                    commonFilterColumn.setDefaultValue(bankVersionName);
                }
                if (!fieldName.equals("bank_login.number") || !StringUtils.isNotEmpty((String)bankLoginName)) continue;
                commonFilterColumn.setDefaultValue(bankLoginName);
            }
        }
        super.filterContainerInit(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)"reset_task", (String)operateKey)) {
            this.resetTask(args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            try {
                ArrayList updateList = new ArrayList(16);
                HashMap bankLoginMap = Maps.newHashMapWithExpectedSize((int)16);
                HashMap errorTypeMap = Maps.newHashMapWithExpectedSize((int)16);
                EBContext ebContext = EBContext.builder().customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                listSelectedRowCollection.forEach(selectedRow -> {
                    Long fid = (Long)selectedRow.getPrimaryKeyValue();
                    DynamicObject dynamicObject = this.receiptDownloadTaskRepository.selectById(fid);
                    if (dynamicObject != null && (TaskStatusEnum.FAILED.getId() == dynamicObject.getInt("status") || TaskStatusEnum.FINISH.getId() == dynamicObject.getInt("status"))) {
                        String customId = dynamicObject.getString("custom_id");
                        String bankLoginId = dynamicObject.getString("bank_login.number");
                        BankLoginKey key = new BankLoginKey();
                        key.setCustomId(customId);
                        key.setBankLoginId(bankLoginId);
                        BankLogin bankLogin = this.bankLoginRepository.findEnableBankLogin(key);
                        if (bankLogin == null || Objects.equals(bankLogin.getEnable(), "false")) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u7f6e\u56de\u5355\u4efb\u52a1\u3002", (String)"ReceiptDefectListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                        String bankVersion = bankLogin.getBankVersionId();
                        EBContext.getContext().setBankVersionID(bankVersion);
                        String mapKey = bankLoginId + ";" + bankVersion;
                        if (!bankLoginMap.containsKey(mapKey)) {
                            BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
                            bankLoginMap.put(bankLoginId, ftpProperties);
                        }
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u6216\u5b8c\u6210\u7684\u4efb\u52a1\u53ef\u4ee5\u91cd\u7f6e\u3002", (String)"ReceiptDefectListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    String defectType = dynamicObject.getString("defect_type");
                    errorTypeMap.put(defectType, defectType);
                    dynamicObject.set("status", (Object)TaskStatusEnum.CREATE.getId());
                    dynamicObject.set("redo", (Object)0);
                    dynamicObject.set("exp_msg", (Object)"");
                    dynamicObject.set("complete_time", (Object)-1);
                    updateList.add(dynamicObject);
                });
                if (errorTypeMap.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u91cd\u7f6e\u4efb\u52a1\u9700\u8981\u9009\u62e9\u540c\u4e00\u79cd\u7f3a\u5931\u7c7b\u578b\u3002", (String)"ReceiptDefectListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.testConnectByList(bankLoginMap);
                this.receiptDownloadTaskRepository.batchUpdate(updateList.toArray(new DynamicObject[updateList.size()]));
                this.getView().invokeOperation("refresh");
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                args.setCancel(true);
                return;
            }
            finally {
                EBContext.destroy();
            }
        }
    }

    public boolean testConnectByList(Map<String, BankFtpProperties> bankLoginMap) {
        ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
        HashMap connectSuccessMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, BankFtpProperties> entry : bankLoginMap.entrySet()) {
            int port;
            String ip;
            String maoKey = entry.getKey();
            String[] splits = maoKey.split(";");
            if (splits.length != 2) continue;
            String bankLogin = splits[0];
            String bankVersion = splits[1];
            EBContext.getContext().setBankLoginID(bankLogin);
            EBContext.getContext().setBankVersionID(bankVersion);
            BankFtpProperties bankFtpProperties = entry.getValue();
            if (Objects.equals(bankFtpProperties.getReceiptAchieveWay(), "bank_login")) {
                ip = bankFtpProperties.getFrontProxyIP();
                port = bankFtpProperties.getFrontProxyPort();
                String successKey = ip + port;
                if (!connectSuccessMap.containsKey(successKey)) {
                    try {
                        receiptDownloadConnectMonitorUtils.testFrontConnect(ip, port + "", null, false);
                    }
                    catch (Exception e) {
                        String error = String.format(ResManager.loadKDString((String)"ip:%1$s \u7aef\u53e3:%2$s \u8fde\u63a5\u4e0d\u901a\uff0c\u8bf7\u5148\u68c0\u67e5\u8fde\u63a5\u670d\u52a1\u540e\u518d\u91cd\u7f6e\u4efb\u52a1\u3002", (String)"ReceiptDefectListPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), ip, port + "");
                        throw new ReceiptException(error, (Throwable)e);
                    }
                } else {
                    connectSuccessMap.put(successKey, successKey);
                }
            }
            if (!Objects.equals(bankFtpProperties.getReceiptAchieveWay(), "sftp")) continue;
            ip = bankFtpProperties.getBankFtpIP();
            port = bankFtpProperties.getBankFtpPort();
            String username = bankFtpProperties.getUserName();
            String cipher = bankFtpProperties.getPassword();
            String ftpCertPath = bankFtpProperties.getCertPath();
            String successKey = ip + port + username;
            if (!connectSuccessMap.containsKey(successKey)) {
                try {
                    receiptDownloadConnectMonitorUtils.testSftpConnect(ip, port, username, cipher, ftpCertPath);
                    continue;
                }
                catch (Exception e) {
                    String error = String.format(ResManager.loadKDString((String)"\u8fdc\u7a0bSFTP\u670d\u52a1%1$s:%2$s\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u5148\u68c0\u67e5\u8fde\u63a5\u670d\u52a1\u540e\u518d\u91cd\u7f6e\u4efb\u52a1\u3002", (String)"ReceiptDefectListPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), ip, port + "");
                    throw new ReceiptException(error, (Throwable)e);
                }
            }
            connectSuccessMap.put(successKey, successKey);
        }
        return true;
    }
}

