/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.defect;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class ReceiptDefectMonitorSettingPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"setting", (CharSequence)formOperate.getOperateKey())) {
            IDataModel model = this.getModel();
            String monitor_month = (String)model.getValue("monitor_month");
            String objectId = "common_business";
            String objectName = "receipt";
            String attr_key = "defect_monitor_day";
            this.getPageCache().put("defect_monitor_setting_success", "true");
            this.delete(objectId, objectName, attr_key);
            this.save(attr_key, objectId, objectName, monitor_month);
            Integer monitor_time = (Integer)model.getValue("monitor_time");
            String monitorTimeStr = monitor_time.toString();
            String attr_key1 = "defect_monitor_time";
            this.delete(objectId, objectName, attr_key1);
            this.save(attr_key1, objectId, objectName, monitorTimeStr);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReceiptDefectMonitorSettingPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        EBContext context = EBContext.builder().customID(RequestContext.get().getTenantId()).build();
        EBContext.setContext((EBContext)context);
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        EBContext.destroy();
        if (Objects.equals(receiptSystemProperties.getReceiptAlertWay(), "email")) {
            this.getModel().getDataEntity().set("receipt_alert_way", (Object)ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"ReceiptDefectMonitorSettingPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            this.getModel().getDataEntity().set("email", (Object)receiptSystemProperties.getReceiptEmail());
        }
        if (Objects.equals(receiptSystemProperties.getReceiptAlertWay(), "mobile")) {
            this.getModel().getDataEntity().set("receipt_alert_way", (Object)ResManager.loadKDString((String)"\u624b\u673a\u77ed\u4fe1", (String)"ReceiptDefectMonitorSettingPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            this.getModel().getDataEntity().set("mobile", (Object)receiptSystemProperties.getReceiptMobile());
        }
        Integer monitorDayStr = receiptSystemProperties.getDefect_monitor_day();
        Integer monitorTimeStr = receiptSystemProperties.getDefect_monitor_time();
        this.getModel().getDataEntity().set("monitor_month", (Object)monitorDayStr);
        this.getModel().getDataEntity().set("monitor_time", (Object)monitorTimeStr);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        if ("true".equals(this.getPageCache().get("defect_monitor_setting_success"))) {
            this.getView().returnDataToParent((Object)"success");
        }
    }

    void delete(String objectId, String objectName, String attr_key) {
        QFilter[] qFilters = new QFilter[]{new QFilter("object_id", "=", (Object)objectId), new QFilter("object_name", "=", (Object)objectName), new QFilter("attr_key", "=", (Object)attr_key)};
        DeleteServiceHelper.delete((String)"aqap_object_properties", (QFilter[])qFilters);
    }

    OperationResult save(String attr_key, String objectId, String objectName, String value) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"aqap_object_properties");
        dataEntity.set("attr_key", (Object)attr_key);
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)RequestContext.get().getTenantId());
        OperationResult result = SaveServiceHelper.saveOperate((String)"aqap_object_properties", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        return result;
    }
}

