/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.index;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptNumGroup;
import org.apache.commons.lang3.StringUtils;

public class ReceiptNumStatisticsPlugin
extends AbstractFormPlugin {
    private BankVersionService bankVersionService = BankVersionService.getInstance();

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.fillDefaultValue();
            this.drawChart();
        }
    }

    private void fillDefaultValue() {
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isBlank((CharSequence)startDateStr) && !StringUtils.isBlank((CharSequence)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            Date defaultEndDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            Date defaultStartDate = DateUtil.getLastDay((Date)defaultEndDate, (int)6);
            this.getModel().setValue("startdate", (Object)defaultStartDate);
            this.getModel().setValue("enddate", (Object)defaultEndDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            if (DateUtil.getDayDiff((Date)((Date)this.getModel().getValue("startdate")), (Date)((Date)this.getModel().getValue("enddate"))) > 6L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc77\u5929\u3002", (String)"ReceiptNumStatisticsPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.drawChart();
        }
    }

    private void drawChart() {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"ReceiptNumStatisticsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), true);
        this.createValueAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u7b14", (String)"ReceiptNumStatisticsPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), false);
        List<Date> dates = this.getDateList();
        ArrayList categories = new ArrayList(16);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        dates.forEach(monthStartDate -> categories.add(format.format((Date)monthStartDate)));
        categoryAxis.setCategorys(categories);
        Map<ReceiptNumGroup, List<Number>> sortedData = this.getData(dates);
        sortedData.forEach((group, data) -> this.createBarSeries(group.groupName, (List<Number>)data, group.color));
        customchart.setMargin(Position.right, "50px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private Map<ReceiptNumGroup, List<Number>> getData(List<Date> dates) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<ReceiptNumGroup> groups = this.getReceiptNumGroups();
        HashMap summaryResult = Maps.newHashMapWithExpectedSize((int)16);
        for (ReceiptNumGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            summaryResult.put(group, initialBillCountList);
        }
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)date), LocalDateUtil.getLastTimeByDate((Date)date)});
            DynamicObjectCollection statistics = QueryServiceHelper.query((String)"receipt_download_task", (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
            for (ReceiptNumGroup group : groups) {
                ((List)summaryResult.get(group)).add(statistics.size() > 0 ? ((DynamicObject)statistics.get(0)).getInt(group.fieldName) : 0);
            }
        }
        return summaryResult;
    }

    private List<Long> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = this.bankVersionService.findByCustomId(customId);
        if (CollectionUtils.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(16);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.parseLong(bankListEntity.getId()));
        }
        return bankVersionIdList;
    }

    private List<ReceiptNumGroup> getReceiptNumGroups() {
        return ReceiptNumGroup.getDefaultGroups();
    }

    private List<Date> getDateList() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null && endDate == null) {
            endDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            startDate = DateUtil.getLastDay((Date)endDate, (int)6);
        }
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = startDate;
        if (date != null && endDate != null) {
            while (date.getTime() <= endDate.getTime()) {
                dates.add(date);
                date = DateUtil.getNextDay((Date)date, (int)1);
            }
        }
        return dates;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyle = Maps.newHashMapWithExpectedSize((int)16);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setBarWidth("8px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyleMap = Maps.newHashMapWithExpectedSize((int)16);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", (Object)axisLineMap);
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }
}

