/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.index;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptNumGroup;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptPcGroup;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import org.apache.commons.lang3.StringUtils;

public class ReceiptStatisticsPlugin
extends AbstractFormPlugin {
    private BankVersionService bankVersionService = BankVersionService.getInstance();

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    private void fillDefaultValue() {
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isBlank((CharSequence)startDateStr) && !StringUtils.isBlank((CharSequence)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            Date defaultEndDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            Date defaultStartDate = DateUtil.getLastDay((Date)defaultEndDate, (int)6);
            this.getModel().setValue("startdate", (Object)defaultStartDate);
            this.getModel().setValue("enddate", (Object)defaultEndDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            if (DateUtil.getDayDiff((Date)((Date)this.getModel().getValue("startdate")), (Date)((Date)this.getModel().getValue("enddate"))) > 6L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8de8\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc77\u5929\u3002", (String)"ReceiptStatisticsPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.drawChart();
        }
    }

    private HistogramChart buildHistogramChart(String key, String yName, List<String> categories) {
        HistogramChart customchart = (HistogramChart)this.getControl(key);
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(key, ResManager.loadKDString((String)"\u65e5\u671f", (String)"ReceiptStatisticsPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), true);
        this.createValueAxis(key, ResManager.loadKDString((String)yName, (String)"ReceiptStatisticsPlugin_1", (String)"ReceiptStatisticsPlugin_2", (Object[])new Object[0]), false);
        categoryAxis.setCategorys(categories);
        return customchart;
    }

    private void drawChart() {
        String numberKey = "histogramchartap";
        String pcKey = "histogramchartap1";
        ArrayList<String> categories = new ArrayList<String>(16);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List<Date> dates = this.getDateList();
        dates.forEach(monthStartDate -> categories.add(format.format((Date)monthStartDate)));
        HistogramChart numberChart = this.buildHistogramChart(numberKey, ResManager.loadKDString((String)"\u6570\u91cf(\u4e2a)", (String)"ReceiptStatisticsPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), categories);
        HistogramChart pcChart = this.buildHistogramChart(pcKey, ResManager.loadKDString((String)"\u5b8c\u6574\u7387(%)", (String)"ReceiptStatisticsPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), categories);
        LinkedHashMap<ReceiptNumGroup, List<Number>> numData = new LinkedHashMap<ReceiptNumGroup, List<Number>>();
        LinkedHashMap<ReceiptPcGroup, List<Number>> pcData = new LinkedHashMap<ReceiptPcGroup, List<Number>>();
        this.getData(dates, numData, pcData);
        numData.forEach((group, data) -> this.createBarSeries(numberKey, group.groupName, (List<Number>)data, group.color));
        pcData.forEach((group, data) -> this.createBarSeries(pcKey, group.groupName, (List<Number>)data, group.color));
        this.refreshHistogramChart(numberChart);
        this.refreshHistogramChart(pcChart);
    }

    private void refreshHistogramChart(HistogramChart histogramChart) {
        histogramChart.setMargin(Position.top, "70px");
        histogramChart.refresh();
    }

    private void getData(List<Date> dates, Map<ReceiptNumGroup, List<Number>> sortedData1, Map<ReceiptPcGroup, List<Number>> sortedData2) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<ReceiptNumGroup> groups = this.getReceiptNumGroups();
        for (ReceiptNumGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            sortedData1.put(group, initialBillCountList);
        }
        List<ReceiptPcGroup> groups2 = this.getReceiptPcGroups();
        for (ReceiptPcGroup pcGroup : groups2) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            sortedData2.put(pcGroup, initialBillCountList);
        }
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)date), LocalDateUtil.getLastTimeByDate((Date)date)});
            DynamicObjectCollection statistics = QueryServiceHelper.query((String)"receipt_download_task", (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
            for (ReceiptNumGroup group : groups) {
                sortedData1.get(group).add(statistics.size() > 0 ? ((DynamicObject)statistics.get(0)).getInt(group.fieldName) : 0);
            }
            int receipt_num = ((DynamicObject)statistics.get(0)).getInt("receipt_num");
            int detail_num = ((DynamicObject)statistics.get(0)).getInt("detail_num");
            int upload_num = ((DynamicObject)statistics.get(0)).getInt("upload_num");
            int match_num = ((DynamicObject)statistics.get(0)).getInt("match_num");
            for (ReceiptPcGroup group : groups2) {
                Number number = 0;
                if ("download_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(receipt_num, detail_num);
                } else if ("match_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(match_num, receipt_num);
                } else if ("upload_pc".equals(group.fieldName)) {
                    number = ReceiptStatisticsUtil.getPcResult(upload_num, receipt_num);
                }
                sortedData2.get(group).add(number);
            }
        }
    }

    private Map<ReceiptNumGroup, List<Number>> getData(List<Date> dates) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<ReceiptNumGroup> groups = this.getReceiptNumGroups();
        HashMap summaryResult = Maps.newHashMapWithExpectedSize((int)16);
        for (ReceiptNumGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(dates.size());
            summaryResult.put(group, initialBillCountList);
        }
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{LocalDateUtil.getFirstTimeByDate((Date)date), LocalDateUtil.getLastTimeByDate((Date)date)});
            DynamicObjectCollection statistics = QueryServiceHelper.query((String)"receipt_download_task", (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
            for (ReceiptNumGroup group : groups) {
                ((List)summaryResult.get(group)).add(statistics.size() > 0 ? ((DynamicObject)statistics.get(0)).getInt(group.fieldName) : 0);
            }
        }
        return summaryResult;
    }

    private List<Long> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = this.bankVersionService.findByCustomId(customId);
        if (CollectionUtils.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(16);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.parseLong(bankListEntity.getId()));
        }
        return bankVersionIdList;
    }

    private List<ReceiptNumGroup> getReceiptNumGroups() {
        return ReceiptNumGroup.getDefaultGroups();
    }

    private List<ReceiptPcGroup> getReceiptPcGroups() {
        return ReceiptPcGroup.getDefaultGroups();
    }

    private List<Date> getDateList() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null && endDate == null) {
            endDate = DateUtil.getLastDay((Date)new Date(), (int)1);
            startDate = DateUtil.getLastDay((Date)endDate, (int)6);
        }
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = startDate;
        if (Objects.nonNull(date) && Objects.nonNull(endDate)) {
            while (date.getTime() <= endDate.getTime()) {
                dates.add(date);
                date = DateUtil.getNextDay((Date)date, (int)1);
            }
        }
        return dates;
    }

    private HistogramChart getMainChart(String key) {
        return (HistogramChart)this.getControl(key);
    }

    private Axis createCategoryAxis(String key, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart(key).createXAxis(name, AxisType.category) : this.getMainChart(key).createYAxis(name, AxisType.category);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("interval", 0);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String key, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart(key).createXAxis(name, AxisType.value) : this.getMainChart(key).createYAxis(name, AxisType.value);
        HashMap axisTick = Maps.newHashMapWithExpectedSize((int)16);
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", (Object)axisTick);
        HashMap splitLine = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyle = Maps.newHashMapWithExpectedSize((int)16);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart(key).setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String key, String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart(key).createBarSeries(name);
        barSeries.setBarWidth("18px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap lineStyleMap = Maps.newHashMapWithExpectedSize((int)16);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", (Object)axisLineMap);
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }
}

