/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.match;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.match.MatchRule;
import kd.ebg.receipt.formplugin.service.CommonService;
import kd.ebg.receipt.formplugin.util.JsonUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class MatchRulePlugin
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final String KEY_SAVE_BUTTON = "btn_save";
    private static final String KEY_ADD_BUTTON = "btn_add";
    private static final String KEY_DEL_BUTTON = "btn_del";
    private static final String KEY_SUBMIT_BUTTON = "btn_submit";
    private static final String EB = "eb_matchRulePlugin_";
    private static final String KEY_TREE_BILL = "match_tree_entity";
    private static final String entity = "receipt_bd_match_rule";
    private static final String properties = "id,number,name,match_rule,bank_version";
    private static final String match_param_entity = "receipt_bd_match_param";
    private static final String match_param_properties = "number,name,detail_param,receipt_param,ref_id";
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(KEY_TREE_BILL);
        treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit bankVersionFieldEdit = (BasedataEdit)this.getView().getControl("bank_list");
        if (bankVersionFieldEdit != null) {
            bankVersionFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)8);
        fieldMap.put("bc", "white");
        this.getView().updateControlMetadata("ebc_flexpanelap1", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap2", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap3", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap4", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap5", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap6", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap7", (Map)fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap8", (Map)fieldMap);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        TextEdit textEdit1 = (TextEdit)this.getControl("textfield1");
        TextEdit textEdit2 = (TextEdit)this.getControl("textfield2");
        TextEdit textEdit3 = (TextEdit)this.getControl("textfield3");
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_TREE_BILL, row);
        this.getModel().setValue("textfield1", (Object)dynamicObject.getString("define_param"));
        this.getModel().setValue("textfield2", (Object)dynamicObject.getString("receipt_param"));
        this.getModel().setValue("textfield3", (Object)dynamicObject.getString("detail_param"));
        boolean flag = MatchRule.commonParams.contains(dynamicObject.getString("define_param"));
        textEdit1.setEnable("", !flag, 0);
        textEdit2.setEnable("", !flag, 0);
        textEdit3.setEnable("", !flag, 0);
        this.getModel().setEntryCurrentRowIndex(KEY_TREE_BILL, row);
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_SAVE_BUTTON, "btn_remove", KEY_ADD_BUTTON, "btn_update", KEY_DEL_BUTTON, "textfield1", "textfield2", "textfield3"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        String type = "";
        if (StringUtil.equals(fieldKey, "template_combo")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRulePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                ChangeData[] changeSet;
                String bankVersion = dynamicObject.getString("number");
                for (ChangeData changeData : changeSet = e.getChangeSet()) {
                    type = (String)changeData.getNewValue();
                    this.getView().setVisible(Boolean.valueOf("define".equals(type)), new String[]{KEY_SAVE_BUTTON, "btn_remove", KEY_ADD_BUTTON, "btn_update", KEY_DEL_BUTTON, "textfield1", "textfield2", "textfield3"});
                    this.loadMatchRule(bankVersion, type);
                    this.loadMatchParams();
                }
            }
        } else if (StringUtil.equals(fieldKey, "bank_list")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u7248\u672c\u3002", (String)"MatchRulePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                String bankVersion = dynamicObject.getString("number");
                ComboEdit combo = (ComboEdit)this.getControl("template_combo");
                ComboProp comboProp = (ComboProp)combo.getProperty();
                List mapItems = comboProp.getComboItems();
                type = this.isDefinedMatchRule(bankVersion) ? ((ValueMapItem)mapItems.get(1)).getValue() : ((ValueMapItem)mapItems.get(0)).getValue();
                this.getModel().setValue("template_combo", (Object)type);
                this.loadMatchRule(bankVersion, type);
                this.loadMatchParams();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("bank_list".equals(fieldKey)) {
            List<String> bankVersionIDList = this.commonService.getImplBankVersionIdList();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("number", "in", bankVersionIDList));
            qFilters.add(QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"}));
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtil.equals(formOperate.getOperateKey(), "save")) {
            String alertMsg = this.checkTreeGrid();
            if (!StringUtils.isEmpty(alertMsg)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"MatchRulePlugin_15", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), alertMsg));
            } else if (!this.isAddNewParams().booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u65b0\u589e\u5339\u914d\u5b57\u6bb5\u3002", (String)"MatchRulePlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            } else {
                String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
                if (StringUtil.isNotNil(jsonStr)) {
                    MatchRule matchRule = JsonUtil.fromJson(jsonStr, MatchRule.class);
                    this.saveMatchRule(matchRule);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MatchRulePlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (StringUtil.equals(formOperate.getOperateKey(), "remove")) {
            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("bank_list");
            if (dynamicObject != null) {
                String bankVersion = dynamicObject.getString("number");
                if (this.isDefinedMatchRule(bankVersion)) {
                    this.removeMatchRule(bankVersion);
                    this.loadMatchRule(bankVersion, "common");
                    this.loadMatchParams();
                    this.getModel().setValue("textfield1", (Object)"");
                    this.getModel().setValue("textfield2", (Object)"");
                    this.getModel().setValue("textfield3", (Object)"");
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f", (String)"MatchRulePlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5df2\u5b8c\u6210", (String)"MatchRulePlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
        } else if (!StringUtil.equals(formOperate.getOperateKey(), "newentry")) {
            if (StringUtil.equals(formOperate.getOperateKey(), "update")) {
                int row = this.getModel().getEntryCurrentRowIndex(KEY_TREE_BILL);
                String toUpdateParam = this.getModel().getValue("define_param", row).toString();
                String defineParam = (String)this.getModel().getValue("textfield1");
                String receiptParam = (String)this.getModel().getValue("textfield2");
                String detailParam = (String)this.getModel().getValue("textfield3");
                if (StringUtils.isEmpty(defineParam) || StringUtils.isEmpty(receiptParam) || StringUtils.isEmpty(detailParam)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f85\u66f4\u65b0\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MatchRulePlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (this.isRepeatDefine(defineParam).booleanValue()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5339\u914d\u5b57\u6bb5%s\u91cd\u590d\u3002", (String)"MatchRulePlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), defineParam));
                } else if (this.isDefaultParam(defineParam)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5339\u914d\u5b57\u6bb5%s\u4e3a\u901a\u7528\u6a21\u677f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MatchRulePlugin_8", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), defineParam));
                } else if (this.isDefaultParam(toUpdateParam)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u884c\u53f7\u4e3a%1$s\uff0c\u5339\u914d\u5b57\u6bb5%2$s\u4e3a\u901a\u7528\u6a21\u677f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"MatchRulePlugin_16", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), row + 1, toUpdateParam));
                } else {
                    this.getModel().setValue("define_param", (Object)defineParam, row);
                    this.getModel().setValue("receipt_param", (Object)receiptParam, row);
                    this.getModel().setValue("detail_param", (Object)detailParam, row);
                    this.updateMatchRule();
                }
            } else if (StringUtil.equals(formOperate.getOperateKey(), "deleteentry")) {
                int row;
                IDataModel entryOperate = this.getModel();
                DynamicObject dynamicObject = entryOperate.getEntryRowEntity(KEY_TREE_BILL, row = entryOperate.getEntryCurrentRowIndex(KEY_TREE_BILL));
                String name = dynamicObject.getString("define_param");
                if (MatchRule.commonParams.contains(name)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u5339\u914d\u5b57\u6bb5%s\u4e3a\u901a\u7528\u6a21\u677f\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MatchRulePlugin_10", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), name));
                } else {
                    entryOperate.deleteEntryRow(KEY_TREE_BILL, row);
                }
                row = entryOperate.getEntryCurrentRowIndex(KEY_TREE_BILL);
                this.getModel().setValue("textfield1", this.getModel().getValue("define_param", row));
                this.getModel().setValue("textfield2", this.getModel().getValue("receipt_param", row));
                this.getModel().setValue("textfield3", this.getModel().getValue("detail_param", row));
                boolean flag = MatchRule.commonParams.contains(this.getModel().getValue("define_param", row));
                TextEdit textEdit1 = (TextEdit)this.getControl("textfield1");
                TextEdit textEdit2 = (TextEdit)this.getControl("textfield2");
                TextEdit textEdit3 = (TextEdit)this.getControl("textfield3");
                textEdit1.setEnable("", !flag, 0);
                textEdit2.setEnable("", !flag, 0);
                textEdit3.setEnable("", !flag, 0);
                this.updateMatchRule();
            }
        }
    }

    private void saveMatchRule(MatchRule rule) {
        DynamicObject dynamicObject;
        if (StringUtils.isEmpty(rule.getId())) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)entity);
            if (dynamicObject == null || StringUtils.equals(dynamicObject.getString("number"), "common")) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            }
        }
        dynamicObject.set("number", (Object)"define");
        dynamicObject.set("name", (Object)rule.getName());
        dynamicObject.set("bank_version", (Object)rule.getBankVersion());
        dynamicObject.set("match_rule", (Object)rule.getRule());
        dynamicObject.set("status", (Object)"A");
        Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        DynamicObject dObj = (DynamicObject)objs[0];
        rule.setId(dObj.getString("id"));
        String jsonStr = JsonUtil.toJson(rule);
        this.getPageCache().put("eb_matchRulePlugin_instance", jsonStr);
        rule = this.getMatchParams(rule);
        this.saveMatchParams(rule);
    }

    private MatchRule getMatchParams(MatchRule rule) {
        IDataModel entryOperate = this.getModel();
        DynamicObjectCollection collection = entryOperate.getEntryEntity(KEY_TREE_BILL);
        for (DynamicObject dynamicObject : collection) {
            String v2;
            String k = dynamicObject.getString("define_param");
            if (MatchRule.commonParams.contains(k) || !StringUtil.isNotNil(k)) continue;
            rule.addDefineParam(k);
            String v1 = dynamicObject.getString("receipt_param");
            if (StringUtil.isNotNil(v1)) {
                rule.addReceiptParam(k, v1);
            }
            if (!StringUtil.isNotNil(v2 = dynamicObject.getString("detail_param"))) continue;
            rule.addDetailParam(k, v2);
        }
        return rule;
    }

    private void saveMatchParams(MatchRule rule) {
        QFilter filter;
        DynamicObject[] dynamicObjects;
        String refId = rule.getId();
        String[] s = rule.getRule().split("-");
        List<String> paramList = Arrays.asList(s);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> updateObjectList = new ArrayList<DynamicObject>(1);
        for (String defineParam : rule.getDefineParams()) {
            QFilter filter2 = QFilter.of((String)"number = ? and ref_id = ?", (Object[])new Object[]{defineParam, refId});
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)match_param_entity, (String)match_param_properties, (QFilter[])filter2.toArray());
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)match_param_entity);
                dynamicObject.set("number", (Object)defineParam);
                dynamicObject.set("name", (Object)defineParam);
                dynamicObject.set("ref_id", (Object)refId);
                dynamicObject.set("status", (Object)"A");
            }
            dynamicObject.set("detail_param", (Object)rule.getDetailMapping().get(defineParam));
            dynamicObject.set("receipt_param", (Object)rule.getReceiptMapping().get(defineParam));
            if (paramList.contains(defineParam)) {
                if (StringUtils.equals(dynamicObject.getString("id"), "0")) {
                    dynamicObjectList.add(dynamicObject);
                    continue;
                }
                updateObjectList.add(dynamicObject);
                continue;
            }
            DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter2.toArray());
        }
        if (dynamicObjectList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
        if (updateObjectList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateObjectList.toArray(new DynamicObject[0]));
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((String)match_param_entity, (String)match_param_properties, (QFilter[])(filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{refId})).toArray())) != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String param = dynamicObject.getString("number");
                if (paramList.contains(param)) continue;
                filter = QFilter.of((String)"number = ? and ref_id = ?", (Object[])new Object[]{param, refId});
                DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
            }
        }
    }

    private boolean isDefinedMatchRule(String bankVersion) {
        QFilter filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, "define"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        return dynamicObject != null;
    }

    private void loadMatchRule(String bankVersion, String type) {
        DynamicObject dynamicObject;
        MatchRule matchRule = new MatchRule();
        matchRule.setBankVersion(bankVersion);
        matchRule.setType(type);
        QFilter filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, type});
        if ("common".equals(type)) {
            filter = QFilter.of((String)"number=?", (Object[])new Object[]{type});
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray())) != null) {
            String id = dynamicObject.getString("id");
            String rule = dynamicObject.getString("match_rule");
            String name = dynamicObject.getString("name");
            matchRule.setId(id);
            matchRule.setRule(rule);
            matchRule.setName(name);
            this.getView().getModel().setValue("receipt_rule", (Object)rule);
            TextEdit textEdit = (TextEdit)this.getControl("receipt_rule");
            textEdit.setEnable("", false, 0);
        }
        String jsonStr = JsonUtil.toJson(matchRule);
        this.getPageCache().put("eb_matchRulePlugin_instance", jsonStr);
    }

    public void loadMatchParams() {
        String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
        if (StringUtil.isNotNil(jsonStr)) {
            IDataModel entryOperate = this.getModel();
            entryOperate.deleteEntryData(KEY_TREE_BILL);
            MatchRule matchRule = JsonUtil.fromJson(jsonStr, MatchRule.class);
            String id = matchRule.getId();
            QFilter filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{id});
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray(), (String)"id asc");
            for (String param : MatchRule.commonParams) {
                int row = entryOperate.createNewEntryRow(KEY_TREE_BILL);
                this.getModel().setValue("define_param", (Object)param, row);
                this.getModel().setValue("receipt_param", (Object)param, row);
                this.getModel().setValue("detail_param", (Object)param, row);
            }
            if (StringUtils.isNotEmpty(matchRule.getRule())) {
                String[] s = matchRule.getRule().split("-");
                List<String> paramList = Arrays.asList(s);
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        if (!paramList.contains(dynamicObject.getString("number"))) continue;
                        int row = entryOperate.createNewEntryRow(KEY_TREE_BILL);
                        this.getModel().setValue("define_param", (Object)dynamicObject.getString("number"), row);
                        this.getModel().setValue("receipt_param", (Object)dynamicObject.getString("receipt_param"), row);
                        this.getModel().setValue("detail_param", (Object)dynamicObject.getString("detail_param"), row);
                    }
                }
            }
        }
    }

    private void lockGridData() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(KEY_TREE_BILL);
        int rowCount = treeEntryGrid.getModel().getEntryRowCount(treeEntryGrid.getEntryKey());
        int i = 0;
        while (i < rowCount) {
            treeEntryGrid.setRowLock(true, new int[]{i++});
        }
    }

    private void updateMatchRule() {
        TextEdit textEdit = (TextEdit)this.getControl("receipt_rule");
        textEdit.setEnable("", false, 0);
        int rowCount = this.getModel().getEntryRowCount(KEY_TREE_BILL);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_TREE_BILL, i);
            String param = dynamicObject.getString("define_param");
            sb.append(param);
            if (i >= rowCount - 1) continue;
            sb.append("-");
        }
        String rule = sb.toString();
        this.getModel().setValue("receipt_rule", (Object)rule);
        String jsonStr = this.getPageCache().get("eb_matchRulePlugin_instance");
        MatchRule matchRule = StringUtil.isNotNil(jsonStr) ? JsonUtil.fromJson(jsonStr, MatchRule.class) : new MatchRule();
        matchRule.setRule(rule);
        this.getPageCache().put("eb_matchRulePlugin_instance", JsonUtil.toJson(matchRule));
    }

    private boolean removeMatchRule(String bankVersion) {
        QFilter filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, "define"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String id = dynamicObject.getString("id");
            DeleteServiceHelper.delete((String)entity, (QFilter[])filter.toArray());
            filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)match_param_entity, (QFilter[])filter.toArray());
        }
        return true;
    }

    private String checkTreeGrid() {
        String msg = "";
        int rowCount = this.getModel().getEntryRowCount(KEY_TREE_BILL);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_TREE_BILL, i);
            String param_define = dynamicObject.getString("define_param");
            String param_receipt = dynamicObject.getString("receipt_param");
            String param_detail = dynamicObject.getString("detail_param");
            if (StringUtils.isEmpty(param_define)) {
                sb.append(ResManager.loadKDString((String)"\u5339\u914d\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRulePlugin_11", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(param_receipt)) {
                sb.append(ResManager.loadKDString((String)"\u56de\u5355\u6620\u5c04\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRulePlugin_12", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(param_detail)) {
                sb.append(ResManager.loadKDString((String)"\u660e\u7ec6\u6620\u5c04\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MatchRulePlugin_13", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(sb.toString())) continue;
            sb.append(ResManager.loadKDString((String)"\u884c\u53f7\uff1a", (String)"MatchRulePlugin_14", (String)"ebg-receipt-formplugin", (Object[])new Object[0])).append(i + 1).append("\r\n");
            msg = sb.toString();
            break;
        }
        return msg;
    }

    private Boolean isAddNewParams() {
        int rowCount = this.getModel().getEntryRowCount(KEY_TREE_BILL);
        return rowCount > 6;
    }

    private Boolean isRepeatDefine(String param) {
        int repeatCount = 0;
        int rowCount = this.getModel().getEntryRowCount(KEY_TREE_BILL);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(KEY_TREE_BILL, i);
            String param_define = dynamicObject.getString("define_param");
            if (!param.equals(param_define)) continue;
            ++repeatCount;
        }
        return repeatCount > 0;
    }

    private boolean isDefaultParam(String param) {
        return MatchRule.getCommonParams().contains(param);
    }
}

