/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.monitor.connect;

import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;

public class ReceiptConnectMonitorListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_KEY = "receipt_bank_login";
    private static final String TEST_CONNECT_BUTTON = "testconnect";
    private static final String TEST_CONNECT_OPERATION_KEY = "test_connect";
    private static final String TEST_CONNECT_SETTING_KEY = "test_connect_setting";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (Objects.equals("delete", operateKey)) {
            try {
                listSelectedRowCollection = args.getListSelectedData();
                if (listSelectedRowCollection.size() == 0 || listSelectedRowCollection == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptConnectMonitorListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                listSelectedRowCollection.forEach(selectedRow -> {
                    Long fid = (Long)selectedRow.getPrimaryKeyValue();
                    receiptDownloadConnectMonitorUtils.isMeetConditionDelete(fid);
                });
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                args.setCancel(true);
            }
        }
        if (Objects.equals(TEST_CONNECT_OPERATION_KEY, operateKey)) {
            listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection.size() == 0 || listSelectedRowCollection == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptConnectMonitorListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                try {
                    receiptDownloadConnectMonitorUtils.testConnect(fid, false);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"ReceiptConnectMonitorListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
            });
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)TEST_CONNECT_SETTING_KEY, (CharSequence)operateKey)) {
            this.showSettingPage();
        }
    }

    public void showSettingPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("receipt_c_monitor_setting");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

