/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.paramsconfig;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.upload.UploadOption;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.receipt.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.AttachServiceUtil;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.constant.OperateLogType;
import kd.ebg.receipt.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.receipt.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.receipt.formplugin.service.info.InfoService;
import kd.ebg.receipt.formplugin.util.FieldType;
import kd.ebg.receipt.formplugin.util.FieldUtil;
import kd.ebg.receipt.formplugin.util.OperateLogUtils;
import kd.ebg.receipt.formplugin.util.StringUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ReceiptBusinessConfigFormPlugin
extends AbstractBillPlugIn
implements ClickListener,
UploadListener {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptBusinessConfigFormPlugin.class);
    private static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    private static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private static final String specialCode = "******";
    private static final String cacheKeyPre = "password_";
    private static final String uploadTelnetKey = "upload_telnet";
    private static final String uploadTelnetName = ReceiptBusinessConfigFormPlugin.getUploadTelnetName();
    private static final String isUseOpenApi = "isUseOpenApi";
    private UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
    private static final String ATTACHMENTPANELKEY = "attachmentPanelKey";
    private static final String UPLOAD_FILED_NAME_MAP_KEY = "upload_filed_name_map_key";

    private static String getUploadTelnetName() {
        return ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5", (String)"ReceiptBusinessConfigFormPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals(isUseOpenApi, fieldKey)) {
            this.setFieldShowOrHide();
        }
        if (StringUtils.equals("receiptAlert", fieldKey)) {
            this.setFieldShowOrHide();
        }
        if (StringUtils.equals("is_open_eves_key", fieldKey)) {
            this.setFieldShowOrHideByFieldKey(fieldKey, "on", new String[]{"receipt_ip", "receipt_port", "receipt_uri", "private_cert", "public_pk", "sig_cer_no", "btn_private_cert", "btn_public_pk", "des_code", "src_code", "receive_code"});
        }
    }

    public void setFieldShowOrHide() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"cosmic_api_url", "cosmic_user_name", "cosmic_app_id", "cosmic_app_securet", "cosmic_account_id"});
        String isUseOpenApiValue = "true";
        try {
            isUseOpenApiValue = (String)this.getModel().getDataEntity().get(isUseOpenApi);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.equals(isUseOpenApiValue, "false")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cosmic_api_url", "cosmic_user_name", "cosmic_app_id", "cosmic_app_securet", "cosmic_account_id", "baritemap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cosmic_api_url", "cosmic_user_name", "cosmic_app_id", "cosmic_app_securet", "cosmic_account_id", "baritemap"});
        }
        String alertWay = "mobile";
        try {
            alertWay = (String)this.getModel().getDataEntity().get("receiptAlert");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.equals(alertWay, "mobile")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"receiptMobile".toLowerCase(Locale.ENGLISH)});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"receiptEmail".toLowerCase(Locale.ENGLISH)});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"receiptMobile".toLowerCase(Locale.ENGLISH)});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"receiptEmail".toLowerCase(Locale.ENGLISH)});
        }
        List<String> defaultValues = FieldUtil.getDefaultValue(BusinessPropertyConfig.receiptFileUploadWay.getMlDefaultValues(), null);
        this.getModel().getDataEntity().set("receipt_file_upload_way", (Object)defaultValues.get(0));
    }

    public void setFieldShowOrHideByFieldKey(String fieldKey, String shownByValue, String[] showFieldKeys) {
        try {
            String fieldValue = (String)this.getModel().getValue(fieldKey);
            if (Objects.equals(shownByValue, fieldValue)) {
                this.getView().setVisible(Boolean.valueOf(true), showFieldKeys);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), showFieldKeys);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        this.createDynamicPanel(false);
        this.getPageCache().put("hasAddToContainer", "true");
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("BusinessPropertyConfigPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<FieldsetPanelAp> FieldsetPanelApList = this.createDynamicPanel(true);
        Container myFldPanel = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        FieldsetPanelApList.stream().forEach(fieldsetPanelAp -> myFldPanel.getItems().addAll(((Container)fieldsetPanelAp.buildRuntimeControl()).getItems()));
        this.getView().createControlIndex(myFldPanel.getItems());
        PropertyConfigInfo propertyConfigInfo = this.infoService.getCommonBusinessConfig();
        if (propertyConfigInfo != null) {
            String customID = RequestContext.get().getTenantId();
            QFilter[] filters = new QFilter[]{new QFilter("object_id", "=", (Object)propertyConfigInfo.getPropertyConfigID()), new QFilter("object_name", "=", (Object)"receipt"), new QFilter("custom_id", "=", (Object)customID)};
            DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_key, attr_value", (QFilter[])filters);
            if (!CollectionUtils.isEmpty((Collection)datas)) {
                HashSet dbDataSet = new HashSet(1);
                List<PropertyConfigItemInfo> configItemInfoList = this.getConfigItems();
                Map<String, PropertyConfigItemInfo> configItemInfoListMap = configItemInfoList.stream().collect(Collectors.toMap(PropertyConfigItemInfo::getKey, propertyConfig -> propertyConfig));
                datas.stream().forEach(data -> {
                    String configid = data.getString("attr_key");
                    String value = data.getString("attr_value");
                    String cacheKey = cacheKeyPre + configid;
                    if (this.getView().getPageCache().get(cacheKey) != null) {
                        this.getView().getPageCache().put(cacheKey, value);
                        value = specialCode;
                    }
                    try {
                        this.getModel().getDataEntity().set(configid, (Object)value);
                        dbDataSet.add(configid);
                        configItemInfoListMap.remove(configid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                for (Map.Entry<String, PropertyConfigItemInfo> entry : configItemInfoListMap.entrySet()) {
                    PropertyConfigItemInfo propertyConfigItemInfo2 = entry.getValue();
                    if (!CollectionUtils.isEmpty(propertyConfigItemInfo2.getDefaultValues()) && Objects.equals(propertyConfigItemInfo2.getType(), BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getName())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo2.getKey(), (Object)propertyConfigItemInfo2.getDefaultValues().get(0));
                        continue;
                    }
                    if (!CollectionUtils.isEmpty(propertyConfigItemInfo2.getDefaultValues()) && Objects.equals(propertyConfigItemInfo2.getType(), BusinessPropertyConfigType.RECEIPT_DOWNLOAD_PARAM.getName())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo2.getKey(), (Object)propertyConfigItemInfo2.getDefaultValues().get(0));
                        continue;
                    }
                    if (!CollectionUtils.isEmpty(propertyConfigItemInfo2.getDefaultValues()) && Objects.equals(propertyConfigItemInfo2.getType(), BusinessPropertyConfigType.RECEIPT_ALERT_PARAM.getName())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo2.getKey(), (Object)propertyConfigItemInfo2.getDefaultValues().get(0));
                        continue;
                    }
                    if (Objects.equals(propertyConfigItemInfo2.getKey(), "receipt_file_upload_way")) {
                        List<String> defaultValues = FieldUtil.getDefaultValue(propertyConfigItemInfo2.getMlDefaultValues(), null);
                        this.getModel().getDataEntity().set(propertyConfigItemInfo2.getKey(), (Object)defaultValues.get(0));
                        continue;
                    }
                    if (dbDataSet.contains(propertyConfigItemInfo2.getKey()) || propertyConfigItemInfo2.getDefaultValues().isEmpty()) continue;
                    this.getModel().getDataEntity().set(propertyConfigItemInfo2.getKey(), (Object)propertyConfigItemInfo2.getDefaultValues().get(0));
                }
            } else {
                this.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
                    if (!CollectionUtils.isEmpty(propertyConfigItemInfo.getDefaultValues())) {
                        this.getModel().getDataEntity().set(propertyConfigItemInfo.getKey(), (Object)propertyConfigItemInfo.getDefaultValues().get(0));
                    }
                });
            }
        }
        this.setFieldShowOrHide();
        this.setFieldShowOrHideByFieldKey("is_open_eves_key", "on", new String[]{"receipt_ip", "receipt_port", "receipt_uri", "private_cert", "public_pk", "sig_cer_no", "btn_private_cert", "btn_public_pk", "des_code", "src_code", "receive_code"});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<PropertyConfigItemInfo> configItemInfos = this.getConfigItems();
        configItemInfos.stream().forEach(propertyConfigItemInfo -> {
            if (StringUtils.equals(propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH), e.getKey()) || StringUtils.equals("btn_" + propertyConfigItemInfo.getKey().toLowerCase(Locale.ENGLISH), e.getKey())) {
                TextEdit textEdit = new TextEdit();
                String key = propertyConfigItemInfo.getKey();
                if (Objects.equals(propertyConfigItemInfo.getInputType(), ConfigInputType.PASSWORD.getInputType())) {
                    key = key.toUpperCase(Locale.ENGLISH);
                }
                if ("upload".equals(propertyConfigItemInfo.getInputType()) && e.getKey().startsWith("btn_")) {
                    Button button = new Button();
                    button.setKey("btn_" + propertyConfigItemInfo.getKey());
                    button.setOperationKey("upload");
                    button.setView(this.getView());
                    e.setControl((Control)button);
                    return;
                }
                textEdit.setKey(key);
                textEdit.setView(this.getView());
                e.setControl((Control)textEdit);
            }
        });
    }

    public List<PropertyConfigItemInfo> getConfigItems() {
        PropertyConfigInfo propertyConfigInfo = this.infoService.getCommonBusinessConfig();
        this.logger.info("\u56de\u5355\u5168\u5c40\u914d\u7f6e\u9879\uff1a{}", (Object)JSONObject.toJSONString((Object)propertyConfigInfo.getConfigItems().toArray()));
        if (propertyConfigInfo != null) {
            return propertyConfigInfo.getConfigItems().stream().filter(c -> "receipt".equals(BusinessPropertyConfigType.getTypeByName((String)c.getType()))).collect(Collectors.toList());
        }
        return null;
    }

    private List<FieldsetPanelAp> createDynamicPanel(boolean isNeedResult) {
        ArrayList<FieldsetPanelAp> result = new ArrayList<FieldsetPanelAp>(16);
        String hasAddToContainer = this.getPageCache().get("hasAddToContainer");
        if (hasAddToContainer != null && !isNeedResult) {
            this.logger.info("\u9762\u677f\u5df2\u7ecf\u521b\u5efa\u4e86----->{}-{}", new Object[]{hasAddToContainer, isNeedResult});
            return result;
        }
        List<PropertyConfigItemInfo> configItemInfos = this.getConfigItems();
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        configItemInfos.stream().forEach(propertyConfigItemInfo -> {
            String type = propertyConfigItemInfo.getType() == null ? "default" : propertyConfigItemInfo.getType();
            ArrayList<PropertyConfigItemInfo> propertyConfigItemInfos = (ArrayList<PropertyConfigItemInfo>)map.get(type);
            if (propertyConfigItemInfos == null) {
                propertyConfigItemInfos = new ArrayList<PropertyConfigItemInfo>(16);
                map.put(type, propertyConfigItemInfos);
            }
            propertyConfigItemInfos.add((PropertyConfigItemInfo)propertyConfigItemInfo);
        });
        Container container = (Container)this.getView().getControl(CONTAINER_KEY_CONTAINER);
        this.logger.info("\u521b\u5efa\u9762\u677f\u5f00\u59cb----->{}", (Object)container.toString());
        for (Map.Entry entry : map.entrySet()) {
            String type = (String)entry.getKey();
            FieldsetPanelAp flex = this.createFieldsetPanelAp(type);
            this.addFieldsetPanelApItems(flex, (List)map.get(type));
            if (hasAddToContainer == null) {
                ArrayList<Map> array = new ArrayList<Map>(16);
                array.add(flex.createControl());
                this.logger.info("\u521b\u5efa\u9762\u677f\u5b57\u6bb5----->{}", array.toArray());
                container.addControls(array);
            }
            result.add(flex);
        }
        return result;
    }

    public void addFieldsetPanelApItems(FieldsetPanelAp flex, List<PropertyConfigItemInfo> propertyConfigItemInfos) {
        propertyConfigItemInfos.stream().forEach(p -> {
            FieldAp fieldAp;
            String name = FieldUtil.getName(p.getMlName(), p.getName());
            String desc = FieldUtil.getDesc(p.getMlDesc(), p.getDesc());
            List<String> sourceNames = FieldUtil.getSourceNames(p.getMlSourceNames(), p.getSourceNames());
            if (!CollectionUtils.isEmpty(sourceNames) || ConfigInputType.SELECT.getInputType().equals(p.getInputType())) {
                fieldAp = FieldUtil.createComboField(name, p.getKey(), p.isReadonly(), p.isMustInput(), desc, p.getSourceValues(), sourceNames);
            } else if (ConfigInputType.INTEGER.getInputType().equals(p.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, p.getKey(), p.isMustInput(), p.isReadonly(), FieldType.INTEGER, desc);
                FieldUtil.setIntegerFieldApDataScope(fieldAp, p.getMinValueNum(), p.getMaxValueNum());
            } else if (FieldType.TEXTAREA.getName().equals(p.getInputType())) {
                fieldAp = FieldUtil.createTextareaField(name, p.getKey(), p.isMustInput(), p.isReadonly(), p.getMaxValueNum(), desc);
            } else {
                boolean isPassword = ConfigInputType.PASSWORD.getInputType().equals(p.getInputType());
                String key = p.getKey();
                if (isPassword) {
                    key = key.toUpperCase(Locale.ENGLISH);
                }
                fieldAp = FieldUtil.createTextField(name, key, p.isReadonly(), p.isMustInput(), desc, isPassword);
                if (isPassword) {
                    String cacheKey = cacheKeyPre + p.getKey();
                    if (this.getView().getPageCache().get(cacheKey) == null) {
                        this.getView().getPageCache().put(cacheKey, "");
                    }
                }
            }
            flex.getItems().add(fieldAp);
            if (ConfigInputType.UPLOAD.getInputType().equals(p.getInputType())) {
                ButtonAp buttonAp = FieldUtil.createButtonAp(p.getKey());
                flex.getItems().add(buttonAp);
            }
        });
    }

    public FieldsetPanelAp createFieldsetPanelAp(String type) {
        FieldsetPanelAp flex = new FieldsetPanelAp();
        flex.setKey(type);
        flex.setCollapsible(true);
        flex.setName(new LocaleString("default".equals(type) ? ResManager.loadKDString((String)"\u57fa\u7840\u53c2\u6570", (String)"ReceiptBusinessConfigFormPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]) : BusinessPropertyConfigType.getDescByName((String)type)));
        flex.setGrow(1);
        flex.setShrink(0);
        Style style = new Style();
        Border border = new Border();
        border.setTop("10px #E2E7EF solid");
        style.setBorder(border);
        flex.setStyle(style);
        return flex;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        this.getConfigItems().stream().forEach(propertyConfigItemInfo -> {
            String key = propertyConfigItemInfo.getKey();
            boolean isPassword = false;
            if (Objects.equals(propertyConfigItemInfo.getInputType(), ConfigInputType.PASSWORD.getInputType())) {
                key = key.toUpperCase(Locale.ENGLISH);
                isPassword = true;
            }
            TextProp textProp = this.buildTextPorp(key, propertyConfigItemInfo.getName(), isPassword);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        });
    }

    private TextProp buildTextPorp(String key, String name, boolean isPassword) {
        TextProp textProp = new TextProp();
        textProp.setName(key);
        textProp.setDisplayName(new LocaleString(name));
        if (isPassword) {
            textProp.setPassword(true);
        }
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        return textProp;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        attachmentPanelKeys.stream().forEach(key -> {
            Button uploadButton = (Button)this.getView().getControl(key);
            if (uploadButton != null) {
                uploadButton.addClickListener((ClickListener)this);
                uploadButton.addUploadListener((UploadListener)this);
            }
        });
    }

    List<String> getAttachmentPanelKey() {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(ATTACHMENTPANELKEY) != null) {
            String keys = this.getPageCache().get(ATTACHMENTPANELKEY);
            return StringUtil.isNil(keys) ? new ArrayList(16) : Arrays.asList(keys.split(","));
        }
        ArrayList<String> result = new ArrayList<String>(16);
        List<PropertyConfigItemInfo> infos = this.getConfigItems();
        String str = "";
        if (!CollectionUtils.isEmpty(infos) && !CollectionUtils.isEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            for (PropertyConfigItemInfo p2 : fileUploadConfigItemInfoList) {
                str = str + "btn_" + p2.getKey() + ",";
                result.add("btn_" + p2.getKey());
            }
            str = str.substring(0, str.length() - 1);
        }
        this.getPageCache().put(ATTACHMENTPANELKEY, str);
        return result;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        List<String> attachmentPanelKeys = this.getAttachmentPanelKey();
        if (!CollectionUtils.isEmpty(attachmentPanelKeys)) {
            for (String uploadKey : attachmentPanelKeys) {
                if (!StringUtils.equals(source.getKey(), uploadKey)) continue;
                UploadOption option = new UploadOption();
                option.setMultiple(false);
                option.setTitle(this.getUploadNameMap(uploadKey));
                option.setSuffix(".p12,.cer,.pem,.crt,.pfx,.p7b,.txt,.key");
                option.setLimitSize(0x200000L);
                option.setLimitCount(1);
                this.getView().showUpload(option, uploadKey);
            }
        }
    }

    void showUploadPage(String pageCaption, String fieldKey, boolean isUpload) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aqap_cert_parse");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!isUpload) {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("type", (Object)CertType.BANKLOGIN_CER.getType());
        }
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCaption(pageCaption);
        showParameter.setCustomParam("fieldKey", (Object)fieldKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(showParameter);
    }

    public void upload(UploadEvent evt) {
        String customID = RequestContext.get().getTenantId();
        String fieldKey = evt.getCallbackKey().replaceFirst("btn_", "");
        LinkedHashMap linkedHashMap = (LinkedHashMap)evt.getUrls()[0];
        Object fileName = linkedHashMap.get("name");
        String url = linkedHashMap.get("url").toString();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.download(url, (OutputStream)bos, "httpclient");
        byte[] byteArray = bos.toByteArray();
        try {
            String fileContent = DesUtil.encryptProxyCert((byte[])byteArray, (String)customID);
            this.getPageCache().put(fieldKey + "content", fileContent);
            this.getModel().setValue(fieldKey, fileName);
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u8bc1\u4e66\u5f02\u5e38\u3002", (String)"ReceiptBankLoginFormPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
    }

    String getUploadNameMap(String key) {
        List fileUploadConfigItemInfoList;
        if (this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY) != null) {
            String keys = this.getPageCache().get(UPLOAD_FILED_NAME_MAP_KEY);
            return this.getUploadName(keys, key);
        }
        List<PropertyConfigItemInfo> infos = this.getConfigItems();
        StringBuilder str = new StringBuilder();
        if (!CollectionUtils.isEmpty(infos) && !CollectionUtils.isEmpty(fileUploadConfigItemInfoList = infos.stream().filter(p -> "upload".equals(p.getInputType())).collect(Collectors.toList()))) {
            for (PropertyConfigItemInfo p2 : fileUploadConfigItemInfoList) {
                str.append("btn_").append(p2.getKey()).append("-").append(p2.getName()).append(",");
            }
            str = str.delete(0, str.length() - 1);
        }
        this.getPageCache().put(UPLOAD_FILED_NAME_MAP_KEY, str.toString());
        return this.getUploadName(str.toString(), key);
    }

    String getUploadName(String str, String key) {
        String[] arr;
        if (StringUtil.isNil(str)) {
            return "";
        }
        for (String s : arr = str.split(",")) {
            String[] k = s.split("-");
            if (!k[0].equals(key)) continue;
            return k[1];
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals("bar_save_true", evt.getItemKey()) && this.getModel().getContextVariable("is_save") != null) {
            String[] res;
            IDataModel model = this.getModel();
            PropertyConfigInfo propertyConfigInfo = this.infoService.getCommonBusinessConfig();
            String objectName = "receipt";
            List<PropertyConfigItemInfo> configItems = this.getConfigItems();
            String customID = RequestContext.get().getTenantId();
            String createTaskPeriod = (String)model.getValue("create_task_period");
            if (StringUtils.isEmpty(createTaskPeriod)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u56de\u5355\u4efb\u52a1\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptBusinessConfigFormPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            String alertWay = "mobile";
            try {
                alertWay = (String)this.getModel().getDataEntity().get("receiptAlert");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Objects.equals(alertWay, "mobile")) {
                String mobileStr = (String)model.getValue("receiptMobile".toLowerCase(Locale.ENGLISH));
                if (StringUtils.isNotEmpty(mobileStr)) {
                    res = mobileStr.split("\\;");
                    for (int i = 0; i < res.length; ++i) {
                        if (StringUtil.isChinaPhoneLegal(res[i])) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u624b\u673a\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u3002", (String)"ReceiptBusinessConfigFormPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), i + 1));
                        return;
                    }
                }
            } else {
                String emailStr = (String)model.getValue("receiptEmail".toLowerCase(Locale.ENGLISH));
                if (StringUtils.isNotEmpty(emailStr)) {
                    res = emailStr.split("\\;");
                    for (int i = 0; i < res.length; ++i) {
                        if (StringUtil.isEmail(res[i])) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u90ae\u7bb1\u5730\u5740\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u6b63\u786e\u7684\u90ae\u7bb1\u5730\u5740\u3002", (String)"ReceiptBusinessConfigFormPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), i + 1));
                        return;
                    }
                }
            }
            try {
                int createTaskPeriodInt = Integer.parseInt(createTaskPeriod);
                if (createTaskPeriodInt < 1 || createTaskPeriodInt > 90) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u56de\u5355\u4efb\u52a1\u5929\u6570\u5fc5\u987b\u586b\u5199\u5927\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e90\u7684\u6b63\u6574\u6570\u3002", (String)"ReceiptBusinessConfigFormPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u521b\u5efa\u56de\u5355\u4efb\u52a1\u5929\u6570\u5fc5\u987b\u586b\u5199\u5927\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e90\u7684\u6b63\u6574\u6570\u3002", (String)"ReceiptBusinessConfigFormPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<String> operateLogList = new ArrayList<String>(1);
            OperateLogUtils operateLogUtils = new OperateLogUtils();
            configItems.stream().forEach(configItemInfo -> {
                String fileValue = (String)model.getValue(configItemInfo.getKey());
                if (ConfigInputType.PASSWORD.getInputType().equals(configItemInfo.getInputType()) && this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey()) != null && Objects.equals(specialCode, fileValue)) {
                    fileValue = this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey());
                }
                String name = FieldUtil.getName(configItemInfo.getMlName(), configItemInfo.getName());
                operateLogList.add(operateLogUtils.receiptBusinessConfigOperateLog(name, configItemInfo.getKey(), fileValue));
                this.delete(propertyConfigInfo.getPropertyConfigID(), objectName, configItemInfo.getKey());
                String value = (String)model.getValue(configItemInfo.getKey());
                this.save((PropertyConfigItemInfo)configItemInfo, propertyConfigInfo.getPropertyConfigID(), objectName, value, customID);
                Map<String, DynamicObject> cerMap = this.getCerDataMap();
                String key = configItemInfo.getKey();
                if ("upload".equals(configItemInfo.getInputType())) {
                    if (cerMap.get(configItemInfo.getKey()) != null) {
                        this.updateCer(cerMap.get(key), (PropertyConfigItemInfo)configItemInfo, "business_eves", "business_eves", customID, this.getPageCache().get(key + "content"), value);
                    } else if (this.getPageCache().get(key + "content") != null) {
                        this.addCer((PropertyConfigItemInfo)configItemInfo, "business_eves", "business_eves", customID, this.getPageCache().get(key + "content"), value);
                    }
                }
            });
            operateLogUtils.saveLogByList(operateLogList, this.getView().getEntityId(), OperateLogType.SAVE.getCnName());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReceiptBusinessConfigFormPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals("baritemap", evt.getItemKey())) {
            String uploadUrl = "";
            String appId = "";
            String appSecuretKey = "";
            String userName = "";
            try {
                uploadUrl = (String)this.getModel().getValue("cosmic_api_url");
                appId = (String)this.getModel().getValue("cosmic_app_id");
                appSecuretKey = (String)this.getModel().getValue("cosmic_app_securet");
                userName = (String)this.getModel().getValue("cosmic_user_name");
            }
            catch (Exception ex) {
                this.logger.error("\u6d4b\u8bd5\u4e0a\u4f20\u8fde\u63a5\u83b7\u5f97ip\u6216\u7aef\u53e3\u62a5\u9519", (Throwable)ex);
            }
            if (StringUtil.isNullOrEmpty(uploadUrl)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u82cd\u7a79\u5f00\u653e\u5e73\u53f0api\u5730\u5740\u3002", (String)"ReceiptBusinessConfigFormPlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNullOrEmpty(appId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u82cd\u7a79\u5f00\u653e\u5e73\u53f0appId\u3002", (String)"ReceiptBusinessConfigFormPlugin_8", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNullOrEmpty(appSecuretKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u82cd\u7a79\u5f00\u653e\u5e73\u53f0\u7cfb\u7edf\u5bc6\u7801\u3002", (String)"ReceiptBusinessConfigFormPlugin_9", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNullOrEmpty(userName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u82cd\u7a79\u5f00\u653e\u5e73\u53f0\u767b\u5f55\u7528\u6237\u540d\u3002", (String)"ReceiptBusinessConfigFormPlugin_10", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            String customNo = RequestContext.get().getTenantId();
            EBContext.setContext((EBContext)EBContext.builder().customID(customNo).build());
            if (Objects.equals(appSecuretKey, specialCode)) {
                appSecuretKey = this.getView().getPageCache().get("password_cosmic_app_securet");
            }
            String appToken = "";
            try {
                appToken = this.getAppToken(customNo, appId, appSecuretKey);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_11", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            try {
                if (StringUtil.isNullOrEmpty(appToken)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u83b7\u53d6appToken\u5931\u8d25\u3002", (String)"ReceiptBusinessConfigFormPlugin_12", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getAccessToken(customNo, appToken, userName);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_11", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()));
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u8fde\u63a5\u6210\u529f\u3002", (String)"ReceiptBusinessConfigFormPlugin_13", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
        }
    }

    Map<String, DynamicObject> getCerDataMap() {
        DynamicObject[] cerDatas = this.getCerDatas();
        HashMap map = Maps.newHashMapWithExpectedSize((int)8);
        if (cerDatas != null && cerDatas.length > 0) {
            for (DynamicObject cerData : cerDatas) {
                map.put((String)cerData.get("bank_config_id"), cerData);
            }
        }
        return map;
    }

    DynamicObject[] getCerDatas() {
        String bankLoginID = "business_eves";
        String customID = RequestContext.get().getTenantId();
        return this.userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
    }

    OperationResult addCer(PropertyConfigItemInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        return this.userCertRepository.addBankLoginCert(bankLoginInfo.getKey(), bankLoginInfo.getName(), bankVersion, bankLogin, customID, value, fileName);
    }

    void updateCer(DynamicObject cerData, PropertyConfigItemInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, String value, String fileName) {
        this.userCertRepository.updateBankLoginCert(cerData, bankLoginInfo.getKey(), bankLoginInfo.getName(), bankVersion, bankLogin, customID, value, fileName);
    }

    private String getAccessToken(String customNo, String appToken, String userName) {
        String accessToken;
        block18: {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost(AttachServiceUtil.getAccessTokenUrlCangqiong());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("user", (Object)userName);
                jsonObject.put("apptoken", (Object)appToken);
                String accountId = AttachServiceUtil.getCosmicAccountId();
                if (Objects.nonNull(accountId)) {
                    jsonObject.put("accountId", (Object)accountId);
                } else {
                    jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                }
                StringEntity entity = new StringEntity(jsonObject.toString());
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
                this.logger.info("\u53d1\u9001\u8bf7\u6c42\u83b7\u53d6AccessToken\uff1a" + httpPost.getURI());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject responseJson = JSONObject.parseObject((String)result);
                JSONObject data = (JSONObject)responseJson.get((Object)"data");
                if (data != null) {
                    accessToken = data.get((Object)"access_token").toString();
                    if (StringUtils.isEmpty(accessToken)) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_14", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), result));
                    }
                    break block18;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_14", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), result));
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6AccessToken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_15", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
        return accessToken;
    }

    private String getAppToken(String customNo, String appID, String appSecuret) {
        String appToken;
        block18: {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost(AttachServiceUtil.getAppTokenUrlCangqiong());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("appId", (Object)appID);
                jsonObject.put("appSecuret", (Object)appSecuret);
                String accountId = AttachServiceUtil.getCosmicAccountId();
                if (Objects.nonNull(accountId)) {
                    jsonObject.put("accountId", (Object)accountId);
                } else {
                    jsonObject.put("accountId", (Object)RequestContext.get().getAccountId());
                }
                StringEntity entity = new StringEntity(jsonObject.toString());
                entity.setContentEncoding("utf-8");
                entity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)entity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                JSONObject responseJson = JSONObject.parseObject((String)result);
                JSONObject data = (JSONObject)responseJson.get((Object)"data");
                if (data != null) {
                    appToken = data.get((Object)"app_token").toString();
                    if (StringUtils.isEmpty(appToken)) {
                        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_14", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), result));
                    }
                    break block18;
                }
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u82cd\u7a79\u8fd4\u56de\u62a5\u6587:%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_14", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), result));
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6AppToken-\u82cd\u7a79\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"ReceiptBusinessConfigFormPlugin_16", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
        return appToken;
    }

    void delete(String objectId, String objectName, String attr_key) {
        QFilter[] qFilters = new QFilter[]{new QFilter("object_id", "=", (Object)objectId), new QFilter("object_name", "=", (Object)objectName), new QFilter("attr_key", "=", (Object)attr_key)};
        DeleteServiceHelper.delete((String)ENTITY_KEY_OBJECT_PROPERTIES, (QFilter[])qFilters);
    }

    OperationResult save(PropertyConfigItemInfo configItemInfo, String objectId, String objectName, String value, String customID) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        if (ConfigInputType.PASSWORD.getInputType().equals(configItemInfo.getInputType()) && this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey()) != null && Objects.equals(specialCode, value)) {
            value = this.getView().getPageCache().get(cacheKeyPre + configItemInfo.getKey());
        }
        dataEntity.set("attr_key", (Object)configItemInfo.getKey());
        dataEntity.set("attr_value", (Object)value);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)objectName);
        dataEntity.set("custom_id", (Object)customID);
        OperationResult result = SaveServiceHelper.saveOperate((String)ENTITY_KEY_OBJECT_PROPERTIES, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
        if (Objects.equals(configItemInfo.getKey(), "isPrintReceiptLogger")) {
            String cacheName = String.format("isPrintReceiptLogger-%s", RequestContext.get().getAccountId());
            CosmicCache.delete((String)cacheName);
        }
        return result;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("bar_save_true", formOperate.getOperateKey())) {
            this.getModel().putContextVariable("is_save", (Object)Boolean.TRUE);
        }
    }
}

