/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.reconciliation;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReconciliationDetailListPlugin
extends AbstractListPlugin {
    private ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository = (ReconciliationDownloadListDetailRepository)SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long taskId = (Long)((ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("taskId");
        if (taskId != null) {
            e.getQFilters().add(new QFilter("refid", "=", (Object)String.valueOf(taskId)));
        }
        if (e.getMainOrgQFilter() != null) {
            e.setMainOrgQFilter(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"reupload", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            ArrayList needResetUploadTaskList = new ArrayList(16);
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.reconciliationDownloadListDetailRepository.selectById(fid);
                if (dynamicObject != null && UploadStatusEnum.UPLOAD_FAIL.getId() == dynamicObject.getInt("upload_flag")) {
                    dynamicObject.set("upload_flag", (Object)UploadStatusEnum.UN_UPLOAD.getId());
                    dynamicObject.set("upload_redo", (Object)0);
                    dynamicObject.set("upload_exp_msg", (Object)"");
                    dynamicObject.set("upload_time", (Object)-1);
                    needResetUploadTaskList.add(dynamicObject);
                }
            });
            if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
                SaveServiceHelper.save((DynamicObject[])needResetUploadTaskList.toArray(new DynamicObject[needResetUploadTaskList.size()]));
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReconciliationDetailListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }
}

