/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankReconciliationProperties;
import kd.ebg.receipt.common.framework.receipt.util.AttachServiceUtil;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.receipt.formplugin.service.CommonService;
import kd.ebg.receipt.formplugin.util.LocalDateUtils;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReconciliationDownloadTaskCreatePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    private static final String FIELD_KEY_BANK_VERSION = "bank_version";
    private static final String FIELD_KEY_BANK_LOGIN = "bank_login";
    private static final String FIELD_KEY_BANK_ACNT = "acc_no";
    private static final String ENTITY_KEY_BANK_LOGIN = "aqap_bank_login";
    private EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
    private CommonService commonService = (CommonService)SpringContextUtil.getBean(CommonService.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)FIELD_KEY_BANK_VERSION, (CharSequence)fieldKey)) {
            IDataModel model = this.getModel();
            model.setValue(FIELD_KEY_BANK_LOGIN, null);
            model.setValue(FIELD_KEY_BANK_ACNT, null);
            String bankVersion = (String)model.getDataEntity().get("bank_version.number");
            if (StringUtils.isNotEmpty((CharSequence)bankVersion)) {
                boolean isBankOfReconciliation = this.commonService.isBankOfReconciliation(bankVersion);
                if (isBankOfReconciliation) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_KEY_BANK_ACNT});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_KEY_BANK_ACNT});
                }
            }
        } else if (StringUtils.equals((CharSequence)FIELD_KEY_BANK_LOGIN, (CharSequence)fieldKey)) {
            IDataModel model = this.getModel();
            model.setValue(FIELD_KEY_BANK_ACNT, null);
        }
    }

    public void registerListener(EventObject e) {
        Toolbar toolbar;
        BasedataEdit acntFieldEdit;
        super.registerListener(e);
        BasedataEdit bankLoginFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_BANK_LOGIN);
        if (bankLoginFieldEdit != null) {
            bankLoginFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            bankLoginFieldEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        }
        if ((acntFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_BANK_ACNT)) != null) {
            acntFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit bankVersionFieldEdit = (BasedataEdit)this.getView().getControl(FIELD_KEY_BANK_VERSION);
        if (acntFieldEdit != null) {
            bankVersionFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmain")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String bankVersion;
        IDataModel model;
        String fieldKey = e.getProperty().getName();
        if (FIELD_KEY_BANK_VERSION.equals(fieldKey)) {
            List<String> bankVersionIDList = this.commonService.getReconciliationBankVersionIdList();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("number", "in", bankVersionIDList));
            qFilters.add(QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"}));
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_KEY_BANK_LOGIN)) {
            model = this.getModel();
            bankVersion = (String)model.getDataEntity().get("bank_version.number");
            if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
                model.getDataEntityType().getName();
                QFilter qFilter = QFilter.of((String)"group.number=? and enable=? and custom_id=? and config_type=?", (Object[])new Object[]{bankVersion, "1", RequestContext.get().getTenantId(), "0"});
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.setShowApproved(false);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_KEY_BANK_ACNT)) {
            model = this.getModel();
            bankVersion = (String)model.getDataEntity().get("bank_version.number");
            String bankLogin = (String)model.getDataEntity().get("bank_login.number");
            if (StringUtils.isNotBlank((CharSequence)bankVersion)) {
                model.getDataEntityType().getName();
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                QFilter qFilter = new QFilter("group.number", "=", (Object)bankVersion);
                qFilters.add(qFilter);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.setShowApproved(false);
                if (StringUtils.isNotBlank((CharSequence)bankLogin)) {
                    QFilter qFilter2 = new QFilter("bank_login.number", "=", (Object)bankLogin);
                    qFilters.add(qFilter2);
                }
                QFilter qFilter3 = new QFilter("has_receipt", "=", (Object)"1");
                qFilters.add(qFilter3);
                QFilter qFilter4 = new QFilter("enable", "=", (Object)"1");
                qFilters.add(qFilter4);
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent beforeQuickAddNewEvent) {
        String bankVersion = (String)this.getModel().getDataEntity().get("bank_version.number");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(ENTITY_KEY_BANK_LOGIN);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("100%");
        styleCss.setHeight("100%");
        baseShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("bankVersion", (Object)bankVersion);
        this.getView().showForm((FormShowParameter)baseShowParameter);
        beforeQuickAddNewEvent.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"submit_task", (CharSequence)formOperate.getOperateKey())) {
            LocalDate startDate = LocalDateUtils.date2LocalDate((Date)this.getModel().getDataEntity().get("trans_start_date"));
            LocalDate endDate = LocalDateUtils.date2LocalDate((Date)this.getModel().getDataEntity().get("trans_end_date"));
            IDataModel model = this.getModel();
            String customID = RequestContext.get().getTenantId();
            String bankVersion = (String)model.getDataEntity().get("bank_version.number");
            String bankLogin = (String)model.getDataEntity().get("bank_login.number");
            String accno = (String)model.getDataEntity().get("acc_no.number");
            EBContext ebContext = EBContext.builder().customID(customID).build();
            EBContext.setContext((EBContext)ebContext);
            boolean isSupportFutureDate = AttachServiceUtil.isSupportFutureDate();
            EBContext.destroy();
            if (bankVersion == null && endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u94f6\u884c\u7248\u672c\u201d\u3001\u201c\u56de\u5355\u65e5\u671f\u8303\u56f4\u201d\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (bankVersion == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u94f6\u884c\u7248\u672c\u201d\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (endDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u56de\u5355\u65e5\u671f\u8303\u56f4\u201d\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!isSupportFutureDate && LocalDate.now().isBefore(endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!isSupportFutureDate && LocalDate.now().isEqual(endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u624b\u52a8\u6dfb\u52a0\u5f53\u65e5\u5bf9\u8d26\u5355\u4efb\u52a1\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            HashMap needUpdReceiptInfoMap = Maps.newHashMapWithExpectedSize((int)8);
            ArrayList newTaskList = new ArrayList(16);
            if (StringUtils.isNotEmpty((CharSequence)accno)) {
                DynamicObject acnt = this.ebcBankAcntRepository.getAcntByAccno(accno);
                if (acnt == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8d26\u53f7\u4e0d\u5b58\u5728\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if ("0".equals(acnt.get("has_receipt"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u8d26\u53f7\u4e0d\u662f\u56de\u5355\u8d26\u53f7\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                EBContext context = EBContext.builder().customID(customID).bankVersionID(bankVersion).build();
                EBContext.setContext((EBContext)context);
                String bankLoginId = acnt.getString("bank_login.number");
                BankReconciliationProperties bankBusinessProperties = (BankReconciliationProperties)EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
                if (Objects.equals(bankBusinessProperties.getIsSupportReconciliation(), "true")) {
                    this.reconciliationDownloadTaskService.buildReceiptTaskDynamicObjects(newTaskList, bankVersion, startDate, endDate, acnt, customID, (Map)needUpdReceiptInfoMap);
                }
                EBContext.destroy();
            } else {
                DynamicObject[] dynamicObjects = StringUtil.isNotNil(bankLogin) ? this.ebcBankAcntRepository.selectByBankLoginAndHasReceipt(bankLogin, true) : this.ebcBankAcntRepository.selectByBankVersionAndHasReceipt(bankVersion, true);
                if (dynamicObjects == null || dynamicObjects.length == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u94f6\u884c[%s]\u56de\u5355\u8d26\u53f7\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u8d26\u53f7\u7ba1\u7406\u9875\u9762\u6dfb\u52a0\u56de\u5355\u8d26\u53f7\u3002", (String)"ReconciliationDownloadTaskCreatePlugin_8", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), bankVersion));
                    args.setCancel(true);
                    return;
                }
                for (DynamicObject accObject : dynamicObjects) {
                    EBContext context = EBContext.builder().customID(customID).bankVersionID(bankVersion).build();
                    EBContext.setContext((EBContext)context);
                    String bankLoginId = accObject.getString("bank_login.number");
                    BankReconciliationProperties bankBusinessProperties = (BankReconciliationProperties)EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
                    if (Objects.equals(bankBusinessProperties.getIsSupportReconciliation(), "true")) {
                        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersion)) {
                            newTaskList = new ArrayList(16);
                        }
                        this.reconciliationDownloadTaskService.buildReceiptTaskDynamicObjects(newTaskList, bankVersion, startDate, endDate, accObject, customID, (Map)needUpdReceiptInfoMap);
                        if (!RequestContextUtils.isAccNoOfReconciliationByBank((String)bankVersion) && !CollectionUtils.isEmpty(newTaskList)) {
                            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newTaskList.get(0)).getDataEntityType(), (Object[])newTaskList.toArray());
                            newTaskList = new ArrayList(16);
                        }
                    }
                    EBContext.destroy();
                }
            }
            if (!CollectionUtils.isEmpty(newTaskList)) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)newTaskList.get(0)).getDataEntityType(), (Object[])newTaskList.toArray());
                this.getPageCache().put("create_task_by_hand_success", "true");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
        if ("true".equals(this.getPageCache().get("create_task_by_hand_success"))) {
            this.getView().returnDataToParent((Object)"create_success");
        }
    }
}

