/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.reconciliation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadTaskRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;

public class ReconciliationDownloadTaskListPlugin
extends EbgCommonFilterContainerPlugin {
    private static final String ENTITY_KEY_RECONCIL_TASK_CREATE = "reconcil_task_create";
    private ReconciliationDownloadTaskRepository reconciliationDownloadTaskRepository = (ReconciliationDownloadTaskRepository)SpringContextUtil.getBean(ReconciliationDownloadTaskRepository.class);
    private ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository = (ReconciliationDownloadListDetailRepository)SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class);
    private BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        String status = "";
        status = String.valueOf(args.getFilterValue("status"));
        if ("null".equalsIgnoreCase(status)) {
            status = "";
        }
        this.getPageCache().put("selectedStatus", status);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (fieldName.equals("status") && paramMap.get("status") != null) {
                    if ("-1".equals(paramMap.get("status"))) {
                        List integers = TaskStatusEnum.getIDList();
                        Iterator iterator = integers.iterator();
                        while (iterator.hasNext()) {
                            int status = (Integer)iterator.next();
                            if (status == TaskStatusEnum.FAILED.getId()) {
                                iterator.remove();
                            }
                            if (status != TaskStatusEnum.FINISH.getId()) continue;
                            iterator.remove();
                        }
                        List statuss = integers.stream().map(integer -> integer + "").collect(Collectors.toList());
                        commonFilterColumn.setDefaultValues(statuss);
                        continue;
                    }
                    commonFilterColumn.setDefaultValue((String)paramMap.get("status"));
                    continue;
                }
                if (!fieldName.equals("trans_date") || paramMap.get("trans_date") == null) continue;
                ArrayList l = new ArrayList(16);
                l.add(paramMap.get("trans_date"));
                l.add(paramMap.get("trans_date"));
                commonFilterColumn.setDefaultValues(l);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"create_task_by_handle", (CharSequence)formOperate.getOperateKey())) {
            this.showCreateTaskPage();
        } else if (StringUtils.equals((CharSequence)"view_detail", (CharSequence)formOperate.getOperateKey())) {
            this.showReceiptDetailPage(args);
        } else if (StringUtils.equals((CharSequence)"reset_task", (CharSequence)formOperate.getOperateKey())) {
            this.resetTask(args);
        } else if (StringUtils.equals((CharSequence)"reset_upload_fail_task", (CharSequence)formOperate.getOperateKey())) {
            this.resetUploadTask(args);
        }
    }

    public void resetUploadTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        ArrayList needResetUploadTaskList = new ArrayList(16);
        ArrayList needResetTaskList = new ArrayList(16);
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject downloadTask = this.reconciliationDownloadTaskRepository.selectById(fid);
                DynamicObject[] dynamicObjects = this.reconciliationDownloadListDetailRepository.findByTaskIdAndUploadFlag(fid.longValue(), Long.valueOf(Long.parseLong(UploadStatusEnum.UPLOAD_FAIL.getId() + "")));
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        dynamicObject.set("upload_flag", (Object)UploadStatusEnum.UN_UPLOAD.getId());
                        dynamicObject.set("upload_redo", (Object)0);
                        dynamicObject.set("upload_exp_msg", (Object)"");
                        dynamicObject.set("upload_time", (Object)-1);
                        needResetUploadTaskList.add(dynamicObject);
                    }
                    if (downloadTask.getInt("upload_flag") == UploadTaskStatusEnum.UPLOAD_FAIL.getId()) {
                        downloadTask.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
                        needResetTaskList.add(downloadTask);
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
            SaveServiceHelper.save((DynamicObject[])needResetUploadTaskList.toArray(new DynamicObject[needResetUploadTaskList.size()]));
            if (!CollectionUtils.isEmpty(needResetTaskList)) {
                SaveServiceHelper.save((DynamicObject[])needResetTaskList.toArray(new DynamicObject[needResetTaskList.size()]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReconciliationDownloadTaskListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.getView().invokeOperation("refresh");
    }

    public void resetTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.reconciliationDownloadTaskRepository.selectById(fid);
                if (dynamicObject != null && (TaskStatusEnum.FAILED.getId() == dynamicObject.getInt("status") || TaskStatusEnum.FINISH.getId() == dynamicObject.getInt("status"))) {
                    BankLogin bankLogin;
                    String bankLoginName;
                    String customId = dynamicObject.getString("custom_id");
                    String bankLoginId = dynamicObject.getString("bank_login.number");
                    BankLoginKey key = new BankLoginKey();
                    key.setCustomId(customId);
                    key.setBankLoginId(bankLoginId);
                    Long acntId = dynamicObject.getLong("acc_no.id");
                    DynamicObject bankAcntRepositoryDynamicObject = this.bankAcntRepository.findById(acntId);
                    if (bankAcntRepositoryDynamicObject != null && !Objects.equals(bankLoginId, bankLoginName = bankAcntRepositoryDynamicObject.getString("bank_login.number"))) {
                        key.setBankLoginId(bankLoginName);
                        DynamicObject bankLogin2 = this.bankLoginRepository.findDynamicByIdAndCustomId(key);
                        dynamicObject.set("bank_login", (Object)bankLogin2);
                    }
                    if ((bankLogin = this.bankLoginRepository.findEnableBankLogin(key)) == null || Objects.equals(bankLogin.getEnable(), "false")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u7f6e\u5bf9\u8d26\u5355\u4efb\u52a1\u3002", (String)"ReconciliationDownloadTaskListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u6216\u5b8c\u6210\u7684\u4efb\u52a1\u53ef\u4ee5\u91cd\u7f6e\u3002", (String)"ReconciliationDownloadTaskListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                dynamicObject.set("status", (Object)TaskStatusEnum.CREATE.getId());
                dynamicObject.set("redo", (Object)0);
                dynamicObject.set("exp_msg", (Object)"");
                dynamicObject.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
                dynamicObject.set("complete_time", (Object)-1);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                this.getView().invokeOperation("refresh");
            });
        }
    }

    public void showCreateTaskPage() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(ENTITY_KEY_RECONCIL_TASK_CREATE);
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void showReceiptDetailPage(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Long fid = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = this.reconciliationDownloadTaskRepository.selectById(fid);
        if (dynamicObject == null || StringUtils.isEmpty((CharSequence)dynamicObject.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5bf9\u8d26\u5355\u4efb\u52a1\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"ReconciliationDownloadTaskListPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            this.getView().invokeOperation("refresh");
            return;
        }
        Long status = dynamicObject.getLong("status");
        if (status <= 4L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u4e0b\u8f7d\u7ed3\u679c\u67e5\u770b\u3002", (String)"ReconciliationDownloadTaskListPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("reconciliation_detail");
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("700");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)fid);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "create_success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

