/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.remote;

import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeBuildTreeNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListView;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.receipt.business.receipt.utils.ReceiptDownloadConnectMonitorUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.formplugin.pojo.receipt.ReceiptFileInfo;
import kd.ebg.receipt.formplugin.util.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class SftpLeftTreePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SftpLeftTreePlugin.class);
    public static final String KEY_TREEVIEW = "treeview";
    public static final String ROOT_ID = "01";
    public static final String SELECT_ID = "selectNodeId";
    public static final String ROOT_PATH = "/";
    public static final String ROOT_PATH_KEY = "rootPath";
    public static final String BANK_KEY = "bankVersionID";
    public static final String BANK_LOGIN_KEY = "bankLoginID";
    public static final String RECEIPT_REMOTE_SFTP_FILE_KEY = "receipt_remote_sftp_file";
    public static final String VIEW_MD5_KEY = "view_md5";
    private LinkedList<QFilter> rowQFilter = new LinkedList();
    private int dataCount = 0;

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                if ("enable".equalsIgnoreCase(qFilter.getProperty()) || !"file_name".equalsIgnoreCase(qFilter.getProperty())) continue;
                this.rowQFilter.add(qFilter);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final IPageCache iPageCache = this.getPageCache();
        final String dataCountCacheKey = "data_count";
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit + 1;
                int pageSize = limit;
                String nodeId = iPageCache.get(SftpLeftTreePlugin.SELECT_ID);
                String path = iPageCache.get(nodeId);
                if (StringUtils.isEmpty(path)) {
                    path = SftpLeftTreePlugin.this.getRootPath();
                }
                DynamicObjectCollection dObjectCollection = this.getCollection(path, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(SftpLeftTreePlugin.this.dataCount);
                iPageCache.put(dataCountCacheKey, SftpLeftTreePlugin.this.dataCount + "");
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(String path, int pageNo, int pageSize) {
                String selectFields = "name,number,file_path,file_name,enable,modifytime,file_size";
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)SftpLeftTreePlugin.RECEIPT_REMOTE_SFTP_FILE_KEY, (String)selectFields, null);
                List<ReceiptFileInfo> fileList = SftpLeftTreePlugin.this.getFileListByParentPath(path);
                if (!SftpLeftTreePlugin.this.rowQFilter.isEmpty()) {
                    QFilter qFilter = (QFilter)SftpLeftTreePlugin.this.rowQFilter.getFirst();
                    String cp = qFilter.getCP();
                    if (qFilter.getOriginValue() != null) {
                        if (qFilter.getOriginValue() instanceof String) {
                            LikeHint hint;
                            String value = (String)qFilter.getOriginValue();
                            if (Objects.equals(cp, "like") && (hint = (LikeHint)qFilter.getQFilterHint()) != null) {
                                if (hint.isAppendLeftPercent() && hint.isAppendRightPercent()) {
                                    fileList = fileList.stream().filter(o -> o.getFileName().contains(value)).collect(Collectors.toList());
                                }
                                if (hint.isAppendRightPercent() && !hint.isAppendLeftPercent()) {
                                    fileList = fileList.stream().filter(o -> o.getFileName().startsWith(value)).collect(Collectors.toList());
                                }
                                if (!hint.isAppendRightPercent() && hint.isAppendLeftPercent()) {
                                    fileList = fileList.stream().filter(o -> o.getFileName().endsWith(value)).collect(Collectors.toList());
                                }
                            }
                            if (Objects.equals(cp, "not like")) {
                                fileList = fileList.stream().filter(o -> !o.getFileName().contains(value)).collect(Collectors.toList());
                            }
                            if (Objects.equals(cp, "=")) {
                                fileList = fileList.stream().filter(o -> o.getFileName().equals(value)).collect(Collectors.toList());
                            }
                            if (Objects.equals(cp, "!=")) {
                                fileList = fileList.stream().filter(o -> !o.getFileName().equals(value)).collect(Collectors.toList());
                            }
                        }
                        if (qFilter.getOriginValue() instanceof QEmptyValue) {
                            fileList = fileList.stream().filter(o -> StringUtils.isEmpty(o.getFileName())).collect(Collectors.toList());
                        }
                    } else if (Objects.equals(cp, "is not null")) {
                        fileList = fileList.stream().filter(o -> StringUtils.isNotEmpty(o.getFileName())).collect(Collectors.toList());
                    }
                }
                SftpLeftTreePlugin.this.dataCount = fileList.size();
                fileList = fileList.stream().skip((pageNo - 1) * pageSize).limit(pageSize).collect(Collectors.toList());
                for (ReceiptFileInfo receiptFileInfo : fileList) {
                    DynamicObject data = dCollection.addNew();
                    data.set("file_path", (Object)receiptFileInfo.getParentPath());
                    data.set("file_name", (Object)receiptFileInfo.getFileName());
                    data.set("name", (Object)receiptFileInfo.getFileName());
                    data.set("number", (Object)receiptFileInfo.getPath());
                    data.set("file_size", (Object)receiptFileInfo.getSize());
                    if (receiptFileInfo.getEditTime() != null) {
                        data.set("modifytime", (Object)receiptFileInfo.getEditTime());
                    }
                    data.set("enable", (Object)"1");
                }
                return dCollection;
            }
        });
    }

    private int getFileMaxLength() {
        String fileMaxSize = System.getProperty("receipt_file_download_max_size", "100");
        return Integer.parseInt(fileMaxSize);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
    }

    public void beforeBuildTreeNode(BeforeBuildTreeNodeEvent e) {
        super.beforeBuildTreeNode(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.setMulti(false);
        TreeNode root = this.buildRootNode();
        String parentPath = root.getText();
        List<TreeNode> childNodes = this.loadChildNode(root.getId(), parentPath);
        for (TreeNode node1 : childNodes) {
            this.getView().getPageCache().put(node1.getId(), node1.getLongText());
        }
        root.setChildren(childNodes);
        treeView.addNode(root);
        if (childNodes.size() > 0) {
            treeView.expand(root.getId());
        }
        treeView.setRootVisible(false);
        treeView.setDraggable(false);
        treeView.setDroppable(false);
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        String nodeId = (String)arg0.getNodeId();
        TreeNode node = this.getTreeNodeById(nodeId);
        if (node != null) {
            String parentPath = node.getText();
            List<TreeNode> childNodes = this.loadChildNode(nodeId, parentPath);
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            for (TreeNode node1 : childNodes) {
                this.getView().getPageCache().put(node1.getId(), node1.getLongText());
            }
            treeView.addNodes(childNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block40: {
            block39: {
                super.beforeDoOperation(args);
                formOperate = (FormOperate)args.getSource();
                operateKey = formOperate.getOperateKey();
                if (!"view_md5".equals(operateKey) || (listSelectedRowCollection = args.getListSelectedData()) == null || listSelectedRowCollection.size() <= 0) break block39;
                message = new StringBuilder();
                sftp = null;
                savePath = null;
                try {
                    bankLoginID = this.getBankLoginID();
                    bankVersionID = this.getBankVersionID();
                    ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID((String)bankVersionID).customID(RequestContext.get().getTenantId()).build();
                    EBContext.setContext((EBContext)ebContext);
                    filePath = "";
                    savePath = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionID, (String)"sftp");
                    for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                        fileName = selectedRow.getName();
                        path = selectedRow.getNumber();
                        file = FileCommonUtils.getFileByPath((String)path);
                        parentPath = file.getParent();
                        receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                        sftp = receiptDownloadConnectMonitorUtils.connect(this.getIp(), Integer.parseInt(this.getPort()), this.getUser(), this.getCipher(), this.getCertPath());
                        receiptFile = FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName));
                        isDelete = true;
                        if (receiptFile.exists()) {
                            isDelete = receiptFile.delete();
                        }
                        if (isDelete) {
                            SFTPUtils.getInstance().downloadSingleFile(parentPath, fileName, savePath, sftp);
                        }
                        fileInputStream = new FileInputStream(FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)));
                        var22_34 = null;
                        try {
                            MD5 = DigestUtils.md5Hex((InputStream)fileInputStream);
                            message.append("MD5:").append(MD5);
                            filePath = path;
                        }
                        catch (Throwable MD5) {
                            var22_34 = MD5;
                            throw MD5;
                        }
                        finally {
                            if (fileInputStream != null) {
                                if (var22_34 != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable MD5) {
                                        var22_34.addSuppressed(MD5);
                                    }
                                } else {
                                    fileInputStream.close();
                                }
                            }
                        }
                        FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)).delete();
                    }
                    this.getView().showMessage(message.toString(), filePath, MessageTypes.Default);
                    args.setCancel(true);
                    ** GOTO lbl79
                }
                catch (Throwable e) {
                    try {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6MD5\u503c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SftpLeftTreePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[]{e.getMessage()}));
                        args.setCancel(true);
                    }
                    catch (Throwable var26_46) {
                        EBContext.destroy();
                        SFTPUtils.getInstance().close(sftp);
                        if (savePath == null) throw var26_46;
                        file = FileCommonUtils.getFileByPath(savePath);
                        var28_49 = file.listFiles();
                        var29_50 = var28_49.length;
                        var30_51 = 0;
                        while (var30_51 < var29_50) {
                            receiptFile = var28_49[var30_51];
                            if (receiptFile.isFile()) {
                                isDelete = receiptFile.delete();
                                SftpLeftTreePlugin.logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\uff1a{}-{}", new Object[]{receiptFile.getName(), isDelete});
                            }
                            ++var30_51;
                        }
                        throw var26_46;
                    }
lbl79:
                    // 1 sources

                    EBContext.destroy();
                    SFTPUtils.getInstance().close(sftp);
                    if (savePath == null) break block39;
                    file = FileCommonUtils.getFileByPath((String)savePath);
                    for (File receiptFile : file.listFiles()) {
                        if (!receiptFile.isFile()) continue;
                        isDelete = receiptFile.delete();
                        SftpLeftTreePlugin.logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\uff1a{}-{}", new Object[]{receiptFile.getName(), isDelete});
                    }
                    EBContext.destroy();
                    SFTPUtils.getInstance().close(sftp);
                    if (savePath != null) {
                        file = FileCommonUtils.getFileByPath((String)savePath);
                        for (File receiptFile : file.listFiles()) {
                            if (!receiptFile.isFile()) continue;
                            isDelete = receiptFile.delete();
                            SftpLeftTreePlugin.logger.info("\u6587\u4ef6\u662f\u5426\u5220\u9664\uff1a{}-{}", new Object[]{receiptFile.getName(), isDelete});
                        }
                    }
                }
            }
            if ("search".equals(operateKey)) {
                iListView = (IListView)this.getView();
                iListView.refresh();
            }
            if ("download".equals(operateKey) == false) return;
            listSelectedRowCollection = args.getListSelectedData();
            if (listSelectedRowCollection == null) return;
            if (listSelectedRowCollection.size() <= 0) return;
            sftp = null;
            savePath = null;
            try {
                bankLoginID = this.getBankLoginID();
                bankVersionID = this.getBankVersionID();
                ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                savePath = FileStorageUtil.getFileBatchBakPathByTransDate((String)bankVersionID, (String)"sftp");
lbl114:
                // 2 sources

                for (ListSelectedRow selectedRow : listSelectedRowCollection) {
                    fileName = selectedRow.getName();
                    path = selectedRow.getNumber();
                    file = FileCommonUtils.getFileByPath((String)path);
                    parentPath = file.getParent();
                    receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                    sftp = receiptDownloadConnectMonitorUtils.connect(this.getIp(), Integer.parseInt(this.getPort()), this.getUser(), this.getCipher(), this.getCertPath());
                    sftpStat = sftp.stat(path);
                    size = sftpStat.getSize();
                    fileSize = size > 1024L ? ((mathL = size % 1024L) > 0L ? size / 1024L + 1L : size / 1024L) : (size == 0L ? 0L : 1L);
                    if (fileSize > (long)(1024 * this.getFileMaxLength())) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u5927\u4e8e100M,\u4e0d\u652f\u6301\u5728\u7ebf\u4e0b\u8f7d\uff0c\u8bf7\u5230%s\u670d\u52a1\u5668\u5bf9\u5e94\u76ee\u5f55\u4e0b\u67e5\u770b\u3002", (String)"SftpLeftTreePlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[]{this.getIp()}));
                        args.setCancel(true);
                        break block40;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl168
            }
            catch (Throwable e) {
                try {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SftpLeftTreePlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[]{e.getMessage()}));
                    args.setCancel(true);
                    return;
                }
                catch (Throwable var33_54) {
                    throw var33_54;
                }
                finally {
                    EBContext.destroy();
                    SFTPUtils.getInstance().close(sftp);
                }
            }
        }
        EBContext.destroy();
        SFTPUtils.getInstance().close(sftp);
        return;
lbl-1000:
        // 1 sources

        {
            receiptFile = FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName));
            isDelete = true;
            if (receiptFile.exists()) {
                isDelete = receiptFile.delete();
            }
            if (isDelete) {
                SFTPUtils.getInstance().downloadSingleFile(parentPath, fileName, savePath, sftp);
            }
            try {
                bytes = Files.readAllBytes(FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)).toPath());
                tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                url = tfc.saveAsUrl(fileName, bytes, 120);
                this.getView().download(url);
            }
            catch (Throwable e) {
                SftpLeftTreePlugin.logger.monitorError("ebg#download#receipt#error" + e.getMessage(), e);
                this.getView().showErrorNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u4ecesftp\u4e0b\u8f7d\u6210\u529f\uff0c\u8f6c\u6362\u4e3a\u5e73\u53f0\u7684\u4e0b\u8f7d\u94fe\u63a5\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SftpLeftTreePlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), new Object[]{e.getMessage()})));
                args.setCancel(true);
                EBContext.destroy();
                SFTPUtils.getInstance().close(sftp);
                return;
            }
        }
        {
            FileCommonUtils.getFileByPath((String)(savePath + File.separator + fileName)).delete();
            ** GOTO lbl114
lbl168:
            // 1 sources

            args.setCancel(true);
        }
        EBContext.destroy();
        SFTPUtils.getInstance().close(sftp);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getView().getPageCache().put(SELECT_ID, (String)evt.getNodeId());
    }

    public TreeNode getTreeNodeById(String nodeId) {
        if (Objects.equals(nodeId, ROOT_ID)) {
            return this.buildRootNode();
        }
        String value = this.getView().getPageCache().get(nodeId);
        if (StringUtils.isNotEmpty(value)) {
            return new TreeNode("", nodeId, value);
        }
        return null;
    }

    public TreeNode buildRootNode() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode treeNodes = ((TreeListView)((ListView)treeView.getView()).getTreeListView()).getRoot();
        TreeNode node = new TreeNode(treeNodes.getId(), ROOT_ID, this.getRootPath());
        treeNodes.setChildren((List)Lists.newArrayList((Object[])new TreeNode[]{node}));
        this.getView().getPageCache().put(ROOT_ID, this.getRootPath());
        return node;
    }

    public String getRootPath() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String path = (String)paramMap.get(ROOT_PATH_KEY);
        if (!paramMap.containsKey(ROOT_PATH_KEY)) {
            return ROOT_PATH;
        }
        return path;
    }

    public String getBankVersionID() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey(BANK_KEY)) {
            return "";
        }
        String path = (String)paramMap.get(BANK_KEY);
        return path;
    }

    public String getBankLoginID() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey(BANK_KEY)) {
            return "";
        }
        String path = (String)paramMap.get(BANK_LOGIN_KEY);
        return path;
    }

    public String getIp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("bank_ftp_ip")) {
            return "";
        }
        String path = (String)paramMap.get("bank_ftp_ip");
        return path;
    }

    public String getPort() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("bank_ftp_port")) {
            return "";
        }
        String path = (String)paramMap.get("bank_ftp_port");
        return path;
    }

    public String getUser() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("ftp_user_name")) {
            return "";
        }
        String path = (String)paramMap.get("ftp_user_name");
        return path;
    }

    public String getCipher() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("ftp_cert_password")) {
            return "";
        }
        String path = (String)paramMap.get("ftp_cert_password");
        return path;
    }

    public String getCertPath() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!paramMap.containsKey("ftp_cert_path")) {
            return "";
        }
        String path = (String)paramMap.get("ftp_cert_path");
        return path;
    }

    private List<TreeNode> loadChildNode(String parentId, String parentPath) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(1);
        List<ReceiptFileInfo> paths = this.getPathByParentPath(parentPath);
        if (!paths.isEmpty()) {
            for (int i = 0; i < paths.size(); ++i) {
                ReceiptFileInfo receiptFileInfo = paths.get(i);
                String path = receiptFileInfo.getFileName();
                String id1 = parentId + i;
                TreeNode node1 = new TreeNode(parentId, id1, path);
                if (Objects.equals(parentPath, ROOT_PATH)) {
                    node1.setLongText(ROOT_PATH + path);
                } else {
                    node1.setLongText(parentPath + ROOT_PATH + path);
                }
                node1.setChildren(new ArrayList());
                childNodes.add(node1);
            }
        }
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReceiptFileInfo> getPathByParentPath(String parentPath) {
        ChannelSftp sftp;
        ArrayList<ReceiptFileInfo> paths;
        block9: {
            String bankLoginID = this.getBankLoginID();
            String bankVersionID = this.getBankVersionID();
            paths = new ArrayList<ReceiptFileInfo>(1);
            sftp = null;
            try {
                EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                sftp = receiptDownloadConnectMonitorUtils.connect(this.getIp(), Integer.parseInt(this.getPort()), this.getUser(), this.getCipher(), this.getCertPath());
                Vector vector = SFTPUtils.getInstance().listFiles(parentPath, sftp);
                if (!Objects.nonNull(vector) || vector.size() <= 0) break block9;
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    String filename = file.getFilename();
                    if (filename.equalsIgnoreCase(".") || filename.equalsIgnoreCase("..")) continue;
                    if (Objects.equals(parentPath, ROOT_PATH)) {
                        parentPath = "";
                    }
                    try {
                        sftp.cd(parentPath + ROOT_PATH + filename);
                        ReceiptFileInfo receiptFileInfo = ReceiptFileInfo.builder().fileName(filename).path(parentPath + ROOT_PATH + filename).editTime(this.getSftpModifyTime(file)).isPath().build();
                        paths.add(receiptFileInfo);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable e) {
                try {
                    logger.monitorError("getFileListByParentPath error" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SFTPUtils.getInstance().close(sftp);
                    EBContext.destroy();
                }
            }
        }
        SFTPUtils.getInstance().close(sftp);
        EBContext.destroy();
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReceiptFileInfo> getFileListByParentPath(String parentPath) {
        ChannelSftp sftp;
        ArrayList<ReceiptFileInfo> paths;
        block9: {
            String bankLoginID = this.getBankLoginID();
            String bankVersionID = this.getBankVersionID();
            paths = new ArrayList<ReceiptFileInfo>(1);
            sftp = null;
            try {
                EBContext ebContext = EBContext.builder().bankLoginID(bankLoginID).bankVersionID(bankVersionID).customID(RequestContext.get().getTenantId()).build();
                EBContext.setContext((EBContext)ebContext);
                ReceiptDownloadConnectMonitorUtils receiptDownloadConnectMonitorUtils = new ReceiptDownloadConnectMonitorUtils();
                sftp = receiptDownloadConnectMonitorUtils.connect(this.getIp(), Integer.parseInt(this.getPort()), this.getUser(), this.getCipher(), this.getCertPath());
                Vector vector = SFTPUtils.getInstance().listFiles(parentPath, sftp);
                if (!Objects.nonNull(vector) || vector.size() <= 0) break block9;
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    String filename = file.getFilename();
                    if (filename.equalsIgnoreCase(".") || filename.equalsIgnoreCase("..")) continue;
                    if (Objects.equals(parentPath, ROOT_PATH)) {
                        parentPath = "";
                    }
                    try {
                        sftp.cd(parentPath + ROOT_PATH + filename);
                    }
                    catch (Exception e) {
                        long mathL;
                        long size = file.getAttrs().getSize();
                        long fileSize = size > 1024L ? ((mathL = size % 1024L) > 0L ? size / 1024L + 1L : size / 1024L) : (size == 0L ? 0L : 1L);
                        ReceiptFileInfo receiptFileInfo = ReceiptFileInfo.builder().fileName(filename).path(parentPath + ROOT_PATH + filename).parentPath(StringUtils.isEmpty(parentPath) ? ROOT_PATH : parentPath).editTime(this.getSftpModifyTime(file)).size(Long.toString(fileSize)).isFile().build();
                        paths.add(receiptFileInfo);
                    }
                }
            }
            catch (Throwable e) {
                try {
                    logger.monitorError("getFileListByParentPath error" + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SFTPUtils.getInstance().close(sftp);
                    EBContext.destroy();
                }
            }
        }
        SFTPUtils.getInstance().close(sftp);
        EBContext.destroy();
        return paths;
    }

    private Date getSftpModifyTime(ChannelSftp.LsEntry sftpInfo) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        Date parse = null;
        try {
            String mtimeString = sftpInfo.getAttrs().getMtimeString();
            parse = sdf1.parse(mtimeString);
            return parse;
        }
        catch (ParseException e) {
            logger.info("\u83b7\u53d6sftp\u76ee\u5f55\u4e0b\u7684" + sftpInfo.getFilename() + "\u6587\u4ef6\u4fee\u6539\u65e5\u671f\u5931\u8d25\u3002");
            return null;
        }
    }
}

