/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.formplugin.util.CosmicDateUtil;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import org.eclipse.jetty.util.StringUtil;

public class ReceiptStatisticsByDatePlugin
extends AbstractListPlugin {
    private static final String ENTITY_KEY = "receipt_stats_by_day";
    private static final String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private BankVersionService bankVersionService = BankVersionService.getInstance();
    private int dataCount = 0;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (!fieldName.equals("trans_date") || paramMap.get("trans_date_start") == null) continue;
                ArrayList l = new ArrayList(16);
                l.add(paramMap.get("trans_date_start"));
                l.add(paramMap.get("trans_date_end"));
                commonFilterColumn.setDefaultValues(l);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        List qFilters = ((BillList)args.getSource()).getClientQueryFilterParameter().getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String startDateTime = "";
        String endDateTime = "";
        final String customID = RequestContext.get().getTenantId();
        if (this.getPageCache().get("isFirstInit") == null && !CollectionUtils.isEmpty((Map)paramMap)) {
            startDateTime = (String)paramMap.get("trans_date_start");
            endDateTime = (String)paramMap.get("trans_date_end");
            this.getPageCache().put("isFirstInit", "false");
        } else {
            for (QFilter filter : qFilters) {
                if (!filter.getProperty().startsWith("trans_date")) continue;
                startDateTime = CosmicDateUtil.timeTranslate(filter.getValue());
                endDateTime = CosmicDateUtil.timeTranslateBeforeDay(((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue());
            }
        }
        if (StringUtil.isBlank((String)startDateTime) || StringUtil.isBlank((String)endDateTime)) {
            return;
        }
        final Date startDate = DateUtil.string2Date((String)startDateTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = DateUtil.string2Date((String)endDateTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date nowDate = new Date();
        if (DateUtil.isBefore((Date)nowDate, (Date)startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"ReceiptStatisticsByDatePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DateUtil.isBefore((Date)nowDate, (Date)endDate)) {
            endDate = nowDate;
        }
        final Date finalEndDate = endDate;
        final IPageCache iPageCache = this.getPageCache();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptStatisticsByDatePlugin.this.getCollection(startDate, finalEndDate, customID, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptStatisticsByDatePlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptStatisticsByDatePlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!kd.ebg.receipt.formplugin.util.StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptStatisticsByDatePlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptStatisticsByDatePlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(Date startDate, Date endDate, String customID, int pageIndex, int pageSize) {
        DataSet dates;
        DynamicObjectCollection count;
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_version_name, trans_date, receipt_num, detail_num, match_num, upload_num, complete_pc, match_pc, upload_pc", null);
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        qFilters[1] = QFilter.of((String)"trans_date>=? and trans_date<=?", (Object[])new Object[]{startDate, endDate});
        List bankVersionList = this.bankVersionService.findByCustomId(customID);
        if (CollectionUtils.isEmpty((Collection)bankVersionList)) {
            return dCollection;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(16);
        StringBuilder bankVersionNameBuild = new StringBuilder();
        String bankVersionName = "";
        for (Object bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.parseLong(bankListEntity.getId()));
        }
        qFilters[2] = new QFilter("bank_version.id", "in", bankVersionIdList);
        DynamicObjectCollection bankVersionNames = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"distinct(bank_version.name) as bank_version_name", (QFilter[])qFilters);
        if (bankVersionNames != null && bankVersionNames.size() > 0) {
            for (DynamicObject dynamicObject : bankVersionNames) {
                bankVersionNameBuild.append(dynamicObject.getString("bank_version_name")).append(",");
            }
            bankVersionName = bankVersionNameBuild.toString().substring(0, bankVersionNameBuild.length() - 1);
        }
        if ((count = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"count(distinct trans_date) as count_num", (QFilter[])qFilters)).size() > 0) {
            this.dataCount = ((DynamicObject)count.get(0)).getInt("count_num");
        }
        if (!(dates = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".query"), (String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"distinct(trans_date) as trans_date", (QFilter[])qFilters, (String)"trans_date desc").limit(pageIndex * pageSize, pageSize)).isEmpty()) {
            for (Row row : dates) {
                DynamicObject data = dCollection.addNew();
                data.set("id", (Object)0);
                data.set("bank_version_name", (Object)bankVersionName);
                data.set("trans_date", (Object)row.getString("trans_date"));
                qFilters[1] = QFilter.of((String)"trans_date>= ? and trans_date<=?", (Object[])new Object[]{row.getDate("trans_date"), row.getDate("trans_date")});
                DynamicObjectCollection statistics = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])qFilters);
                ReceiptStatisticsUtil.buildStatisticsResult(statistics, data);
            }
        }
        return dCollection;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("search".equals(formOperate.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

