/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.model.repository.receipt.ReceiptDownloadTaskRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.plugin.task.ReceiptTaskUtils;

public class ReceiptDownloadTaskListPlugin
extends EbgCommonFilterContainerPlugin {
    private static final String ENTITY_KEY_RECEIPT_TASK_CREATE = "receipt_task_create";
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
    private ReceiptDownloadTaskRepository receiptDownloadTaskRepository = (ReceiptDownloadTaskRepository)SpringContextUtil.getBean(ReceiptDownloadTaskRepository.class);
    private DownloadListDetailRepository downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);
    private BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FilterParameter filters = args.getFilterParameter();
        List qList = filters.getQFilters();
        String status = "";
        status = String.valueOf(args.getFilterValue("status"));
        if ("null".equalsIgnoreCase(status)) {
            status = "";
        }
        this.getPageCache().put("selectedStatus", status);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (fieldName.equals("status") && paramMap.get("status") != null) {
                    if ("-1".equals(paramMap.get("status"))) {
                        List integers = TaskStatusEnum.getIDList();
                        Iterator iterator = integers.iterator();
                        while (iterator.hasNext()) {
                            int status = (Integer)iterator.next();
                            if (status == TaskStatusEnum.FAILED.getId()) {
                                iterator.remove();
                            }
                            if (status != TaskStatusEnum.FINISH.getId()) continue;
                            iterator.remove();
                        }
                        List statuss = integers.stream().map(integer -> integer + "").collect(Collectors.toList());
                        commonFilterColumn.setDefaultValues(statuss);
                        continue;
                    }
                    commonFilterColumn.setDefaultValue((String)paramMap.get("status"));
                    continue;
                }
                if (fieldName.equals("detail_flag") && paramMap.get("detail_flag") != null) {
                    commonFilterColumn.setDefaultValue((String)paramMap.get("detail_flag"));
                    continue;
                }
                if (!fieldName.equals("trans_date") || paramMap.get("trans_date") == null) continue;
                ArrayList l = new ArrayList(16);
                l.add(paramMap.get("trans_date"));
                l.add(paramMap.get("trans_date"));
                commonFilterColumn.setDefaultValues(l);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"create_task_by_handle", (CharSequence)formOperate.getOperateKey())) {
            this.showCreateTaskPage();
        } else if (StringUtils.equals((CharSequence)"view_receipt_detail", (CharSequence)formOperate.getOperateKey())) {
            this.showReceiptDetailPage(args);
        } else if (StringUtils.equals((CharSequence)"reset_fail_task", (CharSequence)formOperate.getOperateKey())) {
            this.resetFailTask(args);
        } else if (StringUtils.equals((CharSequence)"reset_task", (CharSequence)formOperate.getOperateKey())) {
            this.resetTask(args);
        } else if (StringUtils.equals((CharSequence)"reset_upload_fail_task", (CharSequence)formOperate.getOperateKey())) {
            this.resetUploadTask(args);
        } else if (StringUtils.equals((CharSequence)"view_log", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (listSelectedData != null && !listSelectedData.isEmpty()) {
                args.setCancel(true);
                Long selNumber = (Long)listSelectedData.get(0).getPrimaryKeyValue();
                DynamicObject receiptTask = this.receiptDownloadTaskRepository.findById(selNumber.longValue());
                QFilter filter = new QFilter("number", "=", (Object)"receipt");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_business_type", (String)"id,number,name", (QFilter[])filter.toArray());
                Long logger_batch_no = selNumber;
                Long bankId = receiptTask.getLong("bank_version.id");
                Date modifyTime = receiptTask.getDate("modifytime");
                String dateStr = DateUtil.transTimeZoneSystemToUser((Date)modifyTime);
                String dateFormat = "yyyy-MM-dd HH:mm:ss";
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
                LocalDateTime dateTime = LocalDateTime.parse(dateStr, dateTimeFormatter);
                LocalDateTime startDate = LocalDateUtil.getFirstTimeByDate((Date)LocalDateUtil.localDateTime2Date((LocalDateTime)dateTime.minusDays(30L)));
                LocalDateTime endDate = LocalDateUtil.getLastTimeByDate((Date)LocalDateUtil.localDateTime2Date((LocalDateTime)dateTime));
                String startTimeStr = LocalDateUtil.formatLocalDateTime((LocalDateTime)startDate, (String)dateFormat);
                String endTimeStr = LocalDateUtil.formatLocalDateTime((LocalDateTime)endDate, (String)dateFormat);
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("aqap_new_log");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap params = Maps.newHashMapWithExpectedSize((int)1);
                params.put("logger_batch_no", logger_batch_no.toString());
                params.put("trans_date_start", startTimeStr);
                params.put("trans_date_end", endTimeStr);
                params.put("bank_id", bankId.toString());
                if (dynamicObject != null) {
                    params.put("bd_biz_name_id", dynamicObject.get("id").toString());
                    params.put("bd_biz_name", dynamicObject.getString("number"));
                }
                showParameter.setCustomParams((Map)params);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (StringUtils.equals((CharSequence)"do_task", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (listSelectedData != null && !listSelectedData.isEmpty()) {
                if (listSelectedData.size() > 1) {
                    this.getView().showTipNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u6761\u4efb\u52a1\u6267\u884c\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u6267\u884c", (String)"ReceiptDownloadTaskListPlugin_6", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
                    args.setCancel(true);
                    return;
                }
                try {
                    Long taskID = (Long)listSelectedData.get(0).getPrimaryKeyValue();
                    ReceiptTaskUtils receiptTaskUtils = new ReceiptTaskUtils();
                    receiptTaskUtils.doReceiptTaskByTaskId(taskID);
                    this.getView().showSuccessNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)ResManager.loadKDString((String)"\u56de\u5355\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u56de\u5355\u4e0b\u8f7d\u7ed3\u679c", (String)"ReceiptDownloadTaskListPlugin_7", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
                    this.getView().invokeOperation("refresh");
                }
                catch (Throwable e) {
                    this.getView().showTipNotification(kd.ebg.egf.common.utils.string.StringUtils.norm((String)e.getMessage()));
                    args.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equals((CharSequence)"sett_sort", (CharSequence)formOperate.getOperateKey())) {
            this.showSettTaskSort();
        }
    }

    public void resetUploadTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        ArrayList needResetUploadTaskList = new ArrayList(16);
        ArrayList needResetTaskList = new ArrayList(16);
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject downloadTask = this.receiptDownloadTaskRepository.selectById(fid);
                DynamicObject[] dynamicObjects = this.downloadListDetailRepository.findByTaskIdAndUploadFlag(fid.longValue(), Long.valueOf(Long.parseLong(UploadStatusEnum.UPLOAD_FAIL.getId() + "")));
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        dynamicObject.set("upload_flag", (Object)UploadStatusEnum.UN_UPLOAD.getId());
                        dynamicObject.set("upload_redo", (Object)0);
                        dynamicObject.set("upload_exp_msg", (Object)"");
                        dynamicObject.set("upload_time", (Object)-1);
                        needResetUploadTaskList.add(dynamicObject);
                    }
                    if (downloadTask.getInt("upload_flag") == UploadTaskStatusEnum.UPLOAD_FAIL.getId()) {
                        downloadTask.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
                        needResetTaskList.add(downloadTask);
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
            SaveServiceHelper.save((DynamicObject[])needResetUploadTaskList.toArray(new DynamicObject[needResetUploadTaskList.size()]));
            if (!CollectionUtils.isEmpty(needResetTaskList)) {
                SaveServiceHelper.save((DynamicObject[])needResetTaskList.toArray(new DynamicObject[needResetTaskList.size()]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptDownloadTaskListPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.getView().invokeOperation("refresh");
    }

    public void resetTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.receiptDownloadTaskRepository.selectById(fid);
                if (dynamicObject != null && (TaskStatusEnum.FAILED.getId() == dynamicObject.getInt("status") || TaskStatusEnum.FINISH.getId() == dynamicObject.getInt("status"))) {
                    BankLogin bankLogin;
                    String bankLoginName;
                    String customId = dynamicObject.getString("custom_id");
                    String bankLoginId = dynamicObject.getString("bank_login.number");
                    BankLoginKey key = new BankLoginKey();
                    key.setCustomId(customId);
                    key.setBankLoginId(bankLoginId);
                    Long acntId = dynamicObject.getLong("acc_no.id");
                    DynamicObject bankAcntRepositoryDynamicObject = this.bankAcntRepository.findById(acntId);
                    if (bankAcntRepositoryDynamicObject != null && !Objects.equals(bankLoginId, bankLoginName = bankAcntRepositoryDynamicObject.getString("bank_login.number"))) {
                        key.setBankLoginId(bankLoginName);
                        DynamicObject bankLogin2 = this.bankLoginRepository.findDynamicByIdAndCustomId(key);
                        dynamicObject.set("bank_login", (Object)bankLogin2);
                    }
                    if ((bankLogin = this.bankLoginRepository.findEnableBankLogin(key)) == null || Objects.equals(bankLogin.getEnable(), "false")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u7f6e\u56de\u5355\u4efb\u52a1\u3002", (String)"ReceiptDownloadTaskListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    dynamicObject.set("status", (Object)TaskStatusEnum.CREATE.getId());
                    dynamicObject.set("redo", (Object)0);
                    dynamicObject.set("exp_msg", (Object)"");
                    dynamicObject.set("complete_time", (Object)-1);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    try {
                        List downloadListDetails;
                        List deleteIds;
                        DownloadListDetailService downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
                        if (downloadListDetailService != null && !(deleteIds = (downloadListDetails = downloadListDetailService.selectByRefId(fid)).stream().map(item -> item.getId()).collect(Collectors.toList())).isEmpty()) {
                            downloadListDetailService.deleteAll(deleteIds);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u6216\u5b8c\u6210\u7684\u4efb\u52a1\u53ef\u4ee5\u91cd\u7f6e\u3002", (String)"ReceiptDownloadTaskListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getView().invokeOperation("refresh");
            });
        }
    }

    public void resetFailTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        ArrayList needResetTaskList = new ArrayList(16);
        if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.receiptDownloadTaskRepository.selectById(fid);
                if (dynamicObject != null && (TaskStatusEnum.FINISH.getId() == dynamicObject.getInt("status") || TaskStatusEnum.FAILED.getId() == dynamicObject.getInt("status"))) {
                    String customId = dynamicObject.getString("custom_id");
                    String bankLoginId = dynamicObject.getString("bank_login.number");
                    BankLoginKey key = new BankLoginKey();
                    key.setCustomId(customId);
                    key.setBankLoginId(bankLoginId);
                    BankLogin bankLogin = this.bankLoginRepository.findEnableBankLogin(key);
                    if (bankLogin == null || Objects.equals(bankLogin.getEnable(), "false")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u91cd\u7f6e\u56de\u5355\u4efb\u52a1\u3002", (String)"ReceiptDownloadTaskListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    dynamicObject.set("status", (Object)TaskStatusEnum.RETRYING.getId());
                    dynamicObject.set("redo", (Object)0);
                    dynamicObject.set("exp_msg", (Object)"");
                    dynamicObject.set("complete_time", (Object)-1);
                    needResetTaskList.add(dynamicObject);
                }
            });
        }
        if (CollectionUtils.isEmpty(needResetTaskList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0b\u8f7d\u4efb\u52a1\u72b6\u6001\u4e3a\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptDownloadTaskListPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        SaveServiceHelper.save((DynamicObject[])needResetTaskList.toArray(new DynamicObject[needResetTaskList.size()]));
        this.getView().invokeOperation("refresh");
    }

    public void showCreateTaskPage() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(ENTITY_KEY_RECEIPT_TASK_CREATE);
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void showSettTaskSort() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("receipt_task_sort");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm(showParameter);
    }

    public void showReceiptDetailPage(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Long fid = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = this.receiptDownloadTaskRepository.selectById(fid);
        if (dynamicObject == null || StringUtils.isEmpty((CharSequence)dynamicObject.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u56de\u5355\u4efb\u52a1\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"ReceiptDownloadTaskListPlugin_4", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            this.getView().invokeOperation("refresh");
            return;
        }
        Long status = dynamicObject.getLong("status");
        if (status <= 4L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u56de\u5355\u4e0b\u8f7d\u7ed3\u679c\u67e5\u770b\u3002", (String)"ReceiptDownloadTaskListPlugin_5", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("receipt_detail");
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("700");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)fid);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        if (closedCallBackEvent.getReturnData() != null && "create_success".equals(result = (String)closedCallBackEvent.getReturnData())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

