/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;

public class ReceiptResultListPlugin
extends EbgCommonFilterContainerPlugin {
    private DownloadListDetailRepository downloadListDetailRepository = (DownloadListDetailRepository)SpringContextUtil.getBean(DownloadListDetailRepository.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ArrayList<DynamicObject> needResetUploadTaskList;
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"reupload", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            needResetUploadTaskList = new ArrayList<DynamicObject>(16);
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.downloadListDetailRepository.selectById(fid);
                if (dynamicObject != null && UploadStatusEnum.UPLOAD_FAIL.getId() == dynamicObject.getInt("upload_flag")) {
                    dynamicObject.set("upload_flag", (Object)UploadStatusEnum.UN_UPLOAD.getId());
                    dynamicObject.set("upload_redo", (Object)0);
                    dynamicObject.set("upload_exp_msg", (Object)"");
                    dynamicObject.set("upload_time", (Object)-1);
                    needResetUploadTaskList.add(dynamicObject);
                }
            });
            if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
                SaveServiceHelper.save((DynamicObject[])needResetUploadTaskList.toArray(new DynamicObject[needResetUploadTaskList.size()]));
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u5931\u8d25\u7684\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptResultListPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"edit_receipt_no", (CharSequence)formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            Long fid;
            if (listSelectedRowCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptResultListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            needResetUploadTaskList = new ArrayList(16);
            AtomicInteger selectCount = new AtomicInteger();
            for (ListSelectedRow selectedRow2 : listSelectedRowCollection) {
                fid = (Long)selectedRow2.getPrimaryKeyValue();
                DynamicObject dynamicObject = this.downloadListDetailRepository.selectById(fid);
                if (dynamicObject == null) continue;
                if (MatchStatusEnum.FAIL.getId() == dynamicObject.getInt("match_flag") && UploadStatusEnum.UPLOAD_SUCCESS.getId() == dynamicObject.getInt("upload_flag")) {
                    needResetUploadTaskList.add(dynamicObject);
                    selectCount.set(selectCount.get() + 1);
                }
                if (MatchStatusEnum.SUCCESS.getId() != dynamicObject.getInt("match_flag") && UploadStatusEnum.UPLOAD_SUCCESS.getId() == dynamicObject.getInt("upload_flag")) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptResultListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (needResetUploadTaskList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u4e0a\u4f20\u6210\u529f\u5e76\u4e14\u5339\u914d\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceiptResultListPlugin_3", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (needResetUploadTaskList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fee\u6539\u4e0a\u4f20\u6210\u529f\u4e14\u5339\u914d\u5931\u8d25\u7684\u5355\u6761\u8bb0\u5f55\u3002", (String)"ReceiptResultListPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!CollectionUtils.isEmpty(needResetUploadTaskList)) {
                DynamicObject dynamicObject = (DynamicObject)needResetUploadTaskList.get(0);
                String receiptNo = dynamicObject.getString("detail_no");
                fid = dynamicObject.getLong("id");
                this.showEditMatchNoPage(fid, receiptNo);
            }
        }
    }

    public void showEditMatchNoPage(Long fid, String receiptNo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("recordId", (Object)fid);
        showParameter.setCustomParam("old_receipt_no", (Object)receiptNo);
        showParameter.setFormId("receipt_match_update");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "test"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(showParameter);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String fromId = (String)listShowParameter.getCustomParam("fromId");
        if (Objects.equals(fromId, "receipt_stats_by_ac_day")) {
            String transDateStr = (String)listShowParameter.getCustomParam("transDateStr");
            Long accNoId = (Long)listShowParameter.getCustomParam("accNoId");
            String isInitFilter = this.getPageCache().get("isInitFilter");
            if (StringUtils.isEmpty((CharSequence)isInitFilter)) {
                if (accNoId != null) {
                    e.getQFilters().add(new QFilter("acc_no.id", "=", (Object)accNoId));
                }
                if (StringUtils.isNotEmpty((CharSequence)transDateStr)) {
                    e.getQFilters().add(new QFilter("trans_date", ">=", (Object)DateUtil.string2Date((String)transDateStr, (String)"yyyy-MM-dd")));
                }
                this.getPageCache().put("isInitFilter", "true");
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String isInitFilter = this.getPageCache().get("isInitFilter");
        if (StringUtils.isEmpty((CharSequence)isInitFilter)) {
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map paramMap = formShowParameter.getCustomParams();
            if (!CollectionUtils.isEmpty((Map)paramMap) && Objects.equals("receipt_defect_sta_by_mon", (String)paramMap.get("fromId")) | Objects.equals("receipt_stats_by_ac_day", (String)paramMap.get("fromId"))) {
                DynamicObject dynamicObject;
                Long accNoId = (Long)paramMap.get("accNoId");
                String bankVersionName = "";
                String bankLoginName = "";
                if (accNoId != null && (dynamicObject = bankAcntRepository.findById(accNoId)) != null) {
                    bankVersionName = dynamicObject.getString("group.id");
                    bankLoginName = dynamicObject.getString("bank_login.id");
                }
                this.getView().getPageCache().put("selectedBankId", bankVersionName);
                this.getView().getPageCache().put("selectedBankLoginId", bankLoginName);
                if (accNoId != null) {
                    this.getView().getPageCache().put("selectedAcntId", accNoId.toString());
                }
                for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                    CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                    String fieldName = commonFilterColumn.getFieldName();
                    String transDateStr = (String)paramMap.get("transDateStr");
                    if (fieldName.equals("trans_date") && paramMap.get("transDateStr") != null) {
                        ArrayList<String> l = new ArrayList<String>(16);
                        l.add(transDateStr);
                        l.add(transDateStr);
                        commonFilterColumn.setDefaultValues(l);
                    }
                    if (fieldName.equals("bank_version.name") && StringUtils.isNotEmpty((CharSequence)bankVersionName)) {
                        commonFilterColumn.setDefaultValue(bankVersionName);
                    }
                    if (fieldName.equals("bank_login.number") && StringUtils.isNotEmpty((CharSequence)bankLoginName)) {
                        commonFilterColumn.setDefaultValue(bankLoginName);
                    }
                    if (!fieldName.equals("acc_no.number") || accNoId == null) continue;
                    commonFilterColumn.setDefaultValue(accNoId.toString());
                }
            }
        }
        super.filterContainerInit(args);
    }
}

