/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.CollectionUtils;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.receipt.formplugin.util.FieldType;
import kd.ebg.receipt.formplugin.util.StringUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class FieldUtil {
    public static FieldAp createField(String name, String key) {
        return FieldUtil.createDynamicFieldBase(name, key, false, false, FieldType.TEXT, "");
    }

    public static FieldAp createDynamicFieldBase(String name, String key, boolean mustInput, boolean readOnly, FieldType fieldType, String desc) {
        TextField field;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (fieldType == FieldType.TEXT) {
            field = new TextField();
            fieldAp.setField((Field)field);
        } else if (fieldType == FieldType.INTEGER) {
            field = new IntegerField();
            fieldAp.setField((Field)field);
            fieldAp.setMask("#");
            field.setZeroShow(true);
        } else if (fieldType == FieldType.UPLOAD) {
            field = new AttachmentField();
            fieldAp.setField((Field)field);
        }
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        fieldAp.getField().setId(key);
        fieldAp.getField().setKey(key);
        fieldAp.getField().setMustInput(mustInput);
        return fieldAp;
    }

    public static void setFieldApReadOnly(FieldAp fieldAp, boolean readOnly) {
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
    }

    public static void setIntegerFieldApDataScope(FieldAp fieldAp, Integer minValue, Integer maxValue) {
        IntegerField integerField = (IntegerField)fieldAp.getField();
        int min = minValue == null ? 0 : minValue;
        int max = maxValue == null ? 0x7FFFFFFE : maxValue;
        integerField.setDataScope("[" + min + "," + max + "]");
    }

    public static void setFieldApMustInput(FieldAp fieldAp, boolean mustInput) {
        fieldAp.getField().setMustInput(mustInput);
    }

    public static void setIsPassword(FieldAp fieldAp) {
        if (fieldAp.getField() instanceof TextField) {
            TextField field = (TextField)fieldAp.getField();
            field.setPassword(true);
        }
    }

    public static void setFieldApTips(FieldAp fieldAp, String desc) {
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
    }

    public static void setFieldApMaxLength(TextField textField, Integer maxLength) {
        if (maxLength != null) {
            textField.setMaxLength(maxLength.intValue());
        }
        if (maxLength == null) {
            textField.setMaxLength(255);
        }
        if (maxLength != null && maxLength == 50) {
            textField.setMaxLength(255);
        }
    }

    public static FieldAp createDynamicFieldBase(String name, String key, boolean readOnly, String desc) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        return fieldAp;
    }

    public static FieldAp createAttachmentField(String name, String key, int maxAtmCount, String extendName, String tableName) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, false, false, FieldType.UPLOAD, "");
        AttachmentField field = (AttachmentField)fieldAp.getField();
        field.setMaxAtmCount(maxAtmCount);
        if (StringUtil.isNotNil(extendName)) {
            field.setExtendName(extendName);
        }
        if (StringUtil.isNotNil(tableName)) {
            field.setTableName(tableName);
        }
        return fieldAp;
    }

    public static FieldAp createTextField(String name, String key, boolean readOnly, boolean mustInput, String desc, boolean isPassword) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.TEXT, desc);
        TextField field = (TextField)fieldAp.getField();
        field.setPassword(isPassword);
        if (isPassword) {
            field.setEncrypt(false);
        }
        return fieldAp;
    }

    public static FieldAp createTextareaField(String name, String key, boolean mustInput, boolean readOnly, Integer maxLength, String desc) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        TextAreaField textAreaField = new TextAreaField();
        fieldAp.setField((Field)textAreaField);
        if (readOnly) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if (StringUtils.isNotEmpty(desc)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"FieldUtil_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
            tips.setContent(new LocaleString(desc));
            tips.setLink(false);
            fieldAp.setCtlTips(tips);
        }
        if (maxLength != null) {
            textAreaField.setMaxLength(maxLength.intValue());
        }
        fieldAp.getField().setId(key);
        fieldAp.getField().setKey(key);
        fieldAp.getField().setMustInput(mustInput);
        return fieldAp;
    }

    public static FieldAp createIntegerField(String name, String key) {
        return FieldUtil.createIntegerField(name, key, false, false, null, "#");
    }

    public static FieldAp createIntegerField(String name, String key, boolean mustInput, boolean readOnly, BigDecimal defValue, String mask) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, mustInput, readOnly, FieldType.INTEGER, "");
        IntegerField field = (IntegerField)fieldAp.getField();
        if (defValue != null) {
            field.setDefValue(defValue);
        }
        fieldAp.setMask(mask);
        return fieldAp;
    }

    public static FieldAp createComboField(String name, String key, boolean readOnly, boolean mustInput, String desc, List<String> comboKey, List<String> comboValue) {
        FieldAp fieldAp = FieldUtil.createDynamicFieldBase(name, key, readOnly, desc);
        ComboField field = new ComboField();
        field.setId(key);
        field.setKey(key);
        field.setMustInput(mustInput);
        fieldAp.setField((Field)field);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        for (int i = 0; i < comboKey.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setSeq(i);
            comboItem.setCaption(new LocaleString(comboValue.get(i)));
            comboItem.setValue(comboKey.get(i));
            items.add(comboItem);
        }
        field.setItems(items);
        return fieldAp;
    }

    public static ButtonAp createButtonAp(String key) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setKey("btn_" + key);
        buttonAp.setName(new LocaleString(ResManager.loadKDString((String)"\u70b9\u51fb\u4e0a\u4f20", (String)"FieldUtil_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0])));
        buttonAp.setWidth(new LocaleString("100px"));
        buttonAp.setFollowTheme(true);
        buttonAp.setOperationKey("upload");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        margin.setLeft("-20px");
        style.setMargin(margin);
        buttonAp.setStyle(style);
        buttonAp.setVisible("new,edit");
        return buttonAp;
    }

    public static String getDesc(List<MultiLangEnumBridge> mlDesc, String desc) {
        if (CollectionUtils.isEmpty(mlDesc)) {
            return desc;
        }
        StringBuilder builder = new StringBuilder();
        int size = mlDesc.size();
        for (int i = 0; i < size; ++i) {
            MultiLangEnumBridge ml = mlDesc.get(i);
            builder.append(ml.loadKDString());
            if (i == size - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static List<String> getSourceNames(List<MultiLangEnumBridge> mlSourceNames, List<String> sourceNames) {
        if (CollectionUtils.isEmpty(mlSourceNames)) {
            return sourceNames;
        }
        ArrayList<String> result = new ArrayList<String>(16);
        for (MultiLangEnumBridge ml : mlSourceNames) {
            result.add(ml.loadKDString());
        }
        return result;
    }

    public static List<String> getDefaultValue(List<MultiLangEnumBridge> mlDefaultValues, List<String> defaultValues) {
        if (CollectionUtils.isEmpty(mlDefaultValues)) {
            return defaultValues;
        }
        ArrayList<String> result = new ArrayList<String>(16);
        for (MultiLangEnumBridge ml : mlDefaultValues) {
            result.add(ml.loadKDString());
        }
        return result;
    }

    public static String getName(MultiLangEnumBridge mlName, String name) {
        return mlName == null ? name : mlName.loadKDString();
    }

    public static String getDesc(MultiLangEnumBridge mlDesc, String desc) {
        return mlDesc == null ? desc : mlDesc.loadKDString();
    }
}

