/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.formplugin.util.StringUtils;

public class LocalDateUtils {
    public static LocalDate date2LocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate getDayAfter(LocalDate localDate, int day) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, day);
        date = c.getTime();
        Instant instant = date.toInstant();
        localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static String getLastDayOfMonth(String transDateStr) {
        int year = Integer.parseInt(transDateStr.substring(0, 4));
        int month = Integer.parseInt(transDateStr.substring(4));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }

    public static List<String> getMonthsBetweenDate(LocalDate startDate, LocalDate endDate) {
        ArrayList<String> months = new ArrayList<String>(16);
        String startMonth = LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyyMM");
        String endMonth = LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyyMM");
        startDate = LocalDateUtils.parserDate(startMonth + "01");
        endDate = LocalDateUtils.parserDate(endMonth + "01");
        months.add(startMonth);
        while (startDate.isBefore(endDate)) {
            startDate = startDate.plusMonths(1L);
            String month = LocalDateUtil.formatDate((LocalDate)startDate, (String)"yyyyMM");
            months.add(month);
        }
        return months;
    }

    public static List<String> getMonthBetweenTrans(String startDaTeStr, String endDateStr) {
        LocalDate startDate = LocalDateUtils.parserDate(startDaTeStr);
        LocalDate endDate = LocalDateUtils.parserDate(endDateStr);
        List<String> betweenDate = LocalDateUtils.getMonthsBetweenDate(startDate, endDate);
        return betweenDate;
    }

    public static LocalDate parserDate(String dateStr) {
        if (StringUtils.isNotEmpty(dateStr) && dateStr.contains("-")) {
            return LocalDateUtils.parserDate(dateStr, "yyyy-MM-dd");
        }
        return LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE);
    }

    public static LocalDate parserDate(String dateStr, String pattern) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
    }

    public static String getEndDateByMonth(String monthStr) {
        return LocalDateUtils.getLastDayOfMonth(monthStr);
    }

    public static String getStartDateByMonth(String monthStr) {
        return monthStr + "01";
    }
}

