/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gxnx.cmp.service.receipt.utils;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.net.NetUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.gxnx.cmp.GxrcuMetaDataImpl;
import kd.ebg.receipt.banks.gxnx.cmp.service.receipt.utils.SignUtil;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import org.jdom2.Element;

public class Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(Packer.class);

    public static String packDetail(BankDetailRequest bankDetailRequest, String pageTag) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element root = Packer.packRoot();
        Element opReq = Packer.packHead(root, "CBE023");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"acct", (String)acnt.getAccNo());
        String start = bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String end = bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"bgnDt", (String)start);
        JDomUtils.addChild((Element)reqParam, (String)"endDt", (String)end);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageBgnPos", (String)pageTag);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageShowQnt", (String)String.valueOf(20));
        JDomUtils.addChild((Element)reqParam, (String)"branchId", (String)"6100");
        StringBuilder sb = new StringBuilder();
        sb.append(start).append("|").append(end).append("|").append(acnt.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"signDataStr", (String)sb.toString());
        String recvMsg = SignUtil.getInstance().sendAndRecvMsg(sb.toString());
        String sign = Packer.parseSign(recvMsg);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static Element packRoot() {
        return JDomUtils.createRoot((String)"QLBankData");
    }

    private static Element packHead(Element root, String bsnCode) {
        Element opReq = JDomUtils.addChild((Element)root, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)bsnCode);
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)RequestContextUtils.getBankParameterValue((String)GxrcuMetaDataImpl.CUSTOM_NO));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        JDomUtils.addChild((Element)opReq, (String)"reqMac", (String)NetUtil.getMacAddress((InetAddress)NetUtil.getLocalhost()));
        return opReq;
    }

    private static String parseSign(String returnStr) {
        Element root = JDomUtils.string2Root((String)returnStr, (String)RequestContextUtils.getCharset());
        Element head = root.getChild("head");
        String result = head.getChildText("result");
        String title = head.getChildText("title");
        if (!"0".equalsIgnoreCase(result)) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"Packer_1", (String)"ebg-receipt-banks-gxnx-cmp", (Object[])new Object[0]), title));
        }
        Element body = root.getChild("body");
        return body.getChildText("sign");
    }

    public static String decodeResponse(String responseStr) {
        try {
            String decode = URLDecoder.decode(responseStr, RequestContextUtils.getCharset());
            logger.info("url decode\u7684\u54cd\u5e94\u62a5\u6587\uff1a" + decode);
            return decode;
        }
        catch (UnsupportedEncodingException e) {
            return responseStr;
        }
    }
}

