/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hsb.dc.service.receipt.api;

import java.util.Map;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.utils.HSB_DC_Packer;
import kd.ebg.receipt.banks.hsb.dc.service.receipt.utils.HSB_DC_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import org.jdom2.Element;

public class GetBankReceiptFileNameImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptFileNameImpl.class);

    public String pack(BankReceiptRequest request) {
        Map paramMap = request.getParamsMap();
        String serial_no = (String)paramMap.get("serial_no");
        String account_seq = (String)paramMap.get("account_seq");
        String tr_acdt = (String)paramMap.get("tr_acdt");
        return HSB_DC_Packer.packOneReceiptDownload(serial_no, account_seq, tr_acdt);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        Element body;
        String fileName;
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        Element head = JDomUtils.getUnNullChildElement((Element)root, (String)"head");
        if (HSB_DC_Parser.checkResponseHeader(head) && EBGStringUtils.isNotEmpty((String)(fileName = (body = JDomUtils.getUnNullChildElement((Element)root, (String)"body")).getChildTextTrim("file_name")))) {
            return BankReceiptResponseEB.success((Object)fileName);
        }
        return BankReceiptResponseEB.fail();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020104A0262";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", RequestContextUtils.getCharset());
    }
}

