/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sde.dc.service;

import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.sde.dc.service.ReceiptInfo;
import kd.ebg.receipt.banks.sde.dc.service.detail.DetailImpl;
import kd.ebg.receipt.banks.sde.dc.service.receipt.B2EActTrsDetailPDFDownload;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"SDE_DC", (String)accNo, (String)transDateStr);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDateStr + "\n");
        List<ReceiptInfo> receiptInfos = this.sendAndReceiveReceiptInfo(acnt, transDate, transDateStr);
        if (receiptInfos.isEmpty()) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6%1$s\u660e\u7ec6\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-jjccb-cmp", (Object[])new Object[0]), transDateStr));
        }
        for (ReceiptInfo receiptInfo : receiptInfos) {
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            HashMap<String, ReceiptInfo> paramMap = new HashMap<String, ReceiptInfo>(2);
            paramMap.put("ReceiptInfo", receiptInfo);
            String fileName = receiptInfo.fileName();
            BankReceiptRequest req = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(paramMap).build();
            BankHeader header = new BankHeader();
            header.setAcnt(acnt);
            req.setHeader(header);
            try {
                BankReceiptResponseEB response = new B2EActTrsDetailPDFDownload().doBiz(req);
                String data = (String)response.getData();
                if (FileCommonUtils.base64ToFile((String)data, (String)(bakFilePath + File.separator + fileName))) {
                    downloadListDetail.setFileName(fileName);
                    downloadListDetail.setReceiptJson(receiptInfo.getMatchNoJson());
                    downloadListDetail.setFileLink(fileName);
                    downloadListDetails.add(downloadListDetail);
                    continue;
                }
                logger.error("{}\u4e0b\u8f7d\u5f02\u5e38\u3002", new Object[]{fileName});
            }
            catch (Throwable t) {
                logger.info("{}\u4e0b\u8f7d\u5f02\u5e38\u3002", (Object)fileName);
                logger.error(t.getMessage(), t);
            }
        }
        logger.info(">>>>>>>>>FETCH-{}-{}-\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        return BankReceiptHandleResponseEB.success(downloadListDetails);
    }

    private List<ReceiptInfo> sendAndReceiveReceiptInfo(BankAcnt account, LocalDate transDate, String transDateStr) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        header.setAcnt(account);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        EBBankDetailResponse response = new DetailImpl().doBiz(request);
        List details = response.getDetails();
        ArrayList<ReceiptInfo> receiptInfos = new ArrayList<ReceiptInfo>(8);
        for (DetailInfo detail : details) {
            ReceiptInfo receiptInfo = new ReceiptInfo(account.getAccNo(), transDateStr);
            receiptInfo.setAmount(detail.getReversed3());
            receiptInfo.setJnl1(detail.getReversed1());
            receiptInfo.setJnl2(detail.getReversed2());
            receiptInfo.setMatchNoJson(detail.getJson());
            receiptInfo.setChannelID(detail.getReversed4());
            receiptInfos.add(receiptInfo);
        }
        return receiptInfos;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "SDE_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-jjccb-cmp", (Object[])new Object[0]);
    }
}

