/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sde.dc.service.receipt;

import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.sde.dc.service.ReceiptInfo;
import kd.ebg.receipt.banks.sde.dc.service.utils.SDEPackerUtils;
import kd.ebg.receipt.banks.sde.dc.service.utils.SDEParserUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class B2EActTrsDetailPDFDownload
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(B2EActTrsDetailPDFDownload.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActTrsDetailPDFDownload";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Element root = SDEPackerUtils.createRootWithHead(Sequence.genSequence(), this.getBizCode());
        Map paramsMap = bankReceiptRequest.getParamsMap();
        ReceiptInfo receiptInfo = (ReceiptInfo)paramsMap.get("ReceiptInfo");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)bankReceiptRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"ChannelId", (String)receiptInfo.getChannelID());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)receiptInfo.getAmount());
        JDomUtils.addChild((Element)Map2, (String)"TransJnlDate", (String)bankReceiptRequest.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)Map2, (String)"TransJnlNo1", (String)receiptInfo.getJnl1());
        JDomUtils.addChild((Element)Map2, (String)"TransJnlNo2", (String)receiptInfo.getJnl2());
        EBContext.getContext().setRemoveWriteResponseLog(true);
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        EBContext.getContext().setRemoveWriteResponseLog(false);
        Element root = SDEParserUtils.parseRspToRoot(s);
        Element body = root.getChild("Body");
        String fileContent = body.getChildTextTrim("FileContent");
        if (StringUtils.isEmpty((String)fileContent)) {
            logger.info("\u54cd\u5e94\u62a5\u6587{}", (Object)s);
        }
        return BankReceiptResponseEB.success((Object)fileContent);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append(this.getBizCode()).append(".do?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

