/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.receipt.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.DetailPage;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.OPCB000016_ReceiveItem;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Root;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.helper.Packer;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.helper.Parser;
import kd.ebg.receipt.banks.bsz.dc.service.util.ApiUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BankReceiptInfoRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptInfoRequestImpl.class);

    public List<OPCB000016_ReceiveItem> queryReceiptList(BankReceiptRequest request) {
        ArrayList<OPCB000016_ReceiveItem> detailInfos = new ArrayList<OPCB000016_ReceiveItem>(1);
        this.setCurrentPage("1");
        boolean lastPage = false;
        this.setLastPage(false);
        while (!lastPage) {
            BankReceiptResponseEB response = this.doBiz(request);
            List receiveItems = (List)response.getData();
            if (Objects.nonNull(response) && Objects.nonNull(receiveItems)) {
                detailInfos.addAll(receiveItems);
            }
            this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
            lastPage = this.isLastPage();
        }
        return detailInfos;
    }

    public BankReceiptResponseEB doBiz(BankReceiptRequest request) {
        try {
            Map bodyMap = Packer.getSendObject(request, this.getBizCode());
            bodyMap.put("PAGE_ROW_COUNT", "20");
            bodyMap.put("CURRENT_PAGE", this.getCurrentPage());
            logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)bodyMap.toString());
            String responseStr = ApiUtils.doPostRequest(bodyMap);
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u67e5\u8be2\u7535\u5b50\u56de\u5355\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u5b50\u56de\u5355\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BankReceiptInfoRequestImpl_0", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u5b50\u56de\u5355\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"BankReceiptInfoRequestImpl_1", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return null;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        try {
            if (DetailPage.isLastPage(responseStr, this.getCurrentPage())) {
                this.setLastPage(true);
            }
            Root root = Parser.getRecvObject(responseStr, this.getBizCode());
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)Parser.analyse(this.getBizCode(), request, root);
            return receiptResponseEB;
        }
        catch (Exception e) {
            this.setLastPage(true);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u7535\u5b50\u56de\u5355\u62a5\u6587\u5f02\u5e38\uff1a%s\u3002", (String)"BankReceiptInfoRequestImpl_2", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "OPCB000016";
    }

    public String getBizDesc() {
        return "";
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml");
    }
}

