/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.receipt.api.interfaces;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Header4Receive;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Header4Send;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.OPCB000016_Receive;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.OPCB000016_ReceiveItem;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.OPCB000016_Send;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Root;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.interfaces.IMiniService;
import kd.ebg.receipt.banks.bsz.dc.service.util.Utils;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class OPCB000016
implements IMiniService<Root<Header4Send, OPCB000016_Send>, Root<Header4Receive, OPCB000016_Receive>, BankReceiptRequest, BankReceiptResponseEB> {
    public static String transCode = "OPCB000016";

    public static OPCB000016 getInstance() {
        return Holder.instance;
    }

    @Override
    public Root<Header4Send, OPCB000016_Send> getSendRoot(BankReceiptRequest receiptRequest) throws Exception {
        Root<Header4Send, OPCB000016_Send> root = new Root<Header4Send, OPCB000016_Send>();
        OPCB000016_Send body = new OPCB000016_Send();
        body.setACCT_NO(receiptRequest.getAccNo());
        LocalDate transDate = receiptRequest.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        body.setSTART_DATE(transDateStr);
        body.setEND_DATE(transDateStr);
        body.setPAGE_ROW_COUNT("20");
        root.setBody(body);
        return root;
    }

    @Override
    public Root<Header4Receive, OPCB000016_Receive> getrecvRoot(String rspStr) {
        Root root = (Root)JSON.parseObject((String)rspStr, (TypeReference)new TypeReference<Root<Header4Receive, OPCB000016_Receive>>(){}, (Feature[])new Feature[0]);
        return root;
    }

    @Override
    public BankReceiptResponseEB recvStrategy(Root<Header4Receive, OPCB000016_Receive> root, BankReceiptRequest receiptRequest) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000016_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\u3002", (String)"OPCB000016_0", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000016_ReceiveItem> receipt_array = body.getRECEIPT_ARRAY();
        return BankReceiptResponseEB.success(receipt_array);
    }

    @Override
    public String getTransCode() {
        return transCode;
    }

    private static class Holder {
        private static final OPCB000016 instance = new OPCB000016();

        private Holder() {
        }
    }
}

