/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.receipt.download;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.BankReceiptDownloadImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "CBS_RECEIPT_DOWNLOAD";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"BSZ_DC", (String)accNo, (String)transDateStr);
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            if (downloadListDetail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                this.download(downloadListDetail, bakFilePath, request);
            }
            result.add(downloadListDetail);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public DownloadListDetail download(DownloadListDetail downloadListDetail, String bakFilePath, BankReceiptHandleRequest request) {
        String receiptNo = downloadListDetail.getFileLink();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(request.getTransDate()).accNo(request.getAccNo()).requestStr(receiptNo).build();
        BankReceiptDownloadImpl bankReceiptDownload = new BankReceiptDownloadImpl();
        String base64Str = (String)bankReceiptDownload.doBiz(bankReceiptRequest).getData();
        FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + downloadListDetail.getFileName()));
        return downloadListDetail;
    }
}

