/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.util;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.common.model.repository.UserCertRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.apache.commons.codec.binary.Base64;

public class KeyStoreUtil {
    public static String getPublicPK() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("public_pk", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"KeyStoreUtil_0", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = KeyStoreUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return KeyStoreUtil.getKey(fileContent);
    }

    public static byte[] getPrivateCertChain() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("private_cert", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"KeyStoreUtil_1", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = KeyStoreUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    public static byte[] getPrivateCertFile() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("private_cert_file", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237\u7aef\u79c1\u94a5\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"KeyStoreUtil_2", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = KeyStoreUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return fileContent;
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }
}

