/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.WJ12Impl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLogin = request.getBankLoginId();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"SPDB_DC", (String)accNo, (String)transDateStr);
        SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLogin);
        boolean isUseNewApi = Objects.equals(config.getIs_use_new_api(), "true");
        if (request.getTransDate().isEqual(LocalDate.now()) || isUseNewApi) {
            try {
                logger.info("\u5f53\u524d\u4f4d\u7f6e\u5f53\u65e5\u56de\u5355DownloadImpl\uff0c\u67e5\u8be2\u5230\u7684detail\u6570\u91cf\u4e3a\uff1a" + downloadListDetails.size());
                int count = 1;
                for (DownloadListDetail downloadListDetail : downloadListDetails) {
                    String recieptNo = downloadListDetail.getFileLink();
                    String fileName = downloadListDetail.getFileName();
                    logger.info("\u5373\u5c06\u4e0b\u8f7d\u7684\u7b2c" + count++ + "\u4e2a\u56de\u5355\u6587\u4ef6\u540d\u662f" + fileName);
                    WJ12Impl.getInstance().postRequest(request.getAccNo(), transDateStr, bakFilePath, recieptNo, fileName);
                }
                return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u56de\u5355\u5f02\u5e38\uff1a%s\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
        }
        return BankReceiptHandleResponseEB.success((Object)downloadListDetails);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SPDB_DC_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u6d77\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]);
    }
}

