/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt;

import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.DY47Impl;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.WJ01Impl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.ErrorMsgUtil;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public boolean isBreak() {
        if (RequestContextUtils.getRunningParam((String)"isBreak") != null) {
            return Boolean.parseBoolean(RequestContextUtils.getRunningParam((String)"isBreak"));
        }
        return true;
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest bankReceiptHandleRequest) {
        this.init(bankReceiptHandleRequest);
        long taskId = bankReceiptHandleRequest.getTaskId();
        DownloadListTask task = this.downloadTaskService.findById(taskId);
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        List ids = downloadListDetails.stream().map(o -> o.getId()).collect(Collectors.toList());
        this.downloadListDetailService.deleteAll(ids);
        List<DownloadListDetail> result = new ArrayList(16);
        String accNo = task.getAccNo();
        String transDate = task.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bankLogin = EBContext.getContext().getBankLoginID();
        SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLogin);
        boolean isUseNewApi = Objects.equals(config.getIs_use_new_api(), "true");
        if (bankReceiptHandleRequest.getTransDate().isEqual(LocalDate.now()) || isUseNewApi) {
            RequestContextUtils.setRunningParam((String)"isBreak", (String)Boolean.TRUE.toString());
            logger.info("\u51c6\u5907\u8c03\u7528DY47\u63a5\u53e3\u53d1\u8d77\u524d\u7f6e\u8bf7\u6c42");
            try {
                List<String> sList = DY47Impl.getInstance().postRequest(accNo, transDate);
                logger.info("DY47\u8bf7\u6c42\u5b8c\u6bd5\uff0c\u8fd4\u56de\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a\uff1a" + sList.size());
                logger.info("DY47\u8fd4\u56de\u7684json\u96c6\u5408\uff1a" + sList);
                for (String jsonStr : sList) {
                    DownloadListDetail detail = new DownloadListDetail();
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                    String acceptNo = jsonObject.getString("acceptNo");
                    String hostGyno = jsonObject.getString("hostGyno");
                    String transAmount = jsonObject.getString("transAmount");
                    String debitFlag = jsonObject.getString("debitFlag");
                    String subpoenaSeqNo = jsonObject.getString("subpoenaSeqNo");
                    StringBuilder fileNameBuilder = new StringBuilder();
                    fileNameBuilder.append(accNo).append("_");
                    fileNameBuilder.append(transDate).append("_");
                    fileNameBuilder.append(hostGyno).append("_");
                    fileNameBuilder.append(debitFlag).append("_");
                    fileNameBuilder.append(transAmount).append("_receipt_");
                    fileNameBuilder.append(transDate);
                    if (isUseNewApi) {
                        fileNameBuilder.append("_").append(subpoenaSeqNo).append(".pdf");
                    } else {
                        fileNameBuilder.append(".pdf");
                    }
                    detail.setFileName(fileNameBuilder.toString());
                    detail.setFileLink(acceptNo);
                    result.add(detail);
                }
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u56de\u5355\u5f02\u5e38\uff1a%s\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            return BankReceiptHandleResponseEB.success(result);
        }
        try {
            RequestContextUtils.setRunningParam((String)"isBreak", (String)Boolean.FALSE.toString());
            String bakPath = FileStorageUtil.getFileBakPath((String)bankLogin) + File.separator + transDate;
            File bakFile = FileCommonUtils.getFileByPath((String)bakPath);
            boolean downloadFlag = false;
            String zipFileName = "Receipt_" + transDate + ".zip";
            File receiptFile = FileCommonUtils.getFileByPath((String)(bakFile + File.separator + zipFileName));
            if (receiptFile.exists()) {
                result = FileCommonUtils.getDetailList((DownloadListTask)task, (String)zipFileName);
            } else {
                if (config.getPushWay().equals("SFTP")) {
                    BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
                    if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                        downloadFlag = this.ftpDownload(bakPath, zipFileName, EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? "/" : bankFtpProperties.getFtpPath());
                    } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                        downloadFlag = this.frontProxyDownload(zipFileName, accNo, task.getTransDate());
                    }
                }
                if (config.getPushWay().equals("API")) {
                    logger.info("\u51c6\u5907\u8c03\u7528WJO1\u63a5\u53e3\u83b7\u53d6\u56de\u5355");
                    logger.info("\u7c7b\u5b9e\u4f8b\u5316");
                    zipFileName = WJ01Impl.getInstance().postRequest(accNo, transDate, bakPath);
                    if (StringUtils.isNotEmpty((String)zipFileName)) {
                        downloadFlag = true;
                        RequestContextUtils.setZipName((String)zipFileName);
                    }
                    logger.info("\u51c6\u5907\u8c03\u7528WJO1\u63a5\u53e3\u83b7\u53d6\u56de\u5355\u5b8c\u6210");
                }
                if (downloadFlag) {
                    logger.info("\u4e0b\u8f7d\u6587\u4ef6" + zipFileName + "\u6210\u529f..");
                    result = FileCommonUtils.getDetailList((DownloadListTask)task, (String)zipFileName);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u5217\u8868\u5931\u8d25\uff1a%s", (String)"BankReceiptFetchListImpl_5", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    private boolean frontProxyDownload(String orgFileName, String accNo, LocalDate transDate) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.downloadReceiptFile(orgFileName);
    }

    private boolean ftpDownload(String destFolder, String orgFileName, String ftpPath) {
        boolean downloadFlag = false;
        ChannelSftp sftp = null;
        try {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp();
            }
            if (sftp == null) {
                throw new ReceiptException(ResManager.loadKDString((String)"sftp\u8fde\u63a5\u5931\u8d25", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]));
            }
            Vector vector = sftp.ls(ftpPath);
            if (Objects.nonNull(vector) && vector.size() > 0) {
                for (Object o : vector) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)o;
                    if (!file.getFilename().equals(orgFileName)) continue;
                    downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, orgFileName, destFolder, sftp);
                }
            }
        }
        catch (Exception e) {
            try {
                String msg = ErrorMsgUtil.getSFTPErrorMSG((String)"", (String)e.getMessage());
                throw new ReceiptException(msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        SFTPUtils.getInstance().close(sftp);
        return downloadFlag;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SPDB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e0a\u6d77\u6d66\u4e1c\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_4", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]);
    }
}

