/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.Packer;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.DY47ProxyImpl;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.Signature;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import org.jdom2.Element;

public class DY47Impl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DY47Impl.class);
    private static DY47Impl dy47;

    public static synchronized DY47Impl getInstance() {
        if (dy47 == null) {
            dy47 = new DY47Impl();
        }
        return dy47;
    }

    public int getStart() {
        String v = RequestContextUtils.getRunningParam((String)"start");
        return StringUtils.isEmpty((String)v) ? 1 : Integer.parseInt(v);
    }

    public void setStart(int start) {
        RequestContextUtils.setRunningParam((String)"start", (String)String.valueOf(start));
    }

    public boolean isBool() {
        String b = RequestContextUtils.getRunningParam((String)"bool");
        return StringUtils.isEmpty((String)b) || Boolean.parseBoolean(b);
    }

    public void setBool(boolean bool) {
        RequestContextUtils.setRunningParam((String)"bool", (String)String.valueOf(bool));
    }

    public List<String> postRequest(String accNo, String transDateStr) throws Exception {
        boolean receiptProxyDownloadSwitch = Objects.equals("true", RequestContextUtils.getBankParameterValue((String)"receipt_proxy_download_switch"));
        ArrayList<String> tot = new ArrayList<String>(8);
        this.setStart(1);
        this.setBool(true);
        while (this.isBool()) {
            this.setBool(false);
            Element packet = new Element("packet");
            Element body = Packer.buildDY47Body(accNo, transDateStr, (this.getStart() - 1) * 10 + 1);
            Element head = Packer.buildHeadMessage("DY47");
            JDomUtils.addChild((Element)packet, (Element)head);
            String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)"GBK");
            Signature sign = Signature.getInstance();
            String signMsg = sign.sign(srcSign);
            Element bodySign = new Element("body");
            JDomUtils.addChild((Element)bodySign, (String)"signature", (String)signMsg);
            JDomUtils.addChild((Element)packet, (Element)bodySign);
            String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)"GBK");
            String encoding = "GBK";
            String length = "" + (StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6);
            StringBuilder buffer = new StringBuilder();
            buffer.append(StringLength.fixedLength((String)length, (String)" ", (int)6));
            buffer.append(msg);
            List<String> result = receiptProxyDownloadSwitch ? this.sendProxy(buffer.toString()) : this.sendFileByDownload(buffer.toString());
            this.setStart(this.getStart() + 1);
            tot.addAll(result);
        }
        return tot;
    }

    private List<String> sendProxy(String rqstStr) {
        DY47ProxyImpl dy47Proxy = new DY47ProxyImpl();
        BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().requestStr(rqstStr).build();
        BankReceiptResponseEB receiptResponseEB = dy47Proxy.doBiz(bankReceiptRequest);
        String responseStr = (String)receiptResponseEB.getData();
        return this.parseResponse(responseStr);
    }

    private List<String> sendFileByDownload(String rqstStr) {
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            String bankLogin = EBContext.getContext().getBankLoginID();
            SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLogin);
            factory.setIp(config.getBiSafeIP());
            factory.setPort(config.getPort().toString());
            factory.setUri("/fileTransfer/");
            return this.commumication(factory, rqstStr);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42DY47\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> commumication(ConnectionFactory factory, String requestStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<String> recv(InputStream in) throws IOException {
        ArrayList<String> retList = new ArrayList<String>(8);
        byte[] lengthdata = new byte[6];
        in.read(lengthdata);
        String lengthstr = new String(lengthdata).trim();
        int length = Integer.parseInt(lengthstr);
        byte[] rcv = new byte[length];
        int j = 0;
        byte[] rcvtmp = new byte[10240];
        int srcindex = 0;
        while (j >= 0 && (j = in.read(rcvtmp)) >= 0) {
            System.arraycopy(rcvtmp, 0, rcv, srcindex, j);
            if ((srcindex += j) != length - 6) continue;
        }
        String contentstr = new String(rcv, "GBK");
        logger.infoFilerLog(contentstr);
        String rspData = Signature.getInstance().validateSignedData(contentstr);
        retList.addAll(this.parseResponse(rspData));
        return retList;
    }

    public List<String> parseResponse(String responseStr) {
        ArrayList<String> retList = new ArrayList<String>(8);
        Element body = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        logger.infoFilerLog(responseStr);
        String totalNumber = body.getChildText("totalNumber");
        int totalNum = Integer.parseInt(totalNumber);
        List recieptNolists = body.getChild("lists").getChildren("list");
        if (recieptNolists == null || recieptNolists.isEmpty()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"DY47\u8bf7\u6c42\u8fd4\u56de\u56de\u5355\u53f7\u5217\u8868\u4e3a\u7a7a", (String)"DY47Impl_0", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]));
        }
        Element e = (Element)recieptNolists.get(0);
        String result = e.getChildText("result");
        String resultMsg = e.getChildText("resultMsg");
        if ("0".equalsIgnoreCase(result)) {
            if (recieptNolists.size() < 10 || this.getStart() * 10 % totalNum == 0) {
                this.setBool(false);
            } else {
                this.setBool(true);
            }
            for (int i = 0; i < recieptNolists.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                Element list = (Element)recieptNolists.get(i);
                String acceptNo = list.getChildText("acceptNo");
                String hostGyno = list.getChildText("backhostGyno");
                String transAmount = list.getChildText("transAmount");
                String debitFlag = list.getChildText("debitFlag");
                String subpoenaSeqNo = list.getChildText("subpoenaSeqNo");
                jsonObject.put("acceptNo", (Object)acceptNo);
                jsonObject.put("hostGyno", (Object)hostGyno);
                jsonObject.put("transAmount", (Object)transAmount);
                jsonObject.put("debitFlag", (Object)debitFlag);
                jsonObject.put("subpoenaSeqNo", (Object)subpoenaSeqNo);
                retList.add(jsonObject.toJSONString());
            }
        } else {
            logger.error("DY47\u8bf7\u6c42\u8fd4\u56de\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{resultMsg});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"DY47\u8bf7\u6c42\u8fd4\u56de\u5931\u8d25\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a%s", (String)"DY47Impl_3", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), resultMsg));
        }
        logger.info("DY47\u529f\u80fd\u7c7b\u6267\u884c\u5b8c\u6bd5\uff0c\u8fd4\u56de\u7684\u6570\u91cf\u4e3a=====>\uff1a" + retList.size());
        return retList;
    }

    public void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6253\u5f00\u8fde\u63a5\u5f02\u5e38\uff1a%s", (String)"DY47Impl_4", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public void send(OutputStream outputStream, String requestStr) {
        if (this.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else {
            IOUtils.sendFully((OutputStream)outputStream, (String)requestStr);
        }
    }
}

