/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.util.Base64;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.business.receipt.atom.AbstractProxyReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class DY47ProxyImpl
extends AbstractProxyReceiptImpl
implements IBankReceipt {
    public String getDeveloper() {
        return "LW";
    }

    public String getBizCode() {
        return "DY47";
    }

    public String getBizDesc() {
        return "DY47";
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        return bankReceiptRequest.getRequestStr();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String base64Str = jsonObject.getString("data");
        byte[] bytes = Base64.getDecoder().decode(base64Str);
        try {
            return BankReceiptResponseEB.success((Object)new String(bytes, "UTF-8"));
        }
        catch (Throwable e) {
            throw new ReceiptException(e.getMessage(), e);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("sign_ip", RequestContextUtils.getBankParameterValue((String)"biSignIp"));
        factory.setHttpHeader("sign_port", RequestContextUtils.getBankParameterValue((String)"biSignPort"));
        factory.setHttpHeader("transCode", this.getBizCode());
        factory.setUri("/fileTransfer/");
    }

    public boolean isSave() {
        return false;
    }
}

