/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.spdb.dc.service.receipt.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringLength;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.Packer;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.SPDBDCCommConfig;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.Signature;
import kd.ebg.receipt.banks.spdb.dc.service.receipt.api.WJ01ProxyImpl;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptDownLoadException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import org.jdom2.Element;

public class WJ01Impl {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(WJ01Impl.class);
    private static WJ01Impl wj01 = null;

    private WJ01Impl() {
    }

    public static synchronized WJ01Impl getInstance() {
        if (wj01 == null) {
            wj01 = new WJ01Impl();
        }
        return wj01;
    }

    public String postRequest(String accNo, String transDateStr, String bakFilePath) throws Exception {
        boolean receiptProxyDownloadSwitch = Objects.equals("true", RequestContextUtils.getBankParameterValue((String)"receipt_proxy_download_switch"));
        if (receiptProxyDownloadSwitch) {
            RequestContextUtils.setRunningParam((String)"savePath", (String)bakFilePath);
            String fileName = String.format("%s_%s.zip", accNo, transDateStr);
            RequestContextUtils.setRunningParam((String)"fileName", (String)fileName);
            WJ01ProxyImpl wj01Proxy = new WJ01ProxyImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().transDate(LocalDateUtil.parserDate((String)transDateStr)).accNo(accNo).receiptFileName(fileName).build();
            BankReceiptResponseEB receiptResponseEB = wj01Proxy.doBiz(bankReceiptRequest);
            if (receiptResponseEB.getCode() == BankReceiptResponseEB.ResultEnum.SUCCESS.getCode()) {
                return fileName;
            }
            return null;
        }
        Element packet = new Element("packet");
        Element buildWJ01Body = Packer.buildWJ01Body(accNo, transDateStr);
        Element buildHeadMessage = Packer.buildHeadMessage("WJ01");
        JDomUtils.addChild((Element)packet, (Element)buildHeadMessage);
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)buildWJ01Body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signMsg = sign.sign(srcSign);
        Element bodySign = new Element("body");
        JDomUtils.addChild((Element)bodySign, (String)"signature", (String)signMsg);
        JDomUtils.addChild((Element)packet, (Element)bodySign);
        String msg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)packet, (String)RequestContextUtils.getCharset());
        String encoding = RequestContextUtils.getCharset();
        String length = "" + (StringLength.getLength4DataWithEncoding((String)msg, (String)encoding) + 6);
        StringBuilder buffer = new StringBuilder();
        buffer.append(StringLength.fixedLength((String)length, (String)" ", (int)6));
        buffer.append(msg);
        String result = this.sendFileByDownload(buffer.toString(), bakFilePath);
        return result;
    }

    private String sendFileByDownload(String rqstStr, String bakFilePath) {
        try {
            EBContext.getContext().setRemoveWriteResponseLog(true);
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            String bankLogin = EBContext.getContext().getBankLoginID();
            SPDBDCCommConfig config = (SPDBDCCommConfig)EBConfigBuilder.getInstance().buildConfig(SPDBDCCommConfig.class, bankLogin);
            factory.setIp(config.getBiSafeIP());
            factory.setPort(config.getBiSafeFilePort().toString());
            factory.setUri("/fileTransfer/");
            String rspStr = this.commumication(factory, rqstStr, bakFilePath);
            EBContext.getContext().setRemoveWriteResponseLog(false);
            return rspStr;
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42JW01\u63a5\u53e3\u53d1\u751f\u5f02\u5e38", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String commumication(ConnectionFactory factory, String requestStr, String bakFilePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String recv(InputStream in, String bakFilePath) throws IOException {
        byte[] rcvtmp;
        byte[] lengthdata = new byte[6];
        in.read(lengthdata);
        String lengthstr = new String(lengthdata).trim();
        int length = Integer.parseInt(lengthstr);
        byte[] rcv = new byte[length];
        int j = 0;
        int srcindex = 0;
        while (j >= 0 && (j = in.read(rcvtmp = new byte[length - 6 - j])) >= 0) {
            System.arraycopy(rcvtmp, 0, rcv, srcindex, j);
            if ((srcindex += j) != length - 6) continue;
            break;
        }
        EBContext.getContext().setRemoveWriteResponseLog(true);
        String contentstr = new String(rcv, "GBK");
        logger.infoFilerLog(contentstr);
        String rspData = Signature.getInstance().validateSignedData(contentstr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        logger.infoFilerLog(rspData);
        String retfileLengthStr = body.getChildText("fileLength");
        String retfileName = body.getChildText("fileName");
        String fileStatus = body.getChildText("fileStatus");
        if (Objects.equals(fileStatus, "0") && StringUtils.isNotEmpty((String)retfileLengthStr) && StringUtils.isNotEmpty((String)retfileName)) {
            boolean flag;
            File bakFile;
            File tempFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + retfileName));
            if (tempFile.exists()) {
                boolean isDelete = tempFile.delete();
                logger.info("\u6587\u4ef6\u540d:{}-\u662f\u5426\u5220\u9664\uff1a{} ", new Object[]{tempFile.getName(), isDelete});
            }
            if (!(bakFile = FileCommonUtils.getFileByPath((String)bakFilePath)).exists()) {
                flag = bakFile.mkdirs();
                logger.info("SPDC-DC-WJ01Impl \u76ee\u5f55\u4e0d\u5b58\u5728 :{} \u521b\u5efa\u7ed3\u679c{} ", new Object[]{bakFilePath, flag});
            }
            flag = tempFile.createNewFile();
            logger.info("SPDC-DC-WJ01Impl \u521b\u5efa\u6587\u4ef6 :{} \u521b\u5efa\u7ed3\u679c{} ", new Object[]{retfileName, flag});
            int fileLength = Integer.parseInt(retfileLengthStr);
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
                byte[] readTemp = new byte[8096];
                int k = 0;
                for (int byteCounts = 0; (k >= 0 || byteCounts < fileLength) && (k = in.read(readTemp)) >= 0; byteCounts += k) {
                    fileOutputStream.write(readTemp, 0, k);
                }
                fileOutputStream.close();
                EBContext.getContext().setRemoveWriteResponseLog(false);
                String string = retfileName;
                return string;
            }
        }
        logger.error("\u56de\u5355\u6587\u4ef6\u672a\u751f\u6210\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a{}", new Object[]{rspData});
        throw new ReceiptDownLoadException(String.format(ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u672a\u751f\u6210\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff1a%s\u3002", (String)"WJ01Impl_2", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), rspData));
    }

    public void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6253\u5f00\u8fde\u63a5\u5f02\u5e38\uff1a%s\u3002", (String)"WJ01Impl_3", (String)"ebg-receipt-banks-spdb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public void send(OutputStream outputStream, String requestStr) {
        if (this.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else {
            IOUtils.sendFully((OutputStream)outputStream, (String)requestStr);
        }
    }
}

