/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.receipt.api.BankReceiptNameApiImpl;
import kd.ebg.receipt.banks.boc.net.service.receipt.util.SFTPUtils;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bankLoginId = request.getBankLoginId();
        String customId = EBContext.getContext().getCustomID();
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, bankLoginId);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (Objects.equals(bocnetCommConfig.getIsActivePush(), "true")) {
            result.addAll(this.doActivePush(bocnetCommConfig.getReceiptUserNo(), bankFtpProperties, accNo, transDate, bankLoginId));
        } else {
            logger.info("\u4e2d\u56fd\u94f6\u884c-\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868-\u79df\u6237\u53f7-{}-\u8c03\u5ea6\u8d26\u53f7:{} bankLoginId:{}", new Object[]{customId, accNo, bankLoginId});
            try {
                logger.info("\u8c03\u5ea6\u8d26\u53f7:{} \u8c03\u5ea6\u65e5\u671f\uff1a{}", new Object[]{accNo, LocalDateUtil.formatDate((LocalDate)transDate)});
                BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
                BankReceiptNameApiImpl iBankReceipt = new BankReceiptNameApiImpl();
                BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest);
                String fileName = (String)receiptResponseEB.getData();
                if (EBGStringUtils.isEmpty((String)fileName)) {
                    logger.info("\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u5230\u56de\u5355\u6587\u4ef6\u540d\u4e3a\u7a7a");
                    throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u7684\u56de\u5355\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
                }
                logger.info("\u83b7\u53d6\u5230\u56de\u5355\u6587\u4ef6\u540d:" + fileName);
                DownloadListDetail detail = new DownloadListDetail();
                detail.setQueryFlag("0");
                detail.setExpmsg("");
                detail.setCompleteTime(null);
                detail.setFileName(fileName);
                detail.setFileLink(fileName);
                result.add(detail);
                RequestContextUtils.setZipName((String)fileName);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u56de\u5355\u4e0b\u8f7d\u5217\u8868\u53d1\u751f\u5f02\u5e38.", new Object[]{e.getMessage()});
                throw new ReceiptException((Throwable)e);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadListDetail> doActivePush(String receiptUserNo, BankFtpProperties bankFtpProperties, String accNo, LocalDate transDate, String bankLoginId) {
        ArrayList<DownloadListDetail> resultList = new ArrayList<DownloadListDetail>(1);
        List<String> fileNames = new ArrayList(1);
        ChannelSftp sftp = null;
        String ftpPath = "";
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String matchString = transDateStr + "_";
        if (EBGStringUtils.isNotEmpty((String)receiptUserNo)) {
            matchString = transDateStr + "_" + receiptUserNo + "_" + accNo;
        }
        try {
            Vector vector;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && !(vector = (sftp = SFTPUtils.getInstance().getSftp(bankLoginId)).ls(ftpPath = EBGStringUtils.isEmpty((String)(ftpPath = bankFtpProperties.getFtpPath())) ? "/" : ftpPath)).isEmpty()) {
                for (int i = 0; i < vector.size(); ++i) {
                    ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                    String fileName = file.getFilename();
                    if (!fileName.endsWith(".zip")) continue;
                    fileNames.add(fileName);
                }
            }
            if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                fileNames = bankReceiptApiUtil.getFileByName(matchString, ".zip");
            }
            SFTPUtils.getInstance().close(sftp);
        }
        catch (Throwable e) {
            try {
                logger.error("\u4e2d\u884c\u4e3b\u52a8\u63a8\u9001\u6a21\u5f0f\u56de\u5355\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage(), e);
                SFTPUtils.getInstance().close(sftp);
            }
            catch (Throwable throwable) {
                SFTPUtils.getInstance().close(sftp);
                throw throwable;
            }
        }
        for (String fileName : fileNames) {
            if (!fileName.contains(matchString) || !fileName.contains(accNo) || !fileName.contains(transDateStr)) continue;
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileName(fileName);
            downloadListDetail.setFileLink(fileName);
            resultList.add(downloadListDetail);
        }
        if (resultList.isEmpty()) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u94f6\u884c\u672a\u63a8\u9001\u8be5\u8d26\u53f7\u5bf9\u5e94\u56de\u5355\u65e5\u671f\u7684\u56de\u5355\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u8865\u63a8\u3002", (String)"BankReceiptFetchListImpl_3", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return resultList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOC_NET_RECEIPT_FETCH";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u56fd\u94f6\u884c\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, EBContext.getContext().getBankLoginID());
        return !FileCommonUtils.isTestEnv() && !Objects.equals(bocnetCommConfig.getIsActivePush(), "true");
    }
}

