/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt.api;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.ReceiptPacker;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.ReceiptParser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class BankReceiptNameApiImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptNameApiImpl.class);

    public String pack(BankReceiptRequest request) {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        String requestStr = "";
        try {
            ReceiptPacker receiptPacker = new ReceiptPacker();
            requestStr = receiptPacker.getRequstStr(request.getAccNo(), request.getTransDate(), request.getTransDate(), bankLoginId);
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return requestStr;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u4e2d\u56fd\u94f6\u884c\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u540d-\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        ReceiptParser receiptParser = new ReceiptParser();
        String fileName = receiptParser.parseRsp(responseStr);
        return BankReceiptResponseEB.success((Object)fileName);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "BOC_NET_LOGIN";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u767b\u5f55\u8bf7\u6c42", (String)"BankReceiptNameApiImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/B2EC/E2BServlet");
    }
}

