/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt.message.login;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginPacker;
import kd.ebg.receipt.banks.boc.net.service.receipt.message.login.LoginParser;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class LoginImpl
extends AbstractImpl {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(LoginImpl.class);
    private LoginPacker loginPacker = new LoginPacker();
    private LoginParser loginParser = new LoginParser();
    private String token;
    private static final int timeout = 900;

    public String getToken() {
        String key = this.getCacheKey();
        String cache_token = CosmicCache.get((String)key);
        if (FileCommonUtils.isTestEnv()) {
            cache_token = "";
        }
        if (EBGStringUtils.isEmpty((String)cache_token)) {
            DLock lock = null;
            try {
                lock = DLock.create((String)CosmicCache.getParentKey((String)key), (String)ResManager.loadKDString((String)"\u4e2d\u884c\u524d\u7f6e\u673a\uff08\u7b7e\u5230\uff09\u5206\u5e03\u5f0f\u9501", (String)"LoginImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
                if (lock.tryLock()) {
                    cache_token = CosmicCache.get((String)key);
                    if (cache_token == null) {
                        this.login();
                        CosmicCache.putIfAbsentWithExpire((String)key, (String)this.token, (int)900, (TimeUnit)TimeUnit.SECONDS);
                        cache_token = this.token;
                    }
                } else {
                    long time;
                    for (time = 180000L; time >= 0L && (cache_token = CosmicCache.get((String)key)) == null; time -= 700L) {
                        Thread.sleep(700L);
                    }
                    if (time < 0L) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u884ctoken\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8bf7\u6c42\u3002", (String)"LoginImpl_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                log.error(String.format("\u83b7\u53d6\u4e2d\u884ctoken\u51fa\u73b0\u5f02\u5e38,%s", e.getMessage()));
                throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
            }
            finally {
                if (Objects.nonNull(lock)) {
                    lock.close();
                }
            }
        }
        return cache_token;
    }

    public void setTokenInvalid() {
        this.token = null;
    }

    private void login() {
        try {
            String rqstStr = this.loginPacker.packLogin();
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            factory.setUri("/B2EC/E2BServlet");
            IConnection conn = factory.createExchangeConnection();
            log.info("\u4e2d\u56fd\u94f6\u884c\u6267\u884c\u767b\u5f55[url:" + conn.getUrl() + "], \u8bf7\u6c42\u62a5\u6587\uff1a\n" + rqstStr);
            this.openConnection(conn);
            try (OutputStream outputStream = conn.getOutputStream();){
                this.send(outputStream, rqstStr);
                try (InputStream inputStream = conn.getInputStream();){
                    String rspStr = this.recv(inputStream);
                    this.token = this.loginParser.parseLogin(rspStr);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
    }

    private String getCacheKey() {
        EBContext ebContext = EBContext.getContext();
        String customID = ebContext.getCustomID();
        String bankLoginID = ebContext.getBankLoginID();
        return "eb_" + customID + "_" + bankLoginID + "_token";
    }

    public boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }
}

