/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.receipt.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.constant.RetryErrorEnum;
import kd.ebg.receipt.common.framework.receipt.exception.ConnectionException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;

public class SFTPUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SFTPUtils.class);
    private static SFTPUtils instance = null;
    private String bankLoginId;
    private static Map<String, ChannelSftp> activeSFTPMap = new ConcurrentHashMap<String, ChannelSftp>(8);

    public static synchronized SFTPUtils getInstance() {
        if (instance == null) {
            instance = new SFTPUtils();
        }
        return instance;
    }

    private SFTPUtils() {
    }

    public boolean isAbort(ChannelSftp sftp) {
        return !this.isWorking(sftp);
    }

    public boolean isWorking(ChannelSftp sftp) {
        return sftp != null && sftp.isConnected() && !sftp.isClosed();
    }

    public ChannelSftp getSftp(String loginId) {
        this.bankLoginId = loginId;
        String customId = EBContext.getContext().getCustomID();
        BankFtpProperties ftpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class);
        String ip = ftpProperties.getBankFtpIP();
        int port = ftpProperties.getBankFtpPort();
        String userName = ftpProperties.getUserName();
        String sftpName = customId + ip + port + userName;
        ChannelSftp sftp = activeSFTPMap.get(sftpName);
        if (this.isAbort(sftp)) {
            sftp = this.getSftp();
            activeSFTPMap.put(sftpName, sftp);
        }
        return sftp;
    }

    public ChannelSftp getSftp() {
        ChannelSftp sftp = null;
        try {
            BankFtpProperties ftpProperties = StringUtils.isEmpty((String)this.bankLoginId) ? (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class) : (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, this.bankLoginId);
            if (StringUtils.isEmpty((String)ftpProperties.getBankFtpIP())) {
                throw new ReceiptException(RetryErrorEnum.BANK_FTP_IP_IS_EMPTY.getMsg());
            }
            if (ftpProperties.getBankFtpPort() == 0) {
                throw new ReceiptException(RetryErrorEnum.BANK_FTP_PORT_IS_EMPTY.getMsg());
            }
            if (StringUtils.isEmpty((String)ftpProperties.getUserName())) {
                throw new ReceiptException(RetryErrorEnum.FTP_USER_NAME_IS_EMPTY.getMsg());
            }
            sftp = this.connect(ftpProperties.getBankFtpIP(), ftpProperties.getBankFtpPort(), ftpProperties.getUserName(), ftpProperties.getPassword(), ftpProperties.getCertPath());
            logger.info("\u4e2d\u884c-\u5efa\u7acbSFTP\u8fde\u63a5\u6210\u529f\u3002");
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38:", (String)"SFTPUtils_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
            msg = e.getMessage().toLowerCase(Locale.ENGLISH).contains("auth fail") ? ResManager.loadKDString((String)"\u5efa\u7acbSFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff1a\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684SFTP\u7684\u8d26\u53f7\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"SFTPUtils_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]) : (e.getMessage().toLowerCase(Locale.ENGLISH).contains("connection refused") ? ResManager.loadKDString((String)"\u5efa\u7acbSFTP\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff1a\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6eSFTP\u7684IP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e\u3002", (String)"SFTPUtils_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]) : msg + e.getMessage());
            logger.info("\u4e2d\u884csftp\u5f02\u5e38\uff1a{}", (Object)msg);
            throw new ConnectionException(msg, e.getCause());
        }
        return sftp;
    }

    public ChannelSftp connect(String host, int port, String username, String ftpPassword, String ftpCertPath) throws Exception {
        ChannelSftp sftp = null;
        try {
            JSch jsch = new JSch();
            logger.info("\u51c6\u5907\u5efa\u7acbFTP\u8fde\u63a5\u3002");
            if (!StringUtils.isEmpty((String)ftpCertPath)) {
                jsch.addIdentity(ftpCertPath);
            }
            Session session = jsch.getSession(username, host, port);
            session.setTimeout(60000);
            Properties config = new Properties();
            config.setProperty("StrictHostKeyChecking", "no");
            session.setConfig(config);
            if (!StringUtils.isEmpty((String)ftpPassword)) {
                session.setPassword(ftpPassword);
            }
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect(60000);
            sftp = (ChannelSftp)channel;
            logger.info("Connected to " + host + ".");
        }
        catch (Exception e) {
            logger.error("SFTP\u670d\u52a1\u5f02\u5e38:\u5efa\u7acbFTP\u8fde\u63a5\u51fa\u9519\u3002", (Throwable)e);
            throw e;
        }
        return sftp;
    }

    public void close(ChannelSftp sftp) {
        try {
            if (this.isWorking(sftp)) {
                this.clear(sftp.getSession());
                sftp.disconnect();
            }
        }
        catch (JSchException e) {
            logger.error("\u5173\u95edSFTP\u8fde\u63a5\u51fa\u9519", (Throwable)e);
        }
    }

    public boolean downloadSingleFile(String directory, String downloadFile, String saveFile, ChannelSftp sftp) {
        try {
            if (!StringUtils.isEmpty((String)directory)) {
                logger.info("\u5207\u6362\u5230ftp\u76ee\u5f55\uff1a" + directory);
                sftp.cd(directory);
            }
            sftp.get(downloadFile, saveFile);
            logger.info("\u4e0b\u8f7d\u6587\u4ef6" + downloadFile + "\u5230" + saveFile + "\u6210\u529f");
        }
        catch (SftpException e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6" + downloadFile + "\u5931\u8d25\uff1a", (Throwable)e);
            throw new ReceiptException(ResManager.loadKDString((String)"SFTP\u670d\u52a1\u5f02\u5e38:", (String)"SFTPUtils_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]), (Throwable)e);
        }
        return true;
    }

    private void clear(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }
}

