/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationDownloadHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReconciliationDownloadImpl
extends AbstractBankReconciliationDownloadHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationDownloadImpl.class);

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u3002", (String)"BankReconciliationDownloadImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public void init(BankReconciliationHandleRequest request) {
        request.setAccNo("balanceReconciliation");
        ReconciliationInfo reconciliationInfo = request.getTask();
        reconciliationInfo.setAccNo("balanceReconciliation");
        request.setTask(reconciliationInfo);
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        this.init(request);
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String accNo = "balanceReconciliation";
        String bankVersionId = request.getBankVersionId();
        String bakFilePath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        List downloadListDetails = request.getDetails();
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        ReconciliationInfo task = request.getTask();
        String bankLogin = EBContext.getContext().getBankLoginID();
        String bakPathParentPath = FileStorageUtil.getReconciliationFileBakPath((String)bankLogin) + File.separator + transDateStr;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            JSONObject jsonObject;
            ReconciliationDetail downloadListDetail = (ReconciliationDetail)downloadListDetails.get(i);
            String fileLink = downloadListDetail.getFileLink();
            try {
                jsonObject = JSONObject.parseObject((String)fileLink);
            }
            catch (Exception e) {
                throw new ReceiptException((Throwable)e);
            }
            String fileName = downloadListDetail.getFileName();
            String reconciliationNo = jsonObject.getString("reconciliationNo");
            String protocolNo = jsonObject.getString("protocolNo");
            String yearMonth = jsonObject.getString("yearMonth");
            this.download(fileName, transDate, accNo, bankLoginId, bankFtpProperties, bakPathParentPath);
            List<ReconciliationDetail> details = this.getListByGZFile(bakPathParentPath, fileName);
            for (ReconciliationDetail detail : details) {
                detail.setReconciliationNo(reconciliationNo);
                detail.setYearMonth(yearMonth);
                detail.setReconciliationProtocolNo(protocolNo);
                detail.setFileLink(fileLink);
                result.add(detail);
            }
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u4e3a\u7a7a\u3002", (String)"BankReconciliationDownloadImpl_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public void download(String zipName, LocalDate transDate, String accNo, String bankLoginId, BankFtpProperties bankFtpProperties, String bakPathParentPath) {
        ChannelSftp sftp = null;
        String localDate = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String sftp_path = bankFtpProperties.getFtpPath();
            String string = sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" : sftp_path;
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            boolean flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, zipName, bakPathParentPath, sftp);
            SFTPUtils.getInstance().close(sftp);
            logger.info("BOC_DC-\u538b\u7f29\u5305SFTP\u4e0b\u8f7d\u65b9\u5f0f\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, localDate, zipName, flag});
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            String ftpPath = bankFtpProperties.getFrontProxyPath();
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
            boolean flag = bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, zipName, bakPathParentPath);
            logger.info("BOC_DC-\u538b\u7f29\u5305\u4ee3\u7406\u7a0b\u5e8f\u4e0b\u8f7d-{}-{}-\u538b\u7f29\u5305\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, localDate, zipName, flag});
        }
        File file = FileCommonUtils.getFileByPath((String)(bakPathParentPath + File.separator + zipName));
        if (!file.exists()) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(ResManager.loadKDString((String)"\u538b\u7f29\u5305\uff1a", (String)"BankReconciliationDownloadImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0])).append(zipName).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"BankReconciliationDownloadImpl_3", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
            throw new ReceiptException(errorMsg.toString());
        }
    }

    public List<ReconciliationDetail> getListByGZFile(String bakPathParentPath, String zipName) {
        ArrayList<ReconciliationDetail> reconciliationDetails = new ArrayList<ReconciliationDetail>(16);
        String gzFilePath = bakPathParentPath + File.separator + zipName;
        String zipOutFilePath = bakPathParentPath + File.separator + zipName.replace(".gz", "").replace(".zip", "") + ".zip";
        boolean unGzResult = false;
        boolean isGZFile = false;
        try {
            unGzResult = GZFileUtils.unGzFile((String)gzFilePath, (String)zipOutFilePath);
            isGZFile = true;
        }
        catch (Exception e) {
            logger.error("GZ\u65b9\u5f0f\u89e3\u538b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}" + e.getMessage(), (Throwable)e);
        }
        if (!unGzResult) {
            zipOutFilePath = zipOutFilePath.replaceAll("\\.gz", "").replaceAll("\\.zip", "");
            unGzResult = GZFileUtils.unZipFiles((String)gzFilePath, (String)zipOutFilePath);
            isGZFile = false;
        }
        logger.info("\u4e2d\u56fd\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u89e3\u538bGZ\u6587\u4ef6-\u7ed3\u679c:{} ", (Object)unGzResult);
        if (unGzResult) {
            String unZipDir = zipOutFilePath.replaceAll("\\.gz", "").replaceAll("\\.zip", "");
            if (isGZFile) {
                unGzResult = GZFileUtils.unZipFiles((String)zipOutFilePath, (String)unZipDir);
            }
            logger.info("\u4e2d\u56fd\u94f6\u884c-\u6587\u4ef6\u4e0b\u8f7d\u4efb\u52a1-\u89e3\u538bZIP\u6587\u4ef6-GZFileUtils--\u7ed3\u679c:{} zipFilePath:{} unZipDir:{}", new Object[]{unGzResult, zipOutFilePath, unZipDir});
            if (unGzResult) {
                File[] reconciliationFiles;
                File accFile = FileCommonUtils.getFileByPath((String)unZipDir);
                for (File file : reconciliationFiles = accFile.listFiles()) {
                    String fileName = file.getName();
                    if (!file.isFile() || !file.getName().endsWith(".pdf")) continue;
                    ReconciliationDetail reconciliationDetail = new ReconciliationDetail();
                    reconciliationDetail.setFileName(fileName);
                    reconciliationDetail.setBankFilePath(file.getPath());
                    reconciliationDetails.add(reconciliationDetail);
                }
            }
        }
        return reconciliationDetails;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "BOC_DC_BankReconciliationDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e2d\u56fd\u94f6\u884c\u5bf9\u8d26\u5355\u6587\u4ef6\u4e0b\u8f7d\u3002", (String)"BankReconciliationDownloadImpl_4", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }
}

