/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.api.BankBalanceReconciliationFileNameQuery;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.api.BankBalanceReconciliationQuery;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankReconciliationFetchHandleImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankReconciliationHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.reconciliation.BankReconciliationResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.reconciliation.BankReconciliationHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;

public class BankReconciliationFetchListImpl
extends AbstractBankReconciliationFetchHandleImpl
implements IBankReconciliationHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReconciliationFetchListImpl.class);

    public void init(BankReconciliationHandleRequest request) {
        request.setAccNo("balanceReconciliation");
    }

    public boolean match(BankReconciliationHandleRequest request) {
        if (request == null) {
            return false;
        }
        if (!RequestContextUtils.isSupportReconciliation((String)EBContext.getContext().getBankLoginID())) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8be5\u94f6\u884c\u4e0d\u652f\u6301\u5bf9\u8d26\u5355", (String)"BankReconciliationFetchListImpl_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReconciliationHandleResponseEB doBiz(BankReconciliationHandleRequest request) {
        this.init(request);
        LocalDate transDate = request.getTransDate();
        String accNo = request.getAccNo();
        ArrayList<ReconciliationDetail> result = new ArrayList<ReconciliationDetail>(16);
        List<String> response = BankBalanceReconciliationQuery.queryBalanceReconciliationDetail(accNo, transDate);
        for (String jsonStr : response) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
            String reconciliationNo = jsonObject.getString("reconciliationNo");
            paramMap.put("reconciliationNo", reconciliationNo);
            BankBalanceReconciliationFileNameQuery bankBalanceReconciliationFileNameQuery = new BankBalanceReconciliationFileNameQuery();
            BankReconciliationRequest bankReconciliationRequest = BankReconciliationRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramMap).build();
            BankReconciliationResponseEB reconciliationResponseEB = bankBalanceReconciliationFileNameQuery.doBiz(bankReconciliationRequest);
            String fileName = (String)reconciliationResponseEB.getData();
            ReconciliationDetail detail = new ReconciliationDetail();
            detail.setFileLink(jsonStr);
            detail.setFileName(fileName);
            result.add(detail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReconciliationFetchListImpl_1", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]));
        }
        return BankReconciliationHandleResponseEB.success(result);
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "BOC_NET_BankReconciliationFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u56fd\u94f6\u884c\u4f59\u989d\u5bf9\u8d26\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReconciliationFetchListImpl_2", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }
}

