/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.boc.net.service.reconciliation.api;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.boc.net.service.receipt.BOCNETCommConfig;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.BalanceReconciliation;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.ReconciliationPacker;
import kd.ebg.receipt.banks.boc.net.service.reconciliation.utils.ReconciliationParse;
import kd.ebg.receipt.business.receipt.atom.reconciliation.AbstractBankBalanceReconciliationImpl;
import kd.ebg.receipt.business.receipt.atom.reconciliation.IBankBalanceReconciliation;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationRequestEB;
import kd.ebg.receipt.business.receipt.bank.task.balanceReconciliation.BalanceReconciliationResponseEB;
import kd.ebg.receipt.common.constant.balanceReconciliation.BalanceReconciliationStatusEnum;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class BankBalanceReconciliationFeedBack
extends AbstractBankBalanceReconciliationImpl
implements IBankBalanceReconciliation {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankBalanceReconciliationFeedBack.class);

    public String pack(BalanceReconciliationRequestEB request) {
        ArrayList<BalanceReconciliation> balanceReconciliations = new ArrayList<BalanceReconciliation>(1);
        String reconciliationNo = request.getReconciliationNo();
        String requestStr = "";
        String balanceStatus = request.getBalanceStatus();
        boolean isSame = false;
        if (Objects.equals(BalanceReconciliationStatusEnum.Y.getCode(), balanceStatus)) {
            isSame = true;
        }
        if (Objects.equals(BalanceReconciliationStatusEnum.N.getCode(), balanceStatus)) {
            isSame = false;
            BalanceReconciliation balanceReconciliation = new BalanceReconciliation();
            balanceReconciliation.setAccNo(request.getAccNo());
            balanceReconciliation.setAmount(request.getDifferenceBalance());
            balanceReconciliation.setBokbal(request.getBalance());
            balanceReconciliation.setOpreason(request.getAdjustCause());
            balanceReconciliations.add(balanceReconciliation);
        }
        ReconciliationPacker reconciliationPacker = new ReconciliationPacker();
        BOCNETCommConfig bocnetCommConfig = (BOCNETCommConfig)EBConfigBuilder.getInstance().buildConfig(BOCNETCommConfig.class, EBContext.getContext().getBankLoginID());
        requestStr = reconciliationPacker.packB2e0360(reconciliationNo, isSame, bocnetCommConfig, balanceReconciliations);
        logger.info("\u4e2d\u56fd\u94f6\u884c\u4f59\u989d\u5bf9\u8d26\u53cd\u9988-{}-\u8bf7\u6c42\u62a5\u6587\uff1a\n{}", new Object[]{this.getBizCode(), requestStr});
        return requestStr;
    }

    public BalanceReconciliationResponseEB parse(BalanceReconciliationRequestEB request, String responseStr) {
        logger.info("\u4e2d\u56fd\u94f6\u884c\u4f59\u989d\u5bf9\u8d26\u53cd\u9988-{}-\u54cd\u5e94\u62a5\u6587\uff1a\n{}", new Object[]{this.getBizCode(), responseStr});
        ReconciliationParse reconciliationParse = new ReconciliationParse();
        return reconciliationParse.parseB2e0360(request, responseStr);
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "b2e0360";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u53cd\u9988", (String)"BankBalanceReconciliationFeedBack_0", (String)"ebg-receipt-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/B2EC/E2BServlet");
    }
}

