/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bod.cmp.service.api;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.bod.cmp.service.utils.Packer;
import kd.ebg.receipt.banks.bod.cmp.service.utils.Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import org.jdom2.Element;

public class ReceiptRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    public String pack(BankReceiptRequest bankReceiptRequest) {
        String transDate = bankReceiptRequest.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        Element root = Packer.createHead("200218");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)bankReceiptRequest.getRequestStr());
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)transDate);
        JDomUtils.addChild((Element)body, (String)"acno", (String)bankReceiptRequest.getAccNo());
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public BankReceiptResponseEB parse(BankReceiptRequest bankReceiptRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u56de\u5355\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"ReceiptRequestImpl_0", (String)"ebg-receipt-banks-bod-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("body");
        if (null == body || null == body.getChildren() || body.getChildren().isEmpty()) {
            return BankReceiptResponseEB.success();
        }
        String reportFileFlag = body.getChildText("reportFileFlag");
        if (StringUtils.isEmpty((String)reportFileFlag)) {
            reportFileFlag = body.getChildText("ReportFileFlag");
        }
        if ("1".equals(reportFileFlag)) {
            String reportFileName = body.getChildText("reportFileName");
            if (StringUtils.isEmpty((String)reportFileName)) {
                reportFileName = body.getChildText("ReportFileName");
            }
            return BankReceiptResponseEB.success((Object)reportFileName);
        }
        return BankReceiptResponseEB.success();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setUri("/e2bproxy/service.action");
    }

    public String recv(InputStream inputStream) {
        return Parser.parseRecvMsg(super.recv(inputStream));
    }
}

