/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.constant.PropertiesOptions;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.receipt.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.receipt.common.framework.bank.meta.BankMetaDataInfo;
import kd.ebg.receipt.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.receipt.common.framework.properties.BankPropertyConfig;

public abstract class FBEMetaDataTemplate
extends BankMetaDataInfo
implements BankMetaDataCollector {
    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String dLockNum = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            int temp;
            if (!StringUtils.isEmpty((String)System.getProperty(dLockNum)) && (temp = Integer.parseInt(System.getProperty(dLockNum))) != concurrentCount) {
                concurrentCount = temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).isSupportReconciliation(this.isSupportReconciliation).isReconciliationOfAccNo(this.isReconciliationOfAccNo).isBreakRemoveTodayDetail(this.isBreakRemoveTodayDetail).build();
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(16);
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getFrontProxyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PROXY_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        if (this.showAchieveWay()) {
            configs = this.getBankLoginReceiptAchieveWayConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.RECEIPT_ACHIEVEWAY_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        configs = this.getBankLoginReceiptBaseConfig();
        boolean isContainTodayReceiptConfig = false;
        boolean isShowOFDSignConfig = false;
        boolean isContainsSupportBatchDownloadHistoryConfig = false;
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            if (Objects.equals(config.getKey().getBankConfigId(), "is_support_today_receipt")) {
                isContainTodayReceiptConfig = true;
            }
            if (Objects.equals(config.getKey().getBankConfigId(), "isCheckOFDSign")) {
                isShowOFDSignConfig = true;
            }
            if (!Objects.equals(config.getKey().getBankConfigId(), "is_support_batch_download")) continue;
            isContainsSupportBatchDownloadHistoryConfig = true;
        }
        if (this.isSupportProxyDownload) {
            BankLoginConfig isSupportProxyDownloadConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_proxy_download_switch", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u83b7\u53d6", "FBEMetaDataTemplate_29", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5efa\u8bae\u516c\u6709\u4e91\u5ba2\u6237\u4f7f\u7528\uff0c\u9700\u8981\u5728\u524d\u7f6e\u673a\u670d\u52a1\u5668\u4e0a\u90e8\u7f72\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u3002", "FBEMetaDataTemplate_30", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false);
            isSupportProxyDownloadConfig.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            bankLoginConfig.add(isSupportProxyDownloadConfig);
            BankLoginConfig receiptProxyFileConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_proxy_file_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3", "FBEMetaDataTemplate_31", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u4e2d\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3\uff0c\u9700\u8981\u9996\u5148\u5728\u524d\u7f6e\u673a\u4e0a\u5b89\u88c5\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u3002", "FBEMetaDataTemplate_32", "ebg-receipt-common"), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535);
            receiptProxyFileConfig.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            receiptProxyFileConfig.setShowByFieldAndVal(new ShowByFieldAndVal("receipt_proxy_download_switch", "true"));
            bankLoginConfig.add(receiptProxyFileConfig);
        }
        if (this.isSupportBatchDownloadHistory() && !isContainsSupportBatchDownloadHistoryConfig) {
            BankLoginConfig config = BankLoginConfigUtil.getMlBankLoginConfig((String)"is_support_batch_download", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u6279\u91cf\u4e0b\u8f7d\u5386\u53f2\u56de\u5355", "FBEMetaDataTemplate_33", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("1.\u662f\u5426\u652f\u6301\u6279\u91cf\u4e0b\u8f7d\u5386\u53f2\u56de\u5355\uff0c\u9ed8\u8ba4\u4e0d\u652f\u6301\u3002", "FBEMetaDataTemplate_34", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false);
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            configs.add(config);
        }
        if (this.isSupportTodayReceipt() && !isContainTodayReceiptConfig) {
            BankLoginConfig todayReceiptConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"is_support_today_receipt", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u652f\u6301\u5f53\u65e5\u56de\u5355", "FBEMetaDataTemplate_0", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("1.\u5982\u679c\u652f\u6301\uff0c\u5219\u4f1a\u81ea\u52a8\u521b\u5efa\u5f53\u65e5\u56de\u5355", "FBEMetaDataTemplate_1", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false);
            todayReceiptConfig.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            configs.add(todayReceiptConfig);
        }
        if (this.isShowOFDSignConfig() && !isShowOFDSignConfig) {
            BankLoginConfig ofdConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"isCheckOFDSign", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u5bf9OFD\u56de\u5355\u53ca\u5bf9\u8d26\u5355\u6587\u4ef6\u9a8c\u7b7e", "FBEMetaDataTemplate_26", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u9ed8\u8ba4\u9700\u8981\u9a8c\u7b7e\uff0c\u9009\u62e9\u5426\u65f6\u5173\u95ed\u9a8c\u7b7e\u529f\u80fd\u3002", "FBEMetaDataTemplate_27", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"true", (boolean)false, (boolean)false, (boolean)false);
            ofdConfig.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
            configs.add(ofdConfig);
        }
        bankLoginConfig.addAll(configs);
        if (this.isSupportReconciliation) {
            configs = this.getReconciliationConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.RECONCILIATION_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        return bankLoginConfig;
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673aIP\u5730\u5740", "FBEMetaDataTemplate_2", "ebg-receipt-common"), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7aef\u53e3\u53f7", "FBEMetaDataTemplate_3", "ebg-receipt-common"), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "FBEMetaDataTemplate_4", "ebg-receipt-common"), (String)this.protocol).set2ReadOnly(), BankLoginConfigUtil.getMlBankLoginConfig((String)"timeout", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d85\u65f6\u8bbe\u7f6e(min)", "FBEMetaDataTemplate_5", "ebg-receipt-common"), (String)String.valueOf(this.timeout)).set2Integer(), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "FBEMetaDataTemplate_6", "ebg-receipt-common"), (String)this.charset).set2ReadOnly()});
    }

    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getReconciliationConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"isSupportReconciliation", (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u5bf9\u8d26\u5355\u3002", "FBEMetaDataTemplate_7", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u5bf9\u8d26\u5355\uff0c\u9ed8\u8ba4\u4e3a\u5426\u3002", "FBEMetaDataTemplate_8", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.YES_NAME, PropertiesOptions.NO_NAME}), (List)Lists.newArrayList((Object[])new String[]{"true", "false"}), (String)"false", (boolean)false, (boolean)false, (boolean)false)});
    }

    public List<BankLoginConfig> getBankLoginReceiptAchieveWayConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_achieve_way", (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u83b7\u53d6\u65b9\u5f0f", "FBEMetaDataTemplate_11", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("1.\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\uff0c\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u987b\u90e8\u7f72\u5728\u94f6\u884c\u63a8\u9001\u6587\u4ef6\u6240\u5728\u7684\u670d\u52a1\u5668\u4e0a\uff1b2.\u5982\u679c\u94f6\u884c\u63d0\u4f9b\u516c\u7f51sftp\u670d\u52a1\uff0c\u53ef\u4ee5\u901a\u8fc7\u8fdc\u7a0bsftp\u83b7\u53d6", "FBEMetaDataTemplate_12", "ebg-receipt-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{PropertiesOptions.FRONT_PROXY_NAME, PropertiesOptions.REMOTE_SFTP_ACHIEVE_NAME}), (List)Lists.newArrayList((Object[])new String[]{"bank_login", "sftp"}), (String)"bank_login", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"bank_ftp_ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u670d\u52a1\u5668IP\u5730\u5740", "FBEMetaDataTemplate_13", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u670d\u52a1\u5668IP\u5730\u5740\u3002\u5982\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u5728\u56de\u5355\u7a0b\u5e8f\u670d\u52a1\u5668\u4e0a\u5b89\u88c5winscp\uff0c\u518d\u6d4b\u8bd5\u8fde\u63a5\u3002", "FBEMetaDataTemplate_14", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"bank_ftp_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u7aef\u53e3", "FBEMetaDataTemplate_15", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_path", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u6587\u4ef6\u4fdd\u5b58\u5b50\u8def\u5f84", "FBEMetaDataTemplate_16", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e00\u822c\u94f6\u884c\u4f7f\u7528SFTP\u4f20\u8f93\u6587\u4ef6\u65f6\u9ed8\u8ba4\u4e3a\u7a7a\u5373\u53ef\uff0c\u5982\u679c\u586b\u5165\u5219\u4f7f\u7528\u5206\u9694\u7b26\uff0c\u4f8b\u5982\uff1a/download\u3002", "FBEMetaDataTemplate_17", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_user_name", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u7528\u6237\u540d", "FBEMetaDataTemplate_18", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_password", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u5bc6\u7801", "FBEMetaDataTemplate_19", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_cert_path", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u672c\u673a\u8bc1\u4e66\u6587\u4ef6", "FBEMetaDataTemplate_20", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true, (String)"upload"), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8fIP", "FBEMetaDataTemplate_21", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8fIP", "FBEMetaDataTemplate_21", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3", "FBEMetaDataTemplate_22", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u4e2d\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u670d\u52a1\u7aef\u53e3\uff0c\u9700\u8981\u9996\u5148\u5728\u524d\u7f6e\u673a\u4e0a\u5b89\u88c5\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u3002", "FBEMetaDataTemplate_23", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_path", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84", "FBEMetaDataTemplate_24", "ebg-receipt-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u56de\u5355\u6587\u4ef6\u63a8\u9001\u76ee\u5f55\u3002", "FBEMetaDataTemplate_25", "ebg-receipt-common"), (String)"", (boolean)false, (boolean)true)});
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return false;
    }

    public boolean isSupportBatchDownloadHistory() {
        return false;
    }
}

