/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.communication;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptProxyConnectionFactory
extends ConnectionFactory {
    private static Logger logger = LoggerFactory.getLogger(ReceiptProxyConnectionFactory.class);
    private Map<String, String> protocolKey = Maps.newHashMapWithExpectedSize((int)1);
    private Map<String, String> httpHeaders = Maps.newHashMapWithExpectedSize((int)1);
    private boolean isLogging = true;
    public static final String RECEIPT_PROXY_FILE_PORT = "receipt_proxy_file_port";
    public static final String RECEIPT_PROXY_DOWNLOAD_SWITCH = "receipt_proxy_download_switch";

    public static ReceiptProxyConnectionFactory getInstance() {
        return new ReceiptProxyConnectionFactory();
    }

    public static ReceiptProxyConnectionFactory getInstanceAutoInit() {
        return new ReceiptProxyConnectionFactory().autoInit();
    }

    public ConnectionFactory addHeader(String key, String value) {
        this.httpHeaders.put(key, value);
        return this;
    }

    public ConnectionFactory addHeaders(Map<String, String> headers) {
        this.httpHeaders.putAll(headers);
        return this;
    }

    public ConnectionFactory setHttpHeader(String key, String value) {
        this.httpHeaders.put(key, value);
        return this;
    }

    public ConnectionFactory setUri(String uri) {
        this.protocolKey.put("uri", uri);
        return this;
    }

    public ConnectionFactory setIp(String ip) {
        this.protocolKey.put("front_proxy_ip", ip);
        return this;
    }

    public ConnectionFactory setPort(String port) {
        this.protocolKey.put("front_proxy_port", port);
        return this;
    }

    public ConnectionFactory setProtocol(String protocol) {
        this.protocolKey.put("front_proxy_protocol", protocol);
        return this;
    }

    private ReceiptProxyConnectionFactory autoInit() {
        IParameter parameter = EBContext.getContext().getParameter();
        String ip = parameter.getBankParameter("ip");
        String timeOut = parameter.getBankParameter("timeout");
        this.protocolKey.put("ip", ip);
        this.protocolKey.put("timeout", timeOut);
        this.httpHeaders.put("Connection", "close");
        return this;
    }

    public void createReceiptProxyConnection(String protocol, String ip, String port, String timeOut) {
        this.protocolKey.put("protocol", protocol);
        this.protocolKey.put("ip", ip);
        this.protocolKey.put("port", port);
        this.protocolKey.put("timeout", timeOut);
    }

    public IConnection createExchangeConnection() {
        this.packProtocolKey();
        return this.createConnection();
    }

    public void packProtocolKey() {
        IParameter parameter = EBContext.getContext().getParameter();
        if (!this.protocolKey.containsKey("protocol")) {
            if (StringUtils.isEmpty((String)parameter.getBankParameter("exchangeProtocol"))) {
                this.protocolKey.put("protocol", "http");
            } else {
                this.protocolKey.put("protocol", parameter.getBankParameter("exchangeProtocol"));
            }
        }
        if (!this.protocolKey.containsKey("port")) {
            if (StringUtils.isEmpty((String)parameter.getBankParameter("exchangePort"))) {
                this.protocolKey.put("port", "0");
            } else {
                this.protocolKey.put("port", parameter.getBankParameter("exchangePort"));
            }
        }
        if (!this.protocolKey.containsKey("uri")) {
            this.protocolKey.put("uri", parameter.getBankParameter("exchangeUri"));
        } else if (!StringUtils.isEmpty((String)parameter.getBankParameter("exchangeUri"))) {
            this.protocolKey.put("uri", parameter.getBankParameter("exchangeUri"));
        }
    }

    private IConnection createConnection() {
        IConnection connection = null;
        String protocol = this.protocolKey.get("protocol");
        String ip = this.protocolKey.get("ip");
        String s = this.protocolKey.get("port");
        int port = Integer.parseInt(s);
        int timeout = 3;
        if (!StringUtils.isEmpty((String)this.protocolKey.get("timeout"))) {
            timeout = Integer.parseInt(this.protocolKey.get("timeout"));
        }
        connection = this.createDirectConnection(protocol, ip, port, timeout);
        String charset = IOUtils.getCharsetName();
        if (this.isSSLProxyConnection()) {
            return new SSLConnection(connection, protocol, ip, port, timeout, this.protocolKey, this.httpHeaders, charset, EBContext.getContext());
        }
        if (this.isLogging) {
            return new LoggerConnection(connection);
        }
        return connection;
    }

    private boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    private IConnection createDirectConnection(String protocol, String ip, int port, int timeout) {
        TcpConnection connection = null;
        if ("HTTP".equalsIgnoreCase(protocol)) {
            String uri = this.protocolKey.get("uri");
            String method = this.httpHeaders.get("Request Method");
            if (StrUtil.isBlank((CharSequence)method)) {
                method = "POST";
            } else {
                this.httpHeaders.remove("Request Method");
            }
            connection = new HttpConnection(ip, port, uri, this.httpHeaders, timeout, method);
        } else if ("TCP".equalsIgnoreCase(protocol)) {
            connection = new TcpConnection(ip, port, timeout);
        } else if ("HTTPS".equalsIgnoreCase(protocol)) {
            String uri = this.protocolKey.get("uri");
            connection = new HttpsConnection(ip, port, uri, this.httpHeaders, timeout);
        } else {
            throw EBExceiptionUtil.connectionException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b %s", (String)"ReceiptProxyConnectionFactory_0", (String)"ebg-egf-common", (Object[])new Object[0]), protocol));
        }
        return connection;
    }

    public Map<String, String> getProtocolKey() {
        return this.protocolKey;
    }

    public void setProtocolKey(Map<String, String> protocolKey) {
        this.protocolKey = protocolKey;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }
}

