/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.properties;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.receipt.common.framework.properties.PropertyConfig;
import kd.ebg.receipt.common.framework.properties.PropertyConfigItem;
import kd.ebg.receipt.common.framework.properties.PropertyName;

public abstract class BankPropertyConfig
implements PropertyConfig {
    public static final String EnterpriseCode = "EnterpriseCode";
    public static final String bankAccType = "bank_accType";
    public static final String bankIsReceipt = "bank_isReceipt";
    public static final String bankAreaCode = "bank_area_code";
    public static final String bankCnap = "bank_cnap";
    public static final String bankSwiftCode = "bank_swift_code";
    public static final String detailSearchDate = "detail_search_date";
    public static final String accnoSearchLimit = "accno_search_limit";
    public static final String CLOUD_TYPE_S = "SAAS";
    public static final String CLOUD_TYPE_N = "NORMAL";
    public static final String CLOUD_TYPE = "CLOUD_TYPE";
    public static final String CLOUD_TYPE_KEY_S = BankPropertyConfig.getCLOUD_TYPE_KEY_S();
    public static final String CLOUD_TYPE_KEY_N = BankPropertyConfig.getCLOUD_TYPE_KEY_N();
    private static final PropertyConfigItem BANK_ACC_TYPE = PropertyConfigItem.builder().key("bank_accType").mlName(new MultiLangEnumBridge("\u8d26\u6237\u7c7b\u522b", "BankPropertyConfig_4", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u94f6\u884c\u8d26\u6237\u7c7b\u522b", "BankPropertyConfig_5", "ebg-receipt-common")).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u666e\u901a\u7c7b", "BankPropertyConfig_6", "ebg-receipt-common"), new MultiLangEnumBridge("\u8d22\u8d44\u7c7b", "BankPropertyConfig_7", "ebg-receipt-common"), new MultiLangEnumBridge("\u865a\u62df\u73b0\u91d1\u6c60", "BankPropertyConfig_8", "ebg-receipt-common"), new MultiLangEnumBridge("\u5b9a\u671f\u6237", "BankPropertyConfig_9", "ebg-receipt-common"), new MultiLangEnumBridge("\u5b9e\u4f53\u73b0\u91d1\u6c60", "BankPropertyConfig_10", "ebg-receipt-common"), new MultiLangEnumBridge("\u901a\u77e5\u5b58\u6b3e\u6237", "BankPropertyConfig_11", "ebg-receipt-common"), new MultiLangEnumBridge("\u865a\u62df\u6237", "BankPropertyConfig_12", "ebg-receipt-common"), new MultiLangEnumBridge("\u591a\u7ea7\u73b0\u91d1\u6c60\u8d26\u6237", "BankPropertyConfig_13", "ebg-receipt-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"normal", "caizi", "vcp", "fixed", "cashpool", "notice", "vitual", "mutilevel"})).defaultValues(Lists.newArrayList((Object[])new String[]{"normal"})).isAccNo(true).mustInput(true).build();
    private static final PropertyConfigItem BANK_IS_RECEIPT = PropertyConfigItem.builder().key("bank_isReceipt").mlName(new MultiLangEnumBridge("\u7535\u5b50\u56de\u5355\u8d26\u53f7", "BankPropertyConfig_14", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u662f\u5426\u8bbe\u7f6e\u4e3a\u7535\u5b50\u56de\u5355\u8d26\u53f7\u3002", "BankPropertyConfig_15", "ebg-receipt-common")).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankPropertyConfig_16", "ebg-receipt-common"), new MultiLangEnumBridge("\u5426", "BankPropertyConfig_17", "ebg-receipt-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues(Lists.newArrayList((Object[])new String[]{"false"})).isAccNo(true).mustInput(true).build();
    private static final PropertyConfigItem BANK_AREA_CODE = PropertyConfigItem.builder().key("bank_area_code").mlName(new MultiLangEnumBridge("\u5730\u533a\u7801", "BankPropertyConfig_18", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u8bbe\u7f6e\u5730\u533a\u7801", "BankPropertyConfig_19", "ebg-receipt-common")).isAccNo(true).build();
    private static final PropertyConfigItem BANK_CNAP = PropertyConfigItem.builder().key("bank_cnap").mlName(new MultiLangEnumBridge("\u8054\u884c\u53f7", "BankPropertyConfig_20", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u8bbe\u7f6e\u8054\u884c\u53f7", "BankPropertyConfig_21", "ebg-receipt-common")).isAccNo(true).build();
    private static final PropertyConfigItem BANK_SWIFT_CODE = PropertyConfigItem.builder().key("bank_swift_code").mlName(new MultiLangEnumBridge("swift\u7801", "BankPropertyConfig_22", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u8bbe\u7f6eswift\u7801\u3002", "BankPropertyConfig_23", "ebg-receipt-common")).isAccNo(true).build();
    public static final PropertyConfigItem DETAIL_SEARCH_DATE = PropertyConfigItem.builder().key("detail_search_date").mlName(new MultiLangEnumBridge("\u4ea4\u6613\u660e\u7ec6\u9650\u5236\u67e5\u8be2\u65e5\u671f", "BankPropertyConfig_24", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("\u65e7\u94f6\u4f01\u4e91\u5207\u6362\u82cd\u7a79\u94f6\u4f01\u4e91\u65f6\u8bbe\u7f6e\uff0c\u907f\u514d\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u91cd\u590d\u3002\u4e3a\u7a7a\u65f6\u4e0d\u9650\u5236\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff0c\u5f53\u6709\u503c\u65f6\uff0c\u9650\u5236\u5f53\u524d\u8bbe\u7f6e\u65e5\u671f\u4e4b\u524d\u7684\u4ea4\u6613\u660e\u7ec6\u4e0d\u518d\u67e5\u8be2\u3002", "BankPropertyConfig_25", "ebg-receipt-common")).isAccNo(false).inputType(ConfigInputType.DATE.getInputType()).build();
    public static final PropertyConfigItem ACCNO_SEARCH_LIMIT = PropertyConfigItem.builder().key("accno_search_limit").mlName(new MultiLangEnumBridge("\u5168\u65b0\u82cd\u7a79\u94f6\u4f01\u4e91\u8d26\u6237", "BankPropertyConfig_26", "ebg-receipt-common")).mlName(new MultiLangEnumBridge("1)\u65e7\u94f6\u4f01\u4e91\u5207\u6362\u82cd\u7a79\u94f6\u4f01\u4e91\u65f6\uff0c\u5bf9\u4e8e\u539f\u672c\u4e0d\u5728\u65e7\u7248\u94f6\u4f01\u4e91\uff0c\u4f46\u662f\u9700\u8981\u5728\u82cd\u7a79\u7248\u94f6\u4f01\u4e91\u65b0\u589e\u7684\u8d26\u6237\uff0c\u4e0d\u9650\u5236\u6b64\u8d26\u6237\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u53ca\u56de\u5355\u67e5\u8be2\u3002", "BankPropertyConfig_27", "ebg-receipt-common")).mlSourceNames(Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u662f", "BankPropertyConfig_16", "ebg-receipt-common"), new MultiLangEnumBridge("\u5426", "BankPropertyConfig_17", "ebg-receipt-common")})).sourceValues(Lists.newArrayList((Object[])new String[]{"true", "false"})).defaultValues(Lists.newArrayList((Object[])new String[]{"false"})).readonly(true).isAccNo(true).build();

    private static String getCLOUD_TYPE_KEY_S() {
        return ResManager.loadKDString((String)"saas\u6a21\u5f0f\u4e91\u76f4\u8054\u3002", (String)"BankPropertyConfig_0", (String)"ebg-receipt-common", (Object[])new Object[0]);
    }

    private static String getCLOUD_TYPE_KEY_N() {
        return ResManager.loadKDString((String)"\u6807\u51c6\u6a21\u5f0f\u4e91\u76f4\u8054\u3002", (String)"BankPropertyConfig_1", (String)"ebg-receipt-common", (Object[])new Object[0]);
    }

    public abstract String getBankVersionID();

    @Override
    public final PropertyName getPropertyName() {
        return PropertyName.BANK_BUSINESS;
    }

    @Override
    public final String getPropertyConfigID() {
        return this.getBankVersionID();
    }

    @Override
    public String getConfigName() {
        return String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\uff0c\u94f6\u884c\u7248\u672c\u53f7:%s\u3002", (String)"BankPropertyConfig_32", (String)"ebg-receipt-common", (Object[])new Object[0]), this.getBankVersionID());
    }

    @Override
    public String getConfigDesc() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5c42\u9762\u4e1a\u52a1\u914d\u7f6e\u3002", (String)"BankPropertyConfig_3", (String)"ebg-receipt-common", (Object[])new Object[0]);
    }

    public List<PropertyConfigItem> getBankAddtionalPropertyConfigItems() {
        return Lists.newArrayList((Object[])new PropertyConfigItem[]{BANK_ACC_TYPE, BANK_IS_RECEIPT, BANK_AREA_CODE, BANK_CNAP, BANK_SWIFT_CODE, DETAIL_SEARCH_DATE, ACCNO_SEARCH_LIMIT});
    }

    public static String getAccnoSearchLimit(String accNo) {
        return ACCNO_SEARCH_LIMIT.getCurrentValueWithObjectID(accNo);
    }
}

