/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.bank;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.framework.receipt.constant.ConfigDataType;
import kd.ebg.receipt.common.framework.receipt.constant.ConfigType;
import kd.ebg.receipt.common.framework.receipt.mark.EBConfigMark;
import kd.ebg.receipt.common.framework.receipt.mark.EBConfigMarkType;
import kd.ebg.receipt.common.utils.PrivateCertUtils;

@EBConfigMarkType(configType=ConfigType.BANKFTP, bankVersionID="bankloginftp")
public class BankFtpProperties {
    @EBConfigMark(name="receipt_achieve_way", dataType=ConfigDataType.OPTON, optionValues={"bank_login", "sftp"}, defaultValue="bank_login", required=true)
    private String receiptAchieveWay;
    @EBConfigMark(name="front_proxy_ip", defaultValue="")
    private String frontProxyIP;
    @EBConfigMark(name="front_proxy_port", defaultValue="")
    private Integer frontProxyPort;
    @EBConfigMark(name="front_proxy_protocol", defaultValue="http")
    private String frontProxyProtocol;
    @EBConfigMark(name="bank_ftp_ip")
    private String bankFtpIP;
    @EBConfigMark(name="bank_ftp_port")
    private Integer bankFtpPort;
    @EBConfigMark(name="ftp_path")
    private String ftpPath;
    @EBConfigMark(name="ftp_user_name")
    private String userName;
    @EBConfigMark(name="ftp_password", dataType=ConfigDataType.PASSWORD)
    private String password;
    @EBConfigMark(name="ftp_cert_path")
    private String certPath;
    @EBConfigMark(name="front_proxy_path", defaultValue="")
    private String frontProxyPath;
    @EBConfigMark(defaultValue="false", name="is_support_today_receipt")
    private String isSupportTodayReceipt;
    @EBConfigMark(defaultValue="false", name="is_support_batch_push_receipt")
    private String isSupportBatchPushReceipt;

    public String getReceiptAchieveWay() {
        return this.receiptAchieveWay;
    }

    public void setReceiptAchieveWay(String receiptAchieveWay) {
        this.receiptAchieveWay = receiptAchieveWay;
    }

    public String getBankFtpIP() {
        return this.bankFtpIP;
    }

    public void setBankFtpIP(String bankFtpIP) {
        this.bankFtpIP = bankFtpIP;
    }

    public Integer getBankFtpPort() {
        return this.bankFtpPort;
    }

    public void setBankFtpPort(Integer bankFtpPort) {
        this.bankFtpPort = bankFtpPort;
    }

    public String getFtpPath() {
        return this.ftpPath;
    }

    public void setFtpPath(String ftpPath) {
        this.ftpPath = ftpPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCertPath() {
        if (StringUtils.isNotEmpty((String)this.certPath)) {
            String bankLoginId = EBContext.getContext().getBankLoginID();
            String privateFilePath = this.certPath;
            String fileName = bankLoginId + "_private.ppk";
            return PrivateCertUtils.getPrivatePath("ftp_cert_path", bankLoginId, privateFilePath, fileName);
        }
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getFrontProxyPath() {
        return this.frontProxyPath;
    }

    public void setFrontProxyPath(String frontProxyPath) {
        this.frontProxyPath = frontProxyPath;
    }

    public String getFrontProxyIP() {
        return this.frontProxyIP;
    }

    public void setFrontProxyIP(String frontProxyIP) {
        this.frontProxyIP = frontProxyIP;
    }

    public Integer getFrontProxyPort() {
        return this.frontProxyPort;
    }

    public void setFrontProxyPort(Integer frontProxyPort) {
        this.frontProxyPort = frontProxyPort;
    }

    public String isSupportTodayReceipt() {
        return this.isSupportTodayReceipt;
    }

    public void setSupportTodayReceipt(String supportTodayReceipt) {
        this.isSupportTodayReceipt = supportTodayReceipt;
    }

    public String isSupportBatchPushReceipt() {
        return this.isSupportBatchPushReceipt;
    }

    public void setSupportBatchPushReceipt(String supportBatchPushReceipt) {
        this.isSupportBatchPushReceipt = supportBatchPushReceipt;
    }

    public String getFrontProxyProtocol() {
        return this.frontProxyProtocol;
    }

    public void setFrontProxyProtocol(String frontProxyProtocol) {
        this.frontProxyProtocol = frontProxyProtocol;
    }

    public String getIsSupportTodayReceipt() {
        return this.isSupportTodayReceipt;
    }

    public void setIsSupportTodayReceipt(String isSupportTodayReceipt) {
        this.isSupportTodayReceipt = isSupportTodayReceipt;
    }

    public String getIsSupportBatchPushReceipt() {
        return this.isSupportBatchPushReceipt;
    }

    public void setIsSupportBatchPushReceipt(String isSupportBatchPushReceipt) {
        this.isSupportBatchPushReceipt = isSupportBatchPushReceipt;
    }
}

