/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.convert;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.Map;
import kd.ebg.receipt.common.framework.receipt.convert.BooleanConvert;
import kd.ebg.receipt.common.framework.receipt.convert.DateConvert;
import kd.ebg.receipt.common.framework.receipt.convert.IConvert;
import kd.ebg.receipt.common.framework.receipt.convert.IntegerConvert;
import kd.ebg.receipt.common.framework.receipt.convert.LongConvert;
import kd.ebg.receipt.common.framework.receipt.convert.StringArrayConvert;
import kd.ebg.receipt.common.framework.receipt.convert.StringConvert;

public class ConvertCatalog {
    private static Map<Class<?>, IConvert<?>> storeConvertMap = Maps.newHashMapWithExpectedSize((int)8);

    public static IConvert<?> getConvert(Class<?> cl) {
        return storeConvertMap.get(cl);
    }

    static {
        storeConvertMap.put(String.class, new StringConvert());
        storeConvertMap.put(Integer.class, new IntegerConvert());
        storeConvertMap.put(LocalDate.class, new DateConvert());
        storeConvertMap.put(Integer.TYPE, new IntegerConvert());
        storeConvertMap.put(Long.class, new LongConvert());
        storeConvertMap.put(Long.TYPE, new LongConvert());
        storeConvertMap.put(String[].class, new StringArrayConvert());
        storeConvertMap.put(Boolean.TYPE, new BooleanConvert());
        storeConvertMap.put(Boolean.class, new BooleanConvert());
    }
}

