/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.util;

import java.io.File;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class FileStorageUtil {
    public static String getFileBakPath(String bankVersionID) {
        return FileStorageUtil.getPath(FileStorageUtil.getStorageRootPath(), "bakPath", bankVersionID);
    }

    public static String getReconciliationFileBakPath(String bankVersionID) {
        return FileStorageUtil.getPath(FileStorageUtil.getStorageRootPath(), "reconciliationBakPath", bankVersionID);
    }

    public static String getReconciliationFileBakPathByAccNoAndDate(String bankVersionId, String accNo, String transDateStr) {
        String bakPath = FileStorageUtil.getReconciliationFileBakPath(bankVersionId) + File.separator + transDateStr + File.separator + accNo;
        File bakFile = FileCommonUtils.getFileByPath(bakPath);
        if (!bakFile.exists()) {
            bakFile.mkdirs();
        }
        return bakPath;
    }

    public static String getFileBakPathByAccNoAndDate(String bankVersionId, String accNo, String transDateStr) {
        String bakPath = FileStorageUtil.getFileBakPath(bankVersionId) + File.separator + transDateStr + File.separator + accNo;
        File bakFile = FileCommonUtils.getFileByPath(bakPath);
        if (!bakFile.exists()) {
            bakFile.mkdirs();
        }
        return FileStorageUtil.getFileBakPath(bankVersionId) + File.separator + transDateStr + File.separator + accNo;
    }

    public static String getFileBatchBakPathByTransDate(String bankVersionId, String transDateStr) {
        EBContext context = EBContext.getContext();
        String bankLoginID = context.getBankLoginID();
        String batchPath = FileStorageUtil.getFileBakPath(bankVersionId) + File.separator + transDateStr + File.separator + bankLoginID + "_batch";
        File bakFile = FileCommonUtils.getFileByPath(batchPath);
        if (!bakFile.exists()) {
            bakFile.mkdirs();
        }
        return batchPath;
    }

    public static String getStorageRootPath() {
        EBContext context = EBContext.getContext();
        String customID = context.getCustomID();
        String storageRootPath = FileCommonUtils.checkPath(System.getProperty("user.dir"));
        FileStorageUtil.checkAndCreatePath(storageRootPath + File.separator + "receipt" + File.separator + customID);
        return storageRootPath + File.separator + "receipt" + File.separator + customID;
    }

    private static String getPath(String ftpRootPath, String path, String bankVersionID) {
        StringBuilder sb = new StringBuilder();
        sb.append(ftpRootPath).append(File.separator).append(path).append(File.separator).append(bankVersionID);
        String fixedPath = sb.toString();
        FileStorageUtil.checkAndCreatePath(fixedPath);
        return fixedPath;
    }

    private static void checkAndCreatePath(String path) {
        File file = FileCommonUtils.getFileByPath(path);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8def\u5f84:%s \u53d1\u751f\u5f02\u5e38\u3002", (String)"FileStorageUtil_2", (String)"ebg-receipt-common", (Object[])new Object[0]), path), e);
            }
        }
    }
}

