/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.services.receipt;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.repository.receipt.DownloadListDetailRepository;

@Service
public class DownloadListDetailService {
    @Autowired
    private DownloadListDetailRepository repository;

    public List<DownloadListDetail> saveAll(List<DownloadListDetail> details) {
        this.repository.saveAll(details);
        return details;
    }

    public void deleteById(long id) {
        this.repository.deleteById(id);
    }

    public void deleteById(List<Long> ids) {
        this.repository.deleteAllByIds(ids);
    }

    public List<DownloadListDetail> selectByRefIdAndFailStatus(Long refId) {
        return this.repository.findByRefidAndStatus(refId.toString(), 4);
    }

    public void deleteAll(List<Long> ids) {
        this.repository.deleteAllByIds(ids);
    }

    public DownloadListDetail selectByfileNameAndRefId(String filaName, long refId) {
        return this.repository.findByRefidAndFileName(refId, filaName);
    }

    public List<DownloadListDetail> selectByRefId(Long refId) {
        return this.repository.findByRefid(refId);
    }

    public List<DownloadListDetail> selectByUploadFlag(List<Integer> uploadFlags) {
        return this.repository.selectByUploadFlag(uploadFlags);
    }

    public List<DownloadListDetail> selectByRefidAndUploadFlag(String refid, List<Integer> uploadFlags) {
        return this.repository.selectByRefidAndUploadFlag(refid, uploadFlags);
    }

    public List<DownloadListDetail> findByRefids(List<Long> refid) {
        return this.repository.findByRefids(refid);
    }

    public DownloadListDetail save(DownloadListDetail detail) {
        try {
            return this.repository.save(detail);
        }
        catch (Exception e) {
            return this.repository.save(detail);
        }
    }

    public DownloadListDetail update(DownloadListDetail detail) {
        try {
            this.repository.update(detail);
        }
        catch (Exception e) {
            this.repository.update(detail);
        }
        return detail;
    }

    public void updateAll(List<DownloadListDetail> details) {
        this.repository.updateAll(details);
    }

    public List<DownloadListDetail> findByCustomIdAndBankVersionAndTransDate(String customId, String bankVersion, LocalDate transDate) {
        return this.repository.findByCustomIdAndBankVersionAndTransDate(customId, bankVersion, transDate);
    }

    public List<DownloadListDetail> findByCustomIdAndBankVersionAndBetweenTransDate(String customId, String bankVersion, LocalDate startTransDate, LocalDate endTransDate) {
        return this.repository.findByCustomIdAndBankVersionAndBetweenTransDate(customId, bankVersion, startTransDate, endTransDate);
    }

    public int countDetailByCustomerBankAndTransDate(String customId, String bankVersionId, LocalDate transDate) {
        return this.repository.countDetailByCustomerBankAndTransDate(customId, bankVersionId, transDate);
    }

    public void deleteBatchByRefIds(List<Long> refIds) {
        this.repository.deleteBatchByRefIds(refIds);
    }

    public List<Long> findBatchByRefIds(List<Long> refIds) {
        ArrayList<Long> detailIds = new ArrayList<Long>(1);
        DynamicObject[] dynamicObjects = this.repository.findBatchByRefIds(refIds);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long id = dynamicObject.getLong("id");
                detailIds.add(id);
            }
        }
        return detailIds;
    }
}

