/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.services.reconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.model.bank.login.BankLoginKey;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.constant.TaskStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.bank.BankReconciliationProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadTaskRepository;

@Service
public class ReconciliationDownloadTaskService {
    private final ReconciliationDownloadTaskRepository reconciliationDownloadTaskRepository;

    public ReconciliationDownloadTaskService(ReconciliationDownloadTaskRepository reconciliationDownloadTaskRepository) {
        this.reconciliationDownloadTaskRepository = reconciliationDownloadTaskRepository;
    }

    public List<ReconciliationInfo> findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, String bankLoginID, LocalDate startDate, LocalDate endDate) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findByAccNoAndBankVersionIDAndTransDateBetween(accNo, bankVersionID, bankLoginID, startDate, endDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public ReconciliationInfo findById(long id) {
        DynamicObject dynamicObject = this.reconciliationDownloadTaskRepository.findById(id);
        ReconciliationInfo task = this.toReceiptDownloadTaskInfo(dynamicObject);
        return task;
    }

    public List<ReconciliationInfo> findByBankVersionIDAndTransDateAndCustomId(String bankVersionID, LocalDate startDate, String customId) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findByBankVersionIDAndTransDateAndCustomId(bankVersionID, startDate, customId);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findByAccNoAndCoustomIdAndBankVersionAndBankLoginAndStatusList(String accNo, String customId, String bankVersion, String bankLogin, List<Integer> statusArray) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findByAccNoAndCoustomIdAndBankVersionAndBankLoginAndStatusList(accNo, customId, bankVersion, bankLogin, statusArray);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findByCoustomIdAndStatusListAndBankVersionAndTransDate(String customId, List<Integer> statusArray, String bankVersionId, LocalDate transDate) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findTodayByCoustomIdAndStatusListAndBankVersionAndTransDate(customId, statusArray, bankVersionId, transDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findByCoustomIdAndStatusListAndBankVersion(String customId, List<Integer> statusArray, String bankVersionId) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>();
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findByCoustomIdAndStatusListAndBankVersion(customId, statusArray, bankVersionId);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(String customId, List<Integer> statusArray, String bankVersionId, LocalDate transDate, String bankLogin) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findTodayByCoustomIdAndStatusListAndBankVersionAndTransDateAndBankLogin(customId, statusArray, bankVersionId, transDate, bankLogin);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findByStatus(Integer status) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findByStatus(status);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public List<ReconciliationInfo> findUnUploadCompleteTaskByBankVersionAndCustomId(String customId, String bankVersion, LocalDate startDate, LocalDate endDate) {
        ArrayList<ReconciliationInfo> detailInfos = new ArrayList<ReconciliationInfo>(16);
        DynamicObject[] dynamicObjects = this.reconciliationDownloadTaskRepository.findUnUploadCompleteTaskByBankVersionAndCustomId(customId, bankVersion, startDate, endDate);
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailInfos.add(this.toReceiptDownloadTaskInfo(dynamicObjects[i]));
            }
        }
        return detailInfos;
    }

    public void save(ReconciliationInfo receiptDownloadTaskEntity) {
        DynamicObject dynamicObject = this.packDetailInfo(null, receiptDownloadTaskEntity);
        this.reconciliationDownloadTaskRepository.save(dynamicObject);
    }

    public void update(ReconciliationInfo receiptDownloadTaskEntity) {
        DynamicObject dynamicObject = this.reconciliationDownloadTaskRepository.findById(receiptDownloadTaskEntity.getId());
        dynamicObject = this.packDetailInfo(dynamicObject, receiptDownloadTaskEntity);
        this.reconciliationDownloadTaskRepository.update(dynamicObject);
    }

    private ReconciliationInfo toReceiptDownloadTaskInfo(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        ReconciliationInfo receiptDownloadTask = new ReconciliationInfo();
        receiptDownloadTask.setId(dynamicObject.getLong("id"));
        receiptDownloadTask.setBankLoginId(dynamicObject.getString("bank_login.number"));
        receiptDownloadTask.setBankVersionId(dynamicObject.getString("bank_version.number"));
        if (RequestContextUtils.isAccNoOfReconciliationByBank(receiptDownloadTask.getBankVersionId())) {
            receiptDownloadTask.setAccNo(dynamicObject.getString("acc_no.number"));
        }
        receiptDownloadTask.setTransDate(LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("trans_date")));
        receiptDownloadTask.setStatus(Integer.parseInt(dynamicObject.getString("status")));
        receiptDownloadTask.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        receiptDownloadTask.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        Date completeTime = dynamicObject.getDate("complete_time");
        if (completeTime != null) {
            receiptDownloadTask.setCompleteTime(LocalDateUtil.date2LocalDateTime((Date)completeTime));
        }
        receiptDownloadTask.setExpmsg(dynamicObject.getString("exp_msg"));
        int redo = dynamicObject.getInt("redo");
        receiptDownloadTask.setRedo(redo);
        String uploadFlag = dynamicObject.getString("upload_flag");
        if (!EBGStringUtils.isEmpty(uploadFlag)) {
            receiptDownloadTask.setUploadFlag(Integer.parseInt(uploadFlag));
        }
        receiptDownloadTask.setCustomNo(dynamicObject.getString("custom_id"));
        int uploadNum = dynamicObject.getInt("upload_num");
        receiptDownloadTask.setUploadNum(uploadNum);
        int reconciliationNum = dynamicObject.getInt("reconcilia_num");
        receiptDownloadTask.setReconciliationNum(reconciliationNum);
        return receiptDownloadTask;
    }

    private DynamicObject packDetailInfo(DynamicObject dynamicObject, ReconciliationInfo info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"reconcilia_download_task");
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("complete_time", (Object)LocalDateUtil.localDateTime2Date((LocalDateTime)info.getCompleteTime()));
        dynamicObject.set("exp_msg", (Object)info.getExpmsg());
        dynamicObject.set("upload_flag", (Object)info.getUploadFlag());
        BankLoginRepository bankLoginRepository = BankLoginRepository.getInstance();
        BankLoginKey bankLoginKey = new BankLoginKey();
        bankLoginKey.setBankLoginId(info.getBankLoginId());
        bankLoginKey.setCustomId(info.getCustomNo());
        DynamicObject bankLogin = bankLoginRepository.findDynamicByIdAndCustomId(bankLoginKey);
        dynamicObject.set("bank_login", (Object)bankLogin);
        BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
        DynamicObject bankVersion = bankVersionRepository.loadDynamicObjectByBankVersionID(info.getBankVersionId());
        dynamicObject.set("bank_version", (Object)bankVersion);
        if (RequestContextUtils.isAccNoOfReconciliationByBank(info.getBankVersionId())) {
            BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
            DynamicObject bankAcct = bankAcntRepository.findDataByAccNoAndCustomId(info.getAccNo(), info.getCustomNo());
            dynamicObject.set("acc_no", (Object)bankAcct);
        }
        Date transDate = LocalDateUtil.localDate2Date((LocalDate)info.getTransDate());
        dynamicObject.set("trans_date", (Object)transDate);
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("redo", (Object)info.getRedo().toString());
        dynamicObject.set("custom_id", (Object)info.getCustomNo());
        dynamicObject.set("upload_num", (Object)info.getUploadNum());
        dynamicObject.set("reconcilia_num", (Object)info.getReconciliationNum());
        return dynamicObject;
    }

    public void buildReceiptTaskDynamicObjects(List<DynamicObject> newTaskList, String bankVersion, LocalDate startDate, LocalDate endDate, DynamicObject accnoDynamicObject, String customID) {
        this.buildReceiptTaskDynamicObjects(newTaskList, bankVersion, startDate, endDate, accnoDynamicObject, customID, null);
    }

    public void buildReceiptTaskDynamicObjects(List<DynamicObject> newTaskList, String bankVersion, LocalDate startDate, LocalDate endDate, DynamicObject accnoDynamicObject, String customID, Map<LocalDate, String> needUpdReceiptInfoMap) {
        String accNo = null;
        if (RequestContextUtils.isAccNoOfReconciliationByBank(bankVersion)) {
            accNo = accnoDynamicObject.getString("number");
        }
        String bankLoginId = accnoDynamicObject.getString("bank_login.number");
        BankReconciliationProperties bankBusinessProperties = EBConfigBuilder.getInstance().buildConfig(BankReconciliationProperties.class, bankLoginId);
        boolean isMonthReconciliation = Objects.equals(bankBusinessProperties.getIsMonthReconciliation(), "true");
        if (isMonthReconciliation) {
            String startDateStr = LocalDateUtil.formatDate((LocalDate)startDate);
            startDateStr = startDateStr.substring(0, 6) + "01";
            startDate = LocalDateUtil.parserDate((String)startDateStr);
            String endDateStr = LocalDateUtil.formatDate((LocalDate)endDate);
            endDateStr = endDateStr.substring(0, 6) + "01";
            endDate = LocalDateUtil.parserDate((String)endDateStr);
        }
        DynamicObjectCollection tasks = this.reconciliationDownloadTaskRepository.selectByBankVersionAndAccnoAndTransDateBetween(bankVersion, accNo, LocalDateUtil.localDate2Date((LocalDate)startDate), LocalDateUtil.localDate2Date((LocalDate)endDate), bankLoginId);
        ArrayList existTransDates = new ArrayList(16);
        tasks.stream().forEach(t -> {
            Date date = t.getDate("trans_date");
            if (!existTransDates.contains(date)) {
                existTransDates.add(date);
            }
        });
        if (isMonthReconciliation) {
            HashMap existTransDateMaps = Maps.newHashMapWithExpectedSize((int)16);
            tasks.stream().forEach(t -> {
                String dateStr;
                Date date = t.getDate("trans_date");
                if (date != null && !existTransDateMaps.containsKey(dateStr = DateUtil.formatDate((Date)date, (String)"yyyyMM"))) {
                    existTransDateMaps.put(dateStr, dateStr);
                }
            });
            List monthsBetweenDate = LocalDateUtil.getMonthsBetweenDate((LocalDate)startDate, (LocalDate)endDate);
            for (String month : monthsBetweenDate) {
                if (existTransDateMaps.containsKey(month)) continue;
                Date transDate = DateUtil.string2Date((String)(month + "01"), (String)"yyyyMMdd");
                DynamicObject newTask = this.buildReceiptTaskDynamicObject((DynamicObject)accnoDynamicObject.get("group"), (DynamicObject)accnoDynamicObject.get("bank_login"), accnoDynamicObject, transDate);
                newTaskList.add(newTask);
            }
        } else {
            long days = endDate.toEpochDay() - startDate.toEpochDay();
            int i = 0;
            while ((long)i <= days) {
                LocalDate date = LocalDateUtil.getDayAfter((LocalDate)startDate, (int)i);
                Date transDate = LocalDateUtil.localDate2Date((LocalDate)date);
                if (!existTransDates.contains(transDate)) {
                    DynamicObject newTask = this.buildReceiptTaskDynamicObject((DynamicObject)accnoDynamicObject.get("group"), (DynamicObject)accnoDynamicObject.get("bank_login"), accnoDynamicObject, transDate);
                    newTaskList.add(newTask);
                }
                ++i;
            }
        }
    }

    DynamicObject buildReceiptTaskDynamicObject(DynamicObject bankVersion, DynamicObject bankLogin, DynamicObject accNo, Date transDate) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"reconcilia_download_task");
        dataEntity.set("bank_version", (Object)bankVersion);
        dataEntity.set("bank_login", (Object)bankLogin);
        if (RequestContextUtils.isAccNoOfReconciliationByBank(bankVersion.getString("number"))) {
            dataEntity.set("acc_no", (Object)accNo);
        }
        dataEntity.set("trans_date", (Object)transDate);
        Date date = new Date();
        dataEntity.set("createtime", (Object)date);
        dataEntity.set("modifytime", (Object)date);
        dataEntity.set("status", (Object)TaskStatusEnum.CREATE.getId());
        dataEntity.set("upload_flag", (Object)UploadTaskStatusEnum.UN_UPLOAD.getId());
        dataEntity.set("custom_id", (Object)RequestContext.get().getTenantId());
        return dataEntity;
    }
}

