/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.front.api.boot.utils;

import com.google.common.base.Preconditions;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.entity.service.EBBaseRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;

public class FrontCheckUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FrontCheckUtil.class);
    private static final long TIME_STAMP_1S = 1000L;

    public static boolean checkTimeLimited(EBBaseRequest request, long milliSecond) {
        return FrontCheckUtil.checkTimeLimited(request, milliSecond, 1000L);
    }

    public static boolean checkTimeLimited(EBBaseRequest request, long milliSecond, long timeTolerate) {
        long timeNow = System.currentTimeMillis();
        return timeNow - milliSecond <= request.getTimestamp() && request.getTimestamp() <= timeNow + timeTolerate;
    }

    public static void checkRequest(EBBaseRequest request, String customID) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"request \u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        if (request != null) {
            String customerID = request.getCustomerID();
            Preconditions.checkArgument((!StringUtils.isBlank(customerID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"customerID \u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_1", (String)"ebg-receipt-common", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)customerID.equals(customID), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42customerID \u4e0d\u4e00\u81f4\u3002", (String)"FrontCheckUtil_2", (String)"ebg-receipt-common", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getTimestamp()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u95f4\u6233\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_3", (String)"ebg-receipt-common", (Object[])new Object[0]));
        }
    }

    public static void checkRequest(EBBaseRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"request \u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_0", (String)"ebg-receipt-common", (Object[])new Object[0]));
        if (request != null) {
            String customerID = request.getCustomerID();
            Preconditions.checkArgument((!StringUtils.isBlank(customerID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"customerID \u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_1", (String)"ebg-receipt-common", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getTimestamp()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u65f6\u95f4\u6233\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_3", (String)"ebg-receipt-common", (Object[])new Object[0]));
        }
    }

    public static boolean checkIPAllow(String ip, String allowIPStrings, String blockIPStrings) {
        boolean allow = true;
        boolean block = false;
        if (!Objects.isNull(allowIPStrings)) {
            allow = FrontCheckUtil.match(ip, allowIPStrings);
        }
        if (!Objects.isNull(blockIPStrings)) {
            block = FrontCheckUtil.match(ip, blockIPStrings);
        }
        return allow && !block;
    }

    private static String[] getIP(String ipStrings) {
        Preconditions.checkArgument((boolean)Objects.nonNull(ipStrings), (Object)ResManager.loadKDString((String)"ipStrings \u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_4", (String)"ebg-receipt-common", (Object[])new Object[0]));
        if (ipStrings != null) {
            return ipStrings.split("\n");
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"ipStrings \u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"FrontCheckUtil_4", (String)"ebg-receipt-common", (Object[])new Object[0]));
    }

    public static boolean match(String ip, String ipStrings) {
        return FrontCheckUtil.match(ip, FrontCheckUtil.getIP(ipStrings));
    }

    public static boolean match(String ip, String[] ipLists) {
        boolean flag = false;
        for (String key : ipLists) {
            if (!ip.equals(key)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

