/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository.receipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.model.receipt.EBCBdMatchParam;

@Component
public class EBCMatchParamRepository {
    private static final String DETAILINFO_ENTITY = "receipt_bd_match_param";
    private static final String SELECT_ALL_PROPERTIES = "id,number,name,detail_param,receipt_param,ref_id,modifytime,createtime";

    public void save(EBCBdMatchParam info) {
        DynamicObject dynamicObject = this.packEBCBdMatchParam(null, info);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void update(EBCBdMatchParam info) {
        DynamicObject dynamicObject = this.findOneById(info.getId());
        dynamicObject = this.packEBCBdMatchParam(dynamicObject, info);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void deleteById(Long id) {
        if (id != null) {
            QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
            DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
        }
    }

    public void delete(EBCBdMatchParam info) {
        long id = info.getId();
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DeleteServiceHelper.delete((String)DETAILINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public EBCBdMatchParam findById(long id) {
        DynamicObject dynamicObject = this.findOneById(id);
        if (dynamicObject != null) {
            EBCBdMatchParam info = this.toEBCBdMatchParam(dynamicObject);
            return info;
        }
        return null;
    }

    public DynamicObject findOneById(long id) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObject;
    }

    public List<EBCBdMatchParam> findByRefId(String refId) {
        String expressionStr;
        StringBuilder expression = new StringBuilder();
        ArrayList<String> paramsList = new ArrayList<String>(16);
        if (!EBGStringUtils.isEmpty(refId)) {
            expression.append("and ref_id=?").append(' ');
            paramsList.add(refId);
        }
        if (!EBGStringUtils.isEmpty(expressionStr = expression.toString())) {
            expressionStr = expression.toString().substring(3);
        }
        QFilter filter = QFilter.of((String)expressionStr, (Object[])paramsList.toArray());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        ArrayList<EBCBdMatchParam> ebcBdMatchParamList = new ArrayList<EBCBdMatchParam>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            EBCBdMatchParam info = this.toEBCBdMatchParam(dynamicObject);
            ebcBdMatchParamList.add(info);
        }
        return ebcBdMatchParamList;
    }

    private EBCBdMatchParam toEBCBdMatchParam(DynamicObject dynamicObject) {
        EBCBdMatchParam info = new EBCBdMatchParam();
        info.setId(dynamicObject.getLong("id"));
        info.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        info.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        info.setDetailParam(dynamicObject.getString("detail_param"));
        info.setReceiptParam(dynamicObject.getString("receipt_param"));
        info.setName(dynamicObject.getString("name"));
        info.setNumber(dynamicObject.getString("number"));
        info.setRefid(dynamicObject.getString("ref_id"));
        return info;
    }

    private DynamicObject packEBCBdMatchParam(DynamicObject dynamicObject, EBCBdMatchParam info) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY);
            dynamicObject.set("createtime", (Object)new Date());
        } else {
            dynamicObject.set("id", (Object)info.getId());
        }
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("detail_param", (Object)info.getDetailParam());
        dynamicObject.set("receipt_param", (Object)info.getReceiptParam());
        dynamicObject.set("name", (Object)info.getName());
        dynamicObject.set("number", (Object)info.getNumber());
        dynamicObject.set("ref_id", (Object)info.getRefid());
        return dynamicObject;
    }
}

